/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import jdbm.helper.LongPacker;
import jdbm.helper.Serialization;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HashBucket<K, V>
extends HashNode<K, V> {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList<K> _keys;
    private ArrayList<V> _values;

    public HashBucket() {
    }

    public HashBucket(int level) {
        if (level > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keys = new ArrayList(8);
        this._values = new ArrayList(8);
    }

    public int getElementCount() {
        return this._keys.size();
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public V addElement(K key, V value) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V before = this._values.get(existing);
            this._values.set(existing, value);
            return before;
        }
        this._keys.add(key);
        this._values.add(value);
        return null;
    }

    public V removeElement(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V obj = this._values.get(existing);
            this._keys.remove(existing);
            this._values.remove(existing);
            return obj;
        }
        return null;
    }

    public V getValue(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            return this._values.get(existing);
        }
        return null;
    }

    ArrayList<K> getKeys() {
        return this._keys;
    }

    ArrayList<V> getValues() {
        return this._values;
    }

    public void writeExternal(DataOutputStream out) throws IOException {
        LongPacker.packInt(out, this._depth);
        Serialization.writeObject(out, this._keys);
        for (int i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) continue;
            Serialization.writeObject(out, this._values.get(i));
        }
    }

    public void readExternal(DataInputStream in) throws IOException, ClassNotFoundException {
        this._depth = LongPacker.unpackInt(in);
        this._keys = (ArrayList)Serialization.readObject(in);
        this._values = new ArrayList(this._keys.size());
        for (int i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) {
                this._values.add(null);
                continue;
            }
            this._values.add(Serialization.readObject(in));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashBucket {depth=");
        buf.append(this._depth);
        buf.append(", keys=");
        buf.append(this._keys);
        buf.append(", values=");
        buf.append(this._values);
        buf.append("}");
        return buf.toString();
    }
}

