/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities;

import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.CapabilityDialog;
import SK.gnome.morena.MorenaImage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Capabilities
implements ActionListener {
    protected ArrayList<Capability> allCapabilities;
    protected Properties properties;
    protected String sourceName;
    protected String sourceValidFileName;
    protected boolean restartAfterPreview;
    protected int sleepTimeBeforeRestart;
    protected Component centerPanel;
    protected Frame frame;
    protected CapabilityDialog dialogWindow;
    public static boolean debug = Boolean.valueOf(System.getProperty("morena.capabilities.debug", "false"));

    public abstract MorenaImage getPreviewImage() throws Exception;

    public abstract String getSourceName();

    public ArrayList<Capability> getCapabilities() {
        return this.allCapabilities;
    }

    public String getSourceValidFileName() {
        return this.sourceValidFileName;
    }

    public Capability getCapability(String name) {
        for (Capability capability : this.allCapabilities) {
            String temp = capability.getName();
            if (null == temp || !temp.equals(name)) continue;
            return capability;
        }
        return null;
    }

    public boolean isRestartAfterPreview() {
        return this.restartAfterPreview;
    }

    public void setRestartAfterPreview(boolean restartAfterPreview) {
        this.restartAfterPreview = restartAfterPreview;
    }

    public int getSleepTimeBeforeRestart() {
        return this.sleepTimeBeforeRestart;
    }

    public void setSleepTimeBeforeRestart(int sleepTimeAfterRestart) {
        this.sleepTimeBeforeRestart = sleepTimeAfterRestart;
    }

    public String makeFileNameValid(String string) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            Character ch = Character.valueOf(string.charAt(i));
            if (!Character.isJavaIdentifierPart(ch.charValue())) continue;
            s.append(ch);
        }
        return s.toString();
    }
}

