/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.MyBasicComboBoxUI;
import SK.gnome.capabilities.PreviewPanel;
import SK.gnome.capabilities.sane.SaneActivity;
import SK.gnome.morena.MorenaConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CapabilityDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
MorenaConstants {
    private ArrayList editors;
    private Frame frame;
    private String sourceName;
    private Vector rows;
    private Vector columns;
    private JTable selectedCapabilitiesTable;
    private final String[] headers = new String[]{MORENA_MESSAGES.getString("NAME"), MORENA_MESSAGES.getString("DEFAULT_VALUE"), MORENA_MESSAGES.getString("VALUE")};
    private int returnValue = -1;
    private Capabilities capabilities;
    public final Object[] longValues = new Object[]{"Name", "Default value", "Value"};

    public CapabilityDialog(Frame frame, Capabilities capabilities) {
        super(frame, capabilities.getSourceName(), true);
        this.frame = frame;
        this.sourceName = capabilities.getSourceName();
        this.capabilities = capabilities;
        Container contentPane = this.getContentPane();
        JPanel capabilitiesPanel = new JPanel();
        capabilitiesPanel.setLayout(new BoxLayout(capabilitiesPanel, 1));
        capabilitiesPanel.setAlignmentX(0.0f);
        for (Capability capability : capabilities.getCapabilities()) {
            capability.addListener(this);
        }
        this.columns = new Vector();
        for (int i = 0; i < this.headers.length; ++i) {
            this.columns.addElement(this.headers[i]);
        }
        DefaultTableModel tabModel = new DefaultTableModel();
        tabModel.setDataVector(this.rows, this.columns);
        this.selectedCapabilitiesTable = new JTable(tabModel){

            public TableCellEditor getCellEditor(int row, int column) {
                int modelColumn = this.convertColumnIndexToModel(column);
                if (modelColumn == 2 && null != CapabilityDialog.this.editors.get(row)) {
                    return (TableCellEditor)CapabilityDialog.this.editors.get(row);
                }
                return super.getCellEditor(row, column);
            }

            public boolean isCellEditable(int row, int column) {
                int modelColumn = this.convertColumnIndexToModel(column);
                return modelColumn == 2 && null != CapabilityDialog.this.editors.get(row);
            }
        };
        this.selectedCapabilitiesTable.setAlignmentX(0.0f);
        this.updateCapabilitiesTable();
        JTableHeader th1 = this.selectedCapabilitiesTable.getTableHeader();
        th1.setAlignmentX(0.0f);
        capabilitiesPanel.add(th1);
        capabilitiesPanel.add(this.selectedCapabilitiesTable);
        capabilitiesPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        String buttonText = capabilities instanceof SaneActivity ? MORENA_MESSAGES.getString("SELECT_OPTIONS") : MORENA_MESSAGES.getString("SELECT_CAPABILITIES");
        JButton button2 = new JButton(buttonText);
        button2.addActionListener(capabilities);
        button2.setActionCommand("selectCapabilitiesButton");
        button2.setAlignmentX(0.0f);
        capabilitiesPanel.add(button2);
        JScrollPane scrollPane = new JScrollPane(capabilitiesPanel);
        scrollPane.setBorder(BorderFactory.createTitledBorder(""));
        PreviewPanel previewPanel = new PreviewPanel(capabilities);
        JSplitPane splitPane = new JSplitPane(1, scrollPane, previewPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(360);
        contentPane.add(splitPane);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton(MORENA_MESSAGES.getString("SCAN"));
        button.setFont(new Font("Arial", 1, 24));
        button.setActionCommand("scanButton");
        button.addActionListener(this);
        button.setAlignmentX(0.0f);
        bottomPanel.add(button);
        contentPane.add((Component)bottomPanel, "Last");
        this.selectedCapabilitiesTable.setPreferredScrollableViewportSize(this.selectedCapabilitiesTable.getPreferredSize());
        this.selectedCapabilitiesTable.addNotify();
        this.setLocationByPlatform(true);
        this.pack();
    }

    private void initColumnSizes(JTable table) {
        TableModel model = table.getModel();
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < 2; ++i) {
            column = table.getColumnModel().getColumn(i);
            comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            headerWidth = comp.getPreferredSize().width;
            comp = table.getDefaultRenderer(model.getColumnClass(i)).getTableCellRendererComponent(table, this.longValues[i], false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("scanButton")) {
            this.capabilities.properties.clear();
            for (Capability capability : this.capabilities.getCapabilities()) {
                if (!capability.isSelected()) continue;
                this.capabilities.properties.put(capability.getName(), String.valueOf(capability.getValue()));
            }
            this.capabilities.properties.put("restartAfterPreview", String.valueOf(this.capabilities.isRestartAfterPreview()));
            this.capabilities.properties.put("sleepTimeBeforeRestart", String.valueOf(this.capabilities.getSleepTimeBeforeRestart()));
            this.returnValue = 0;
            try {
                File file = new File(System.getProperty("user.home") + "/.morena/" + this.capabilities.getSourceValidFileName());
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                this.capabilities.properties.store(new FileOutputStream(file), null);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Exception during storing the properties file", 0);
                ex.printStackTrace();
            }
            this.dispose();
        }
    }

    public void updateCapabilitiesTable() {
        this.rows = new Vector();
        this.editors = new ArrayList(this.capabilities.getCapabilities().size());
        for (Capability capability : this.capabilities.getCapabilities()) {
            DefaultCellEditor dce;
            if (!capability.isSelected()) continue;
            Vector<Object> temp = new Vector<Object>();
            temp.addElement(capability.getTitle());
            Object defaultValue = null;
            try {
                defaultValue = capability.getDefaultValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            temp.addElement(defaultValue);
            Object value = null;
            value = capability.getValue();
            temp.addElement(value);
            this.rows.addElement(temp);
            Object[] supported = capability.getSupportedValues();
            if (capability.isSetMethodSupported()) {
                if (null != supported) {
                    JComboBox<Object> comboBox = new JComboBox<Object>(supported);
                    comboBox.setEditable(true);
                    if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                        comboBox.setUI(new MyBasicComboBoxUI());
                    }
                    comboBox.setActionCommand("tableComboBox");
                    comboBox.addActionListener(capability);
                    dce = new DefaultCellEditor(comboBox){

                        public boolean shouldSelectCell(EventObject anEvent) {
                            return false;
                        }
                    };
                } else {
                    JTextField textField = new JTextField();
                    textField.setActionCommand("tableTextField");
                    textField.addActionListener(capability);
                    textField.addFocusListener(capability);
                    dce = new DefaultCellEditor(textField);
                }
            } else {
                dce = null;
            }
            this.editors.add(dce);
        }
        ((DefaultTableModel)this.selectedCapabilitiesTable.getModel()).setDataVector(this.rows, this.columns);
        this.selectedCapabilitiesTable.setPreferredScrollableViewportSize(this.selectedCapabilitiesTable.getPreferredSize());
        this.selectedCapabilitiesTable.addNotify();
        this.validate();
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateCapabilitiesTable();
    }
}

