/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.PreviewCanvas;
import SK.gnome.morena.MorenaConstants;
import SK.gnome.morena.MorenaImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PreviewPanel
extends JPanel
implements ActionListener {
    private PreviewCanvas previewCanvas;
    private Capabilities capabilities;

    public PreviewPanel(Capabilities capabilities) {
        this.capabilities = capabilities;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.previewCanvas = new PreviewCanvas(capabilities.getCapability("tl-x"), capabilities.getCapability("tl-y"), capabilities.getCapability("br-x"), capabilities.getCapability("br-y"));
        this.add((Component)this.previewCanvas, "Center");
        JPanel bottomPanel = new JPanel();
        JButton previewButton = new JButton(MorenaConstants.MORENA_MESSAGES.getString("PREVIEW"));
        previewButton.setActionCommand("previewButton");
        previewButton.addActionListener(this);
        bottomPanel.add(previewButton);
        JPanel temp3 = new JPanel();
        temp3.add(bottomPanel);
        temp3.setAlignmentX(0.5f);
        this.add((Component)temp3, "Last");
        this.setPreferredSize(new Dimension(475, 535));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("previewButton")) {
            Cursor previousCursor = this.getTopLevelAncestor().getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                MorenaImage morenaImage = this.capabilities.getPreviewImage();
                if (0 < morenaImage.getWidth() && 0 < morenaImage.getHeight()) {
                    Image image = Toolkit.getDefaultToolkit().createImage(morenaImage);
                    this.previewCanvas.setImage(image);
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
                e1.printStackTrace();
            }
            this.setCursor(previousCursor);
        }
    }
}

