/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.twain;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.CapabilityDialog;
import SK.gnome.capabilities.twain.TwainCapability;
import SK.gnome.capabilities.twain.TwainFrameBR_XCapability;
import SK.gnome.capabilities.twain.TwainFrameBR_YCapability;
import SK.gnome.capabilities.twain.TwainFrameCapability;
import SK.gnome.capabilities.twain.TwainFrameTL_XCapability;
import SK.gnome.capabilities.twain.TwainFrameTL_YCapability;
import SK.gnome.capabilities.twain.TwainSelectCapabilitiesDialog;
import SK.gnome.morena.MorenaImage;
import SK.gnome.twain.TwainConstants;
import SK.gnome.twain.TwainException;
import SK.gnome.twain.TwainManager;
import SK.gnome.twain.TwainSource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;

public class TwainActivity
extends Capabilities {
    static final int INT = 0;
    static final int DOUBLE = 1;
    static final int BOOLEAN = 2;
    static final int STRING = 3;
    static final String[][] CAPABILITY_NAMES = new String[][]{{"Alarms", "int", "TWAL"}, {"AlarmVolume", "int", null}, {"AudioFileFormat", "int", "TWAF"}, {"AudioTransferMech", "int", null}, {"Author", "string", null}, {"AutoBright", "boolean", null}, {"AutoFeed", "boolean", null}, {"AutomaticBorderDetection", "boolean", null}, {"AutomaticCapture", "int", null}, {"AutomaticDeskew", "boolean", null}, {"AutomaticRotate", "boolean", null}, {"AutoScan", "boolean", null}, {"BarCodeDetectionEnabled", "boolean", null}, {"BarCodeMaxRetries", "int", null}, {"BarCodeMaxSearchPriorities", "int", null}, {"BarCodeSearchMode", "int", "TWBD"}, {"BarCodeSearchPriorities", "int", "TWBT"}, {"BarCodeTimeout", "int", null}, {"BatteryMinutes", "int", null}, {"BatteryPercentage", "int", null}, {"BitDepth", "int", null}, {"BitDepthReduction", "int", "TWBR"}, {"BitOrder", "int", "TWBO"}, {"BitOrderCodes", "int", "TWBO"}, {"Brightness", "double", null}, {"CameraPreviewUI", "boolean", null}, {"Caption", "string", null}, {"CCITTKFactor", "int", null}, {"ClearBuffers", "int", "TWCB"}, {"Compression", "int", "TWCP"}, {"Contrast", "double", null}, {"CustHalfTone", "int", null}, {"CustomDSData", "boolean", null}, {"DeviceEvent", "int", "TWDE"}, {"DeviceOnLine", "boolean", null}, {"DeviceTimeDate", "string", null}, {"Duplex", "int", "TWDX"}, {"DuplexEnabled", "boolean", null}, {"EnableDSUIOnly", "boolean", null}, {"Endorser", "int", null}, {"ExposureTime", "double", null}, {"ExtendedCaps", "int", null}, {"ExtImageInfo", "boolean", null}, {"FeederAlignment", "int", "TWFA"}, {"FeederEnabled", "boolean", null}, {"FeederLoaded", "boolean", null}, {"FeederOrder", "int", "TWFO"}, {"Filter", "int", "TWFT"}, {"FlashUsed", "int", "TWFL"}, {"FlipRotation", "int", "TWFR"}, {"Gamma", "double", null}, {"Halftones", "string", null}, {"Highlight", "double", null}, {"ImageDataSet", "int", null}, {"ImageFileFormat", "int", "TWFF"}, {"ImageFilter", "int", "TWIF"}, {"Indicators", "boolean", null}, {"JobControl", "int", "TWJC"}, {"JPEGPixelType", "int", "TWPT"}, {"JPEGQuality", "int", "TWJQ"}, {"LampState", "boolean", null}, {"Language", "int", "TWLG"}, {"LightPath", "int", "TWLP"}, {"LightSource", "int", "TWLS"}, {"MaxBatchBuffers", "int", null}, {"MinimumHeight", "double", null}, {"MinimumWidth", "double", null}, {"NoiseFilter", "int", "TWNF"}, {"Orientation", "int", "TWOR"}, {"Overscan", "int", "TWOV"}, {"PaperDetectable", "boolean", null}, {"PatchCodeDetectionEnabled", "boolean", null}, {"PatchCodeMaxRetries", "int", null}, {"PatchCodeMaxSearchPriorities", "int", null}, {"PatchCodeSearchMode", "int", "TWBD"}, {"PatchCodeSearchPriorities", "int", null}, {"PatchCodeTimeout", "int", null}, {"PhysicalHeight", "double", null}, {"PhysicalWidth", "double", null}, {"PixelFlavor", "int", "TWPF"}, {"PixelFlavorCodes", "int", "TWPF"}, {"PixelType", "int", "TWPT"}, {"PlanarChunky", "int", "TWPC"}, {"PowerSupply", "int", null}, {"Printer", "int", "TWPR"}, {"PrinterEnabled", "boolean", null}, {"PrinterIndex", "int", null}, {"PrinterMode", "int", null}, {"PrinterString", "string", null}, {"PrinterSuffix", "string", null}, {"ReacquireAllowed", "int", null}, {"Rotation", "double", null}, {"SerialNumber", "string", null}, {"Shadow", "double", null}, {"SupportedBarCodeTypes", "int", "TWBT"}, {"SupportedCaps", "int", null}, {"SupportedPathCodeTypes", "int", null}, {"SupportedSizes", "int", "TWSS"}, {"Threshold", "double", null}, {"ThumbnailsEnabled", "boolean", null}, {"TimeBeforeFirstCapture", "int", null}, {"TimeBetweenCaptures", "int", null}, {"TimeDate", "string", null}, {"TimeFill", "int", null}, {"TransferCount", "int", null}, {"TransferMech", "int", null}, {"UIControllable", "boolean", null}, {"UndefinedImageSize", "boolean", null}, {"Units", "int", "TWUN"}, {"XNativeResolution", "double", null}, {"XResolution", "double", null}, {"XScaling", "double", null}, {"YNativeResolution", "double", null}, {"YResolution", "double", null}, {"YScaling", "double", null}, {"ZoomFactor", "int", null}};
    static final Hashtable<String, Hashtable<String, String>> twainConstants = new Hashtable();
    static final Hashtable<String, Hashtable<String, String>> twainConstantsValues = new Hashtable();
    private TwainSource source;
    private TwainFrameCapability frameCapability;

    public TwainActivity(Component centerPanel, String sourceName) throws Exception {
        block19: {
            boolean previousUnsupportedCapabilityException;
            boolean previousBadValueExceptionMask;
            block18: {
                int i;
                block17: {
                    block16: {
                        Field[] constants = TwainConstants.class.getFields();
                        String s2 = null;
                        Hashtable<String, String> twainConstants2 = null;
                        Hashtable<String, String> twainConstantsValues2 = null;
                        for (i = 0; i < constants.length; ++i) {
                            String s = constants[i].getName();
                            s2 = null;
                            if (!s.startsWith("TW") || '_' != s.charAt(4)) continue;
                            String key = s.substring(0, 4);
                            if (!twainConstants.containsKey(key)) {
                                twainConstants2 = new Hashtable();
                                twainConstants.put(key, twainConstants2);
                                twainConstantsValues2 = new Hashtable();
                                twainConstantsValues.put(key, twainConstantsValues2);
                            } else {
                                twainConstants2 = twainConstants.get(key);
                                twainConstantsValues2 = twainConstantsValues.get(key);
                            }
                            s2 = s.substring(5, s.length());
                            try {
                                String value = String.valueOf(constants[i].get(null));
                                twainConstants2.put(s2, value);
                                twainConstantsValues2.put(value, s2);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                        this.centerPanel = centerPanel;
                        this.sourceName = sourceName;
                        this.openTwainSource(sourceName);
                        this.allCapabilities = new ArrayList();
                        this.properties = new Properties();
                        this.sourceValidFileName = "TWAIN_" + this.makeFileNameValid(this.source.toString()) + ".properties";
                        try {
                            this.properties.load(new FileInputStream(System.getProperty("user.home") + "/.morena/" + this.sourceValidFileName));
                        }
                        catch (Exception e) {
                            if (!Capabilities.debug) break block16;
                            System.out.println("TwainActivity.TwainActivity()" + e.getMessage() + " caused by " + e.getCause());
                        }
                    }
                    previousBadValueExceptionMask = true;
                    previousUnsupportedCapabilityException = true;
                    try {
                        previousBadValueExceptionMask = this.getSource().maskBadValueException(false);
                        previousUnsupportedCapabilityException = this.getSource().maskUnsupportedCapabilityException(false);
                    }
                    catch (TwainException e) {
                        if (!Capabilities.debug) break block17;
                        System.out.println("TwainActivity.TwainActivity()" + e.getMessage() + " caused by " + e.getCause());
                    }
                }
                for (i = 0; i < CAPABILITY_NAMES.length; ++i) {
                    String name = CAPABILITY_NAMES[i][0];
                    String textType = CAPABILITY_NAMES[i][1];
                    int type = textType.equals("int") ? 0 : (textType.equals("double") ? 1 : (textType.equals("boolean") ? 2 : 3));
                    String constantAbbreviation = CAPABILITY_NAMES[i][2];
                    this.allCapabilities.add(new TwainCapability(this, name, type, constantAbbreviation, this.properties));
                }
                this.frameCapability = new TwainFrameCapability(this);
                TwainFrameTL_XCapability tl_x = new TwainFrameTL_XCapability(this, this.properties, this.frameCapability);
                this.allCapabilities.add(tl_x);
                TwainFrameTL_YCapability tl_y = new TwainFrameTL_YCapability(this, this.properties, this.frameCapability);
                this.allCapabilities.add(tl_y);
                TwainFrameBR_XCapability br_x = new TwainFrameBR_XCapability(this, this.properties, this.frameCapability);
                this.allCapabilities.add(br_x);
                TwainFrameBR_YCapability br_y = new TwainFrameBR_YCapability(this, this.properties, this.frameCapability);
                this.allCapabilities.add(br_y);
                if (this.properties.containsKey("tl-x")) {
                    try {
                        this.frameCapability.setFrame((Double)tl_x.getValue(), (Double)tl_y.getValue(), (Double)br_x.getValue(), (Double)br_y.getValue());
                    }
                    catch (Exception e) {
                        if (!Capabilities.debug) break block18;
                        System.out.println("TwainActivity.TwainActivity()" + e.getMessage() + " caused by " + e.getCause());
                    }
                }
            }
            this.restartAfterPreview = Boolean.parseBoolean(this.properties.getProperty("restartAfterPreview", "true"));
            this.sleepTimeBeforeRestart = Integer.parseInt(this.properties.getProperty("sleepTimeBeforeRestart", "3000"));
            try {
                this.getSource().maskBadValueException(previousBadValueExceptionMask);
                this.getSource().maskUnsupportedCapabilityException(previousUnsupportedCapabilityException);
            }
            catch (TwainException e) {
                if (!Capabilities.debug) break block19;
                System.out.println("TwainActivity.TwainActivity()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
    }

    private void openTwainSource(String sourceName) throws Exception {
        if (sourceName.equals("")) {
            this.source = TwainManager.getDefaultSource();
        } else {
            TwainSource[] sources = TwainManager.listSources();
            if (null == sources) {
                throw new Exception("No TWAIN Data Source installed.");
            }
            for (int i = 0; i < sources.length; ++i) {
                if (!sources[i].toString().equals(sourceName)) continue;
                this.source = sources[i];
                break;
            }
        }
        this.source.setVisible(false);
    }

    public int showDialogWindow() {
        block5: {
            boolean previousUnsupportedCapabilityException;
            boolean previousBadValueExceptionMask;
            block4: {
                previousBadValueExceptionMask = true;
                previousUnsupportedCapabilityException = true;
                try {
                    previousBadValueExceptionMask = this.getSource().maskBadValueException(false);
                    previousUnsupportedCapabilityException = this.getSource().maskUnsupportedCapabilityException(false);
                }
                catch (TwainException e) {
                    if (!Capabilities.debug) break block4;
                    System.out.println("TwainActivity.showDialogWindow()" + e.getMessage() + " caused by " + e.getCause());
                }
            }
            this.frame = JOptionPane.getFrameForComponent(this.centerPanel);
            this.dialogWindow = new CapabilityDialog(this.frame, this);
            this.dialogWindow.setVisible(true);
            try {
                this.getSource().maskBadValueException(previousBadValueExceptionMask);
                this.getSource().maskUnsupportedCapabilityException(previousUnsupportedCapabilityException);
            }
            catch (TwainException e) {
                if (!Capabilities.debug) break block5;
                System.out.println("TwainActivity.showDialogWindow()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
        return this.dialogWindow.getReturnValue();
    }

    public MorenaImage getPreviewImage() throws Exception {
        MorenaImage morenaImage;
        String name;
        block30: {
            boolean setFrameSelected;
            String br_y;
            String br_x;
            String tl_y;
            String tl_x;
            block29: {
                String yResolution;
                String xResolution;
                block27: {
                    String maxHeight;
                    String maxWidth;
                    block26: {
                        xResolution = null;
                        yResolution = null;
                        tl_x = null;
                        tl_y = null;
                        br_x = null;
                        br_y = null;
                        maxWidth = null;
                        maxHeight = null;
                        this.properties.clear();
                        setFrameSelected = false;
                        for (Capability capability : this.getCapabilities()) {
                            name = capability.getName();
                            if (null == name) continue;
                            if (capability.isSelected()) {
                                Object[] supported;
                                this.properties.put(name, String.valueOf(capability.getValue()));
                                if (name.equals("tl-x")) {
                                    setFrameSelected = true;
                                    tl_x = String.valueOf(capability.getValue());
                                } else if (name.equals("tl-y")) {
                                    tl_y = String.valueOf(capability.getValue());
                                } else if (name.equals("br-x")) {
                                    br_x = String.valueOf(capability.getValue());
                                    supported = capability.getSupportedValues();
                                    maxWidth = (String)supported[supported.length - 1];
                                } else if (name.equals("br-y")) {
                                    br_y = String.valueOf(capability.getValue());
                                    supported = capability.getSupportedValues();
                                    maxHeight = (String)supported[supported.length - 1];
                                }
                            }
                            if (name.equals("XResolution")) {
                                xResolution = (String)capability.getValue();
                                continue;
                            }
                            if (!name.equals("YResolution")) continue;
                            yResolution = (String)capability.getValue();
                        }
                        this.source.setVisible(false);
                        try {
                            this.source.setXResolution(96.0);
                            this.source.setYResolution(96.0);
                        }
                        catch (TwainException e) {
                            if (!Capabilities.debug) break block26;
                            System.out.println("TwainActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
                        }
                    }
                    if (setFrameSelected) {
                        try {
                            this.source.setFrame(0.0, 0.0, Double.parseDouble(maxWidth), Double.parseDouble(maxHeight));
                        }
                        catch (TwainException e) {
                            if (!Capabilities.debug) break block27;
                            System.out.println("TwainActivity.getPreviewImage()" + e.getMessage());
                        }
                    }
                }
                morenaImage = new MorenaImage(this.source);
                if (this.restartAfterPreview) {
                    block28: {
                        this.close();
                        try {
                            Thread.sleep(this.sleepTimeBeforeRestart);
                        }
                        catch (InterruptedException e) {
                            if (!Capabilities.debug) break block28;
                            System.out.println("TwainActivity.getPreviewImage()" + e.getMessage());
                        }
                    }
                    this.openTwainSource(this.sourceName);
                }
                try {
                    this.source.setXResolution(Double.parseDouble(xResolution));
                    this.source.setYResolution(Double.parseDouble(yResolution));
                }
                catch (TwainException e1) {
                    if (!Capabilities.debug) break block29;
                    System.out.println("TwainActivity.getPreviewImage()" + e1.getMessage() + " caused by " + e1.getCause());
                }
            }
            if (setFrameSelected) {
                try {
                    this.source.setFrame(Double.parseDouble(tl_x), Double.parseDouble(tl_y), Double.parseDouble(br_x), Double.parseDouble(br_y));
                }
                catch (TwainException e1) {
                    if (!Capabilities.debug) break block30;
                    System.out.println("TwainActivity.getPreviewImage()" + e1.getMessage() + " caused by " + e1.getCause());
                }
            }
        }
        for (Capability capability : this.allCapabilities) {
            name = capability.getName();
            if (!capability.isSelected() || !capability.isSetMethodSupported()) continue;
            try {
                capability.setValue(this.properties.getProperty(name));
            }
            catch (Exception e) {
                if (!Capabilities.debug) continue;
                System.out.println("TwainActivity.getPreviewImage()" + e.getMessage() + " caused by " + e.getCause());
            }
        }
        return morenaImage;
    }

    public String getSourceName() {
        return this.source.toString();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("selectCapabilitiesButton")) {
            new TwainSelectCapabilitiesDialog(this.frame, this, this.dialogWindow);
        }
    }

    public TwainSource getSource() {
        return this.source;
    }

    public void close() {
        try {
            TwainManager.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

