/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.capabilities.twain;

import SK.gnome.capabilities.Capabilities;
import SK.gnome.capabilities.Capability;
import SK.gnome.capabilities.CapabilityDialog;
import SK.gnome.morena.MorenaConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class TwainSelectCapabilitiesDialog
extends JDialog
implements ActionListener,
MorenaConstants {
    private CapabilityDialog capabilityDialog;
    private JPanel checkBoxPanel;
    private Capabilities capabilities;
    private Frame frame;

    public TwainSelectCapabilitiesDialog(Frame frame, Capabilities capabilities, CapabilityDialog capabilityDialog) {
        super(frame, capabilities.getSourceName(), true);
        JCheckBox checkBox;
        this.frame = frame;
        this.capabilityDialog = capabilityDialog;
        this.capabilities = capabilities;
        Container contentPane = this.getContentPane();
        JPanel mainContainerPanel = new JPanel();
        mainContainerPanel.setLayout(new BoxLayout(mainContainerPanel, 1));
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Font font = this.getFont();
        Font newFont = new Font(font.getFontName(), 1, 16);
        mainContainerPanel.setBorder(BorderFactory.createTitledBorder(border, MORENA_MESSAGES.getString("SELECT_FROM_SUPPORTED_CAPABILITIES"), 2, 2, newFont));
        this.checkBoxPanel = new JPanel();
        this.checkBoxPanel.setAlignmentX(0.0f);
        GridLayout gridLayoutPane = new GridLayout(0, 6);
        this.checkBoxPanel.setLayout(gridLayoutPane);
        for (Capability capability : capabilities.getCapabilities()) {
            String name;
            if (!capability.isSupported() || (name = capability.getName()).equals("tl-x") || name.equals("tl-y") || name.equals("br-x") || name.equals("br-y")) continue;
            checkBox = new JCheckBox(name, capability.isSelected());
            this.checkBoxPanel.add(checkBox);
        }
        checkBox = new JCheckBox("SetFrame", capabilities.getCapability("tl-x").isSelected());
        this.checkBoxPanel.add(checkBox);
        mainContainerPanel.add(this.checkBoxPanel);
        mainContainerPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton button = new JButton(MORENA_MESSAGES.getString("PREFERENCES"));
        button.setAlignmentX(0.0f);
        button.setActionCommand("PreferencesButton");
        button.addActionListener(this);
        mainContainerPanel.add(button);
        mainContainerPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        button = new JButton("OK");
        button.setActionCommand("OKButton");
        button.setFont(new Font("Arial", 1, 18));
        button.addActionListener(this);
        JPanel panel2 = new JPanel();
        panel2.add(button);
        contentPane.add((Component)panel2, "Last");
        JScrollPane scrollPane = new JScrollPane(mainContainerPanel);
        contentPane.add(scrollPane);
        this.pack();
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OKButton")) {
            Component[] checkBoxArray = this.checkBoxPanel.getComponents();
            block0: for (int i = 0; i < checkBoxArray.length; ++i) {
                JCheckBox checkBox = (JCheckBox)checkBoxArray[i];
                String capabilityName = checkBox.getText();
                if (capabilityName.equals("SetFrame")) {
                    this.capabilities.getCapability("tl-x").setSelected(checkBox.isSelected());
                    this.capabilities.getCapability("tl-y").setSelected(checkBox.isSelected());
                    this.capabilities.getCapability("br-x").setSelected(checkBox.isSelected());
                    this.capabilities.getCapability("br-y").setSelected(checkBox.isSelected());
                    continue;
                }
                for (Capability capability : this.capabilities.getCapabilities()) {
                    if (!capability.getName().equals(capabilityName)) continue;
                    capability.setSelected(checkBox.isSelected());
                    continue block0;
                }
            }
            this.capabilityDialog.updateCapabilitiesTable();
            this.dispose();
        } else if (e.getActionCommand().equals("PreferencesButton")) {
            class PreferencesOptionPane
            extends JPanel {
                private JCheckBox restartAfterPreviewCheckBox;
                private JTextField sleepTimeBeforeRestartTextField;

                public PreferencesOptionPane(boolean restartAfterPreview, int sleepTimeBeforeRestart) {
                    this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this.setLayout(new BoxLayout(this, 1));
                    this.setAlignmentX(0.0f);
                    this.restartAfterPreviewCheckBox = new JCheckBox(MorenaConstants.MORENA_MESSAGES.getString("RESTART_AFTER_PREVIEW"));
                    this.restartAfterPreviewCheckBox.setSelected(TwainSelectCapabilitiesDialog.this.capabilities.isRestartAfterPreview());
                    this.add(this.restartAfterPreviewCheckBox);
                    JPanel restartPanel = new JPanel();
                    restartPanel.setLayout(new BoxLayout(restartPanel, 0));
                    restartPanel.setAlignmentX(0.0f);
                    JLabel label = new JLabel(MorenaConstants.MORENA_MESSAGES.getString("SLEEP_TIME_BEFORE_NEW_START") + ":  ");
                    label.setAlignmentX(0.0f);
                    restartPanel.add(label);
                    this.sleepTimeBeforeRestartTextField = new JTextField(String.valueOf(TwainSelectCapabilitiesDialog.this.capabilities.getSleepTimeBeforeRestart()), 6);
                    this.sleepTimeBeforeRestartTextField.setAlignmentX(0.0f);
                    restartPanel.add(this.sleepTimeBeforeRestartTextField);
                    this.add(restartPanel);
                }

                public boolean isRestartAfterPreview() {
                    return this.restartAfterPreviewCheckBox.isSelected();
                }

                public int getSleepTimeBeforeRestart() {
                    return Integer.parseInt(this.sleepTimeBeforeRestartTextField.getText());
                }
            }
            PreferencesOptionPane preferencesOptionPane = new PreferencesOptionPane(this.capabilities.isRestartAfterPreview(), this.capabilities.getSleepTimeBeforeRestart());
            JOptionPane.showMessageDialog(this.frame, preferencesOptionPane, MORENA_MESSAGES.getString("PREFERENCES"), 1);
            this.capabilities.setRestartAfterPreview(preferencesOptionPane.isRestartAfterPreview());
            this.capabilities.setSleepTimeBeforeRestart(preferencesOptionPane.getSleepTimeBeforeRestart());
        }
    }
}

