/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.morena;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class BASE64 {
    private static final char[] ALPHA;
    private static final int[] INDEX;

    public static String encode(byte[] b) {
        StringBuffer sb = new StringBuffer((b.length / 3 + 1) * 4);
        int n = b.length;
        for (int i = 0; i < n; ++i) {
            sb.append(ALPHA[(b[i] & 0xFF) >>> 2]);
            if (++i >= n) {
                sb.append(ALPHA[(b[i - 1] & 3) << 4]);
                sb.append("==");
                break;
            }
            sb.append(ALPHA[(b[i - 1] & 3) << 4 | (b[i] & 0xFF) >>> 4]);
            if (++i >= n) {
                sb.append(ALPHA[(b[i - 1] & 0xF) << 2]);
                sb.append('=');
                break;
            }
            sb.append(ALPHA[(b[i - 1] & 0xF) << 2 | (b[i] & 0xFF) >>> 6]);
            sb.append(ALPHA[b[i] & 0x3F]);
        }
        return sb.toString();
    }

    public static byte[] decode(String s) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length() / 4 * 3);
        int[] cb = new int[4];
        int i = 0;
        int n = s.length();
        while (i < n) {
            int j = 0;
            while (j < 4 && i < n) {
                int c;
                if ((c = INDEX[s.charAt(i++)]) == -1) continue;
                cb[j++] = c;
            }
            if (j < 4 && i < n) {
                throw new IOException("Character buffer underflow");
            }
            out.write(cb[0] << 2 | (cb[1] & 0x3F) >>> 4);
            if (j > 2) {
                out.write((cb[1] & 0xF) << 4 | cb[2] >>> 2);
            }
            if (j <= 3) continue;
            out.write((cb[2] & 3) << 6 | cb[3]);
        }
        return out.toByteArray();
    }

    static {
        int i;
        ALPHA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        INDEX = new int[256];
        for (i = 0; i < 256; ++i) {
            BASE64.INDEX[i] = -1;
        }
        for (i = 0; i < ALPHA.length; ++i) {
            BASE64.INDEX[BASE64.ALPHA[i]] = i;
        }
    }
}

