/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.sane;

import SK.gnome.morena.MorenaOptionsDescriptor;
import SK.gnome.sane.NetBase;
import SK.gnome.sane.SaneConnection;
import SK.gnome.sane.SaneConstants;
import SK.gnome.sane.SaneException;
import SK.gnome.sane.SaneOptionDescriptor;
import SK.gnome.sane.SaneSource;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

class RemoteSaneSource
extends NetBase
implements SaneSource,
SaneConstants {
    private String name;
    private String vendor;
    private String model;
    private String type;
    private int optionsCount;
    private int handle = -1;
    private Vector consumers;
    private boolean uiVisible;
    private SaneOptionDescriptor[] optionDescriptors;
    private boolean maskUnsupportedCapabilityException = true;
    private boolean maskBadValueException = true;
    private SaneConnection saneConnection;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    RemoteSaneSource(SaneConnection saneConnection) throws IOException {
        try {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.RemoteSaneSource(...)");
            }
            this.in = saneConnection.in;
            this.out = saneConnection.out;
            this.socket = saneConnection.socket;
            this.saneConnection = saneConnection;
            this.name = this.readString();
            this.vendor = this.readString();
            this.model = this.readString();
            this.type = this.readString();
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   name=\"" + this.name + "\", vendor=\"" + this.vendor + "\", model=\"" + this.model + "\", type=\"" + this.type + "\"");
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
            }
        }
        catch (IOException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
    }

    void open() throws SaneException, IOException {
        try {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.open()");
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_OPEN(\"" + this.name + "\")");
            }
            this.writeWord(2);
            this.writeString(this.name);
            this.saneConnection.setResultCode(this.readWord());
            this.handle = this.readWord();
            String resource = this.readString();
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", handle=" + this.handle + ", resource=\"" + resource + "\"");
            }
            if (this.saneConnection.getResultCode() != 0) {
                throw new SaneException(this.saneConnection.getResultCode());
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_GET_OPTION_DESCRIPTORS(" + this.handle + ")");
            }
            this.writeWord(4);
            this.writeWord(this.handle);
            this.optionsCount = this.readWord();
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", count=" + this.optionsCount);
            }
            this.optionDescriptors = new SaneOptionDescriptor[this.optionsCount];
            for (int i = 0; i < this.optionsCount; ++i) {
                int type;
                this.readWord();
                SaneOptionDescriptor od = new SaneOptionDescriptor();
                od.name = this.readString();
                od.title = this.readString();
                od.description = this.readString();
                od.type = type = this.readWord();
                od.unit = this.readWord();
                od.size = this.readWord();
                od.cap = this.readWord();
                int constraintType = this.readWord();
                switch (constraintType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.readWord();
                        if (type == 2) {
                            od.constraint = new MorenaOptionsDescriptor.DoubleRange(this.readWord() / 65536, this.readWord() / 65536, this.readWord() / 65536);
                            break;
                        }
                        od.constraint = new MorenaOptionsDescriptor.IntRange(this.readWord(), this.readWord(), this.readWord());
                        break;
                    }
                    case 2: {
                        int j;
                        this.readWord();
                        int length = this.readWord();
                        Object[] list = new int[length];
                        for (j = 0; j < length; ++j) {
                            list[j] = (String)this.readWord();
                        }
                        od.constraint = list;
                        break;
                    }
                    case 3: {
                        int j;
                        int length = this.readWord();
                        Object[] list = new String[length];
                        for (j = 0; j < length; ++j) {
                            list[j] = this.readString();
                        }
                        od.constraint = list;
                        break;
                    }
                }
                this.optionDescriptors[i] = od;
                if (!debug) continue;
                System.err.println("                     ".substring(0, traceIndentLevel) + "      " + od);
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
            }
        }
        catch (IOException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
        catch (SaneException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
    }

    void close() throws IOException {
        try {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.close()");
            }
            if (this.handle != -1) {
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_CLOSE(" + this.handle + ")");
                }
                this.writeWord(8);
                this.writeWord(this.handle);
                this.readWord();
                this.writeWord(3);
                this.writeWord(this.handle);
                this.readWord();
                this.handle = -1;
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
            }
        }
        catch (IOException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
    }

    public String toString() {
        return this.model + " [" + this.name + "]";
    }

    public boolean maskUnsupportedCapabilityException(boolean mask) {
        boolean previousValue = this.maskUnsupportedCapabilityException;
        this.maskUnsupportedCapabilityException = mask;
        return previousValue;
    }

    public boolean maskBadValueException(boolean mask) {
        boolean previousValue = this.maskBadValueException;
        this.maskBadValueException = mask;
        return previousValue;
    }

    public void setVisible(boolean uiVisible) {
        this.uiVisible = uiVisible;
    }

    public String getModel() throws IOException, SaneException {
        return this.model;
    }

    public String getName() throws IOException, SaneException {
        return this.name;
    }

    public String getType() throws IOException, SaneException {
        return this.type;
    }

    public String getVendor() throws IOException, SaneException {
        return this.vendor;
    }

    public SaneOptionDescriptor[] getOptionDescriptors() throws IOException, SaneException {
        if (this.handle == -1) {
            this.open();
        }
        return this.optionDescriptors;
    }

    public int getOptionsCount() throws IOException, SaneException {
        if (this.handle == -1) {
            this.open();
        }
        return this.optionsCount;
    }

    public int getOptionIndex(String name) throws IOException, SaneException {
        if (this.handle == -1) {
            this.open();
        }
        for (int i = 0; i < this.optionDescriptors.length; ++i) {
            if (!name.equals(this.optionDescriptors[i].name)) continue;
            return i;
        }
        return -1;
    }

    public Object getOption(int index) throws IOException, SaneException {
        try {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.getOption(" + index + ")");
            }
            if (this.handle == -1) {
                this.open();
            }
            if (0 <= index && index < this.optionDescriptors.length) {
                Object value;
                int i;
                int type;
                SaneOptionDescriptor od = this.optionDescriptors[index];
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "   " + od);
                }
                if ((type = od.type) == 5 || type == 4) {
                    if (debug) {
                        System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <- null");
                    }
                    return null;
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_CONTROL_OPTION(" + this.handle + ", " + index + ", SANE_ACTION_GET_VALUE, " + type + ", ...)");
                }
                this.writeWord(5);
                this.writeWord(this.handle);
                this.writeWord(index);
                this.writeWord(0);
                this.writeWord(type);
                this.writeWord(od.size);
                if (type == 3) {
                    this.writeWord(od.size);
                    for (i = 0; i < od.size; ++i) {
                        this.writeByte(0);
                    }
                } else {
                    this.writeWord(1);
                    for (i = 0; i < od.size; ++i) {
                        this.writeByte(0);
                    }
                }
                this.saneConnection.setResultCode(this.readWord());
                int info = this.readWord();
                int valueType = this.readWord();
                int valueSize = this.readWord();
                switch (valueType) {
                    case 0: {
                        this.readWord();
                        value = new Boolean(this.readWord() != 0);
                        break;
                    }
                    case 1: {
                        int i2;
                        this.readWord();
                        if (valueSize == 4) {
                            value = new Integer(this.readWord());
                            break;
                        }
                        value = new int[valueSize /= 4];
                        for (i2 = 0; i2 < valueSize; ++i2) {
                            ((int[])value)[i2] = this.readWord();
                        }
                        break;
                    }
                    case 2: {
                        int i2;
                        this.readWord();
                        if (valueSize == 4) {
                            value = new Double((double)this.readWord() / 65536.0);
                            break;
                        }
                        value = new double[valueSize /= 4];
                        for (i2 = 0; i2 < valueSize; ++i2) {
                            ((double[])value)[i2] = (double)this.readWord() / 65536.0;
                        }
                        break;
                    }
                    case 3: {
                        value = this.readString();
                        break;
                    }
                    default: {
                        this.readWord();
                        this.readWord();
                        value = null;
                    }
                }
                String resource = this.readString();
                if (this.saneConnection.getResultCode() != 0) {
                    if (this.saneConnection.getResultCode() == 1 && this.maskUnsupportedCapabilityException) {
                        return null;
                    }
                    throw new SaneException(this.saneConnection.getResultCode());
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", info=" + info + ", valueType=" + valueType + ", valueSize=" + valueSize + ", value=\"" + value + "\", resource=\"" + resource + "\"");
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <- " + value);
                }
                return value;
            }
            if (!this.maskUnsupportedCapabilityException) {
                throw new SaneException("Option index out of range 0.." + this.optionDescriptors.length);
            }
            return null;
        }
        catch (IOException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
        catch (SaneException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
    }

    public Object getOption(String name) throws IOException, SaneException {
        return this.getOption(this.getOptionIndex(name));
    }

    public Object setOption(int index, Object value) throws IOException, SaneException {
        try {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.setOption(" + index + ", " + value + ")");
            }
            if (this.handle == -1) {
                this.open();
            }
            if (0 <= index && index < this.optionDescriptors.length) {
                SaneOptionDescriptor od = this.optionDescriptors[index];
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "   " + od);
                }
                int cap = od.cap;
                int type = od.type;
                if ((cap & 1) == 0) {
                    if (this.maskBadValueException) {
                        if (debug) {
                            System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <- null");
                        }
                        return null;
                    }
                    throw new SaneException("Option '" + od.name + "' can't be set");
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_CONTROL_OPTION(" + this.handle + ", " + index + ", SANE_ACTION_SET_VALUE, " + type + ", ...)");
                }
                this.writeWord(5);
                this.writeWord(this.handle);
                this.writeWord(index);
                this.writeWord(1);
                this.writeWord(type);
                switch (type) {
                    case 0: {
                        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = RemoteSaneSource.class$("java.lang.Boolean")) : class$java$lang$Boolean).isInstance(value)) {
                            this.writeWord(4);
                            this.writeWord(1);
                            this.writeWord((Boolean)value != false ? 1 : 0);
                            break;
                        }
                        this.writeWord(4);
                        this.writeWord(1);
                        this.writeWord(0);
                        break;
                    }
                    case 1: {
                        int i;
                        Object[] v;
                        if ((array$I == null ? (array$I = RemoteSaneSource.class$("[I")) : array$I).isInstance(value)) {
                            v = (int[])value;
                            this.writeWord(v.length * 4);
                            this.writeWord(1);
                            for (i = 0; i < v.length; ++i) {
                                this.writeWord(v[i]);
                            }
                            break;
                        }
                        if ((array$D == null ? (array$D = RemoteSaneSource.class$("[D")) : array$D).isInstance(value)) {
                            v = (double[])value;
                            this.writeWord(v.length * 4);
                            this.writeWord(1);
                            for (i = 0; i < v.length; ++i) {
                                this.writeWord(v[i]);
                            }
                            break;
                        }
                        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteSaneSource.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(value)) {
                            this.writeWord(4);
                            this.writeWord(1);
                            this.writeWord((Integer)value);
                            break;
                        }
                        if ((class$java$lang$Double == null ? (class$java$lang$Double = RemoteSaneSource.class$("java.lang.Double")) : class$java$lang$Double).isInstance(value)) {
                            this.writeWord(4);
                            this.writeWord(1);
                            this.writeWord(((Double)value).intValue());
                            break;
                        }
                        this.writeWord(4);
                        this.writeWord(1);
                        this.writeWord(0);
                        break;
                    }
                    case 2: {
                        int i;
                        Object[] v;
                        if ((array$D == null ? (array$D = RemoteSaneSource.class$("[D")) : array$D).isInstance(value)) {
                            v = (double[])value;
                            this.writeWord(v.length * 4);
                            this.writeWord(1);
                            for (i = 0; i < v.length; ++i) {
                                this.writeWord(v[i] * 65536.0);
                            }
                            break;
                        }
                        if ((array$I == null ? (array$I = RemoteSaneSource.class$("[I")) : array$I).isInstance(value)) {
                            v = (int[])value;
                            this.writeWord(v.length * 4);
                            this.writeWord(1);
                            for (i = 0; i < v.length; ++i) {
                                this.writeWord((int)((double)v[i] * 65536.0));
                            }
                            break;
                        }
                        if ((class$java$lang$Double == null ? (class$java$lang$Double = RemoteSaneSource.class$("java.lang.Double")) : class$java$lang$Double).isInstance(value)) {
                            this.writeWord(4);
                            this.writeWord(1);
                            this.writeWord((int)((Double)value * 65536.0));
                            break;
                        }
                        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteSaneSource.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(value)) {
                            this.writeWord(4);
                            this.writeWord(1);
                            this.writeWord((int)(((Integer)value).doubleValue() * 65536.0));
                            break;
                        }
                        this.writeWord(4);
                        this.writeWord(1);
                        this.writeWord(0);
                        break;
                    }
                    case 3: {
                        if ((class$java$lang$String == null ? (class$java$lang$String = RemoteSaneSource.class$("java.lang.String")) : class$java$lang$String).isInstance(value)) {
                            this.writeWord(((String)value).length() + 1);
                            this.writeString((String)value);
                            break;
                        }
                        this.writeWord(4);
                        this.writeWord(1);
                        this.writeWord(0);
                    }
                }
                this.saneConnection.setResultCode(this.readWord());
                int info = this.readWord();
                int valueType = this.readWord();
                int valueSize = this.readWord();
                switch (type) {
                    case 0: {
                        this.readWord();
                        value = new Boolean(this.readWord() != 0);
                        break;
                    }
                    case 1: {
                        int i;
                        this.readWord();
                        if (valueSize == 4) {
                            value = new Integer(this.readWord());
                            break;
                        }
                        value = new int[valueSize /= 4];
                        for (i = 0; i < valueSize; ++i) {
                            ((int[])value)[i] = this.readWord();
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        this.readWord();
                        if (valueSize == 4) {
                            value = new Double((double)this.readWord() / 65536.0);
                            break;
                        }
                        value = new double[valueSize /= 4];
                        for (i = 0; i < valueSize; ++i) {
                            ((double[])value)[i] = (double)this.readWord() / 65536.0;
                        }
                        break;
                    }
                    case 3: {
                        value = this.readString();
                        break;
                    }
                    default: {
                        this.readWord();
                        this.readWord();
                        value = null;
                    }
                }
                String resource = this.readString();
                if (this.saneConnection.getResultCode() != 0) {
                    if (this.saneConnection.getResultCode() == 1 && this.maskUnsupportedCapabilityException) {
                        return null;
                    }
                    if (this.saneConnection.getResultCode() == 4 && this.maskBadValueException) {
                        return null;
                    }
                    throw new SaneException(this.saneConnection.getResultCode());
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", info=" + info + ", valueType=" + valueType + ", valueSize=" + valueSize + ", value=\"" + value + "\", resource=\"" + resource + "\"");
                }
                if (debug) {
                    System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <- " + value);
                }
                return value;
            }
            if (!this.maskUnsupportedCapabilityException) {
                throw new SaneException("Option index out of range 0.." + this.optionDescriptors.length);
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <- null");
            }
            return null;
        }
        catch (IOException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
        catch (SaneException exception) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-" + exception);
            }
            throw exception;
        }
    }

    public Object setOption(String name, Object value) throws IOException, SaneException {
        return this.setOption(this.getOptionIndex(name), value);
    }

    public void setResolution(double value) throws SaneException {
        try {
            this.setOption("resolution", (Object)new Double(value));
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public double getResolution() throws SaneException {
        try {
            Object resolution = this.getOption("resolution");
            if ((class$java$lang$Double == null ? (class$java$lang$Double = RemoteSaneSource.class$("java.lang.Double")) : class$java$lang$Double).isInstance(resolution)) {
                return (Double)resolution;
            }
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteSaneSource.class$("java.lang.Integer")) : class$java$lang$Integer).isInstance(resolution)) {
                return ((Integer)resolution).intValue();
            }
            return 0.0;
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setBitDepth(int value) throws SaneException {
        try {
            this.setOption("depth", (Object)new Integer(value));
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public int getBitDepth() throws SaneException {
        try {
            return (Integer)this.getOption("depth");
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setColorMode() throws SaneException {
        try {
            this.setOption("mode", (Object)"Color");
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setGrayScaleMode() throws SaneException {
        try {
            this.setOption("mode", (Object)"Gray");
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setContrast(double value) throws SaneException {
        try {
            this.setOption("contrast", (Object)new Double(value));
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public double getContrast() throws SaneException {
        try {
            return (Double)this.getOption("contrast");
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setBrightness(double value) throws SaneException {
        try {
            this.setOption("brightness", (Object)new Double(value));
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public double getBrightness() throws SaneException {
        try {
            return (Double)this.getOption("brightness");
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    public void setFrame(double left, double top, double right, double bottom) throws SaneException {
        try {
            this.setOption("tl-x", (Object)new Double(left));
            this.setOption("tl-y", (Object)new Double(top));
            this.setOption("br-x", (Object)new Double(right));
            this.setOption("br-y", (Object)new Double(bottom));
        }
        catch (IOException exception) {
            throw new SaneException(exception.toString());
        }
    }

    private void initialize(int pixelsPerLine, int lines, ColorModel model) {
        Enumeration en = this.consumers.elements();
        while (en.hasMoreElements()) {
            ImageConsumer consumer = (ImageConsumer)en.nextElement();
            consumer.setHints(2);
            consumer.setDimensions(pixelsPerLine, lines);
            consumer.setColorModel(model);
        }
    }

    private void setPixels(int y, int pixelsPerLine, ColorModel model, byte[] buffer) {
        Enumeration en = this.consumers.elements();
        while (en.hasMoreElements()) {
            ((ImageConsumer)en.nextElement()).setPixels(0, y, pixelsPerLine, 1, model, buffer, 0, pixelsPerLine);
        }
    }

    private void setPixels(int y, int pixelsPerLine, ColorModel model, int[] buffer) {
        Enumeration en = this.consumers.elements();
        while (en.hasMoreElements()) {
            ((ImageConsumer)en.nextElement()).setPixels(0, y, pixelsPerLine, 1, model, buffer, 0, pixelsPerLine);
        }
    }

    private void finish(int code) {
        Enumeration en = this.consumers.elements();
        while (en.hasMoreElements()) {
            ((ImageConsumer)en.nextElement()).imageComplete(code);
        }
    }

    public void addConsumer(ImageConsumer consumer) {
        if (this.consumers == null) {
            this.consumers = new Vector();
        }
        if (!this.consumers.contains(consumer)) {
            this.consumers.addElement(consumer);
        }
    }

    public boolean isConsumer(ImageConsumer consumer) {
        if (this.consumers == null) {
            return false;
        }
        return this.consumers.contains(consumer);
    }

    public void removeConsumer(ImageConsumer consumer) {
        if (this.consumers != null) {
            this.consumers.removeElement(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProduction(ImageConsumer consumer) {
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> RemoteSaneSource.startProduction(...)");
        }
        this.addConsumer(consumer);
        try {
            ColorModel model;
            if (this.handle == -1) {
                this.open();
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_START(" + this.handle + ")");
            }
            this.writeWord(7);
            this.writeWord(this.handle);
            this.saneConnection.setResultCode(this.readWord());
            int port = this.readWord();
            int byteOrder = this.readWord();
            String resource = this.readString();
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", port=" + port + ", byteOrder=" + Integer.toHexString(byteOrder) + ", resource=\"" + resource + "\"");
            }
            if (this.saneConnection.getResultCode() != 0) {
                throw new SaneException(this.saneConnection.getResultCode());
            }
            Socket dataSocket = new Socket(this.socket.getInetAddress().getHostName(), port);
            DataInputStream dataStream = new DataInputStream(dataSocket.getInputStream());
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      connection opened");
            }
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_GET_PARAMETERS(" + this.handle + ")");
            }
            this.writeWord(6);
            this.writeWord(this.handle);
            this.saneConnection.setResultCode(this.readWord());
            if (this.saneConnection.getResultCode() != 0) {
                throw new SaneException(this.saneConnection.getResultCode());
            }
            int format = this.readWord();
            int lastFrame = this.readWord();
            int bytesPerLine = this.readWord();
            int pixelsPerLine = this.readWord();
            int lines = this.readWord();
            int depth = this.readWord();
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.saneConnection.getResultCode() + ", format=" + format + ", lastFrame=" + (lastFrame != 0 ? "true" : "false") + ", lines=" + lines + ", depth=" + depth + ", pixelsPerLine=" + pixelsPerLine + ", bytesPerLine=" + bytesPerLine);
            }
            switch (format) {
                case 0: {
                    if (depth == 1) {
                        byte[] reds = new byte[]{-1, 0};
                        byte[] greens = new byte[]{-1, 0};
                        byte[] blues = new byte[]{-1, 0};
                        model = new IndexColorModel(1, 2, reds, greens, blues);
                        break;
                    }
                    model = new DirectColorModel(8, 255, 255, 255);
                    break;
                }
                case 1: {
                    if (byteOrder == 4660) {
                        model = new DirectColorModel(24, 255, 65280, 0xFF0000);
                        break;
                    }
                    model = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    break;
                }
                default: {
                    throw new SaneException("Frame format " + format + " is not supported!");
                }
            }
            this.initialize(pixelsPerLine, lines, model);
            byte[] input = new byte[bytesPerLine];
            int[] output = new int[pixelsPerLine];
            int padSize = pixelsPerLine % 8 == 0 ? pixelsPerLine : pixelsPerLine / 8 * 8 + 8;
            byte[] byteOutput = new byte[padSize];
            int x = 0;
            int y = 0;
            int length = dataStream.readInt();
            while (length != -1 && y < lines && length >= 0) {
                int r;
                if (length == 0) {
                    length = dataStream.readInt();
                }
                if (length <= 0) continue;
                int remains = bytesPerLine - x;
                if (remains <= length) {
                    int i;
                    int j;
                    while (remains > 0) {
                        r = dataStream.read(input, x, remains);
                        remains -= r;
                        length -= r;
                        x += r;
                    }
                    if (format == 0) {
                        if (depth == 1) {
                            j = 0;
                            for (i = 0; i < bytesPerLine; ++i) {
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 0x80) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 0x40) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 0x20) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 0x10) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 8) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 4) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 2) != 0 ? 1 : 0);
                                byteOutput[j++] = (byte)((byte)(0xFF & input[i] & 1) != 0 ? 1 : 0);
                            }
                            this.setPixels(y++, pixelsPerLine, model, byteOutput);
                        } else {
                            this.setPixels(y++, pixelsPerLine, model, input);
                        }
                    } else {
                        j = 0;
                        for (i = 0; i < pixelsPerLine; ++i) {
                            output[i] = 0xFF & input[j++] | (0xFF & input[j++]) << 8 | (0xFF & input[j++]) << 16;
                        }
                        this.setPixels(y++, pixelsPerLine, model, output);
                    }
                    x = 0;
                    continue;
                }
                while (length > 0) {
                    r = dataStream.read(input, x, length);
                    x += r;
                    length -= r;
                }
            }
            dataSocket.close();
            this.finish(3);
        }
        catch (Exception exception) {
            this.finish(1);
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "      exception=" + exception);
            }
        }
        finally {
            this.removeConsumer(consumer);
        }
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

