/*
 * Decompiled with CFR 0.152.
 */
package SK.gnome.sane;

import SK.gnome.sane.NetBase;
import SK.gnome.sane.RemoteSaneSource;
import SK.gnome.sane.SaneConstants;
import SK.gnome.sane.SaneException;
import SK.gnome.sane.SaneSource;
import java.awt.Component;
import java.awt.Cursor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.swing.JOptionPane;

public class SaneConnection
extends NetBase
implements SaneConstants {
    private static String hostName = "localhost";
    private int remoteVersion = 0;
    private SaneSource[] sources = null;
    protected int lastStatus = 0;

    private SaneConnection(String host, int port, String userName) throws SaneException, IOException {
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> SaneConnection.SaneConnection(\"" + host + "\", " + port + ", \"" + userName + "\")");
        }
        connections.addElement(this);
        this.socket = new Socket(host, port);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(this.socket.getOutputStream());
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_INIT(0x" + Integer.toHexString(0x1000003) + ", \"" + userName + "\")");
        }
        this.writeWord(0);
        this.writeWord(0x1000003);
        this.writeString(userName);
        this.lastStatus = this.readWord();
        this.remoteVersion = this.readWord();
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.lastStatus + ", version=0x" + Integer.toHexString(this.remoteVersion));
        }
        if (this.lastStatus != 0) {
            throw new SaneException(this.lastStatus);
        }
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_GET_DEVICES()");
        }
        this.writeWord(1);
        this.lastStatus = this.readWord();
        int count = this.readWord() - 1;
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel) + "      status=" + this.lastStatus + ", count=" + count);
        }
        this.sources = new SaneSource[count];
        for (int i = 0; i < count; ++i) {
            this.sources[i] = this.readWord() != 0 ? null : new RemoteSaneSource(this);
        }
        this.readWord();
        if (this.lastStatus != 0) {
            throw new SaneException(this.lastStatus);
        }
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
        }
    }

    public void close() throws Exception {
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel += 3) + "-> SaneConnection.close()");
        }
        if (this.sources != null) {
            for (int i = 0; i < this.sources.length; ++i) {
                ((RemoteSaneSource)this.sources[i]).close();
            }
        }
        if (this.socket != null) {
            if (debug) {
                System.err.println("                     ".substring(0, traceIndentLevel) + "   >> SANE_NET_EXIT()");
            }
            this.writeWord(10);
            this.socket.close();
            this.socket = null;
        }
        connections.remove(this);
        if (debug) {
            System.err.println("                     ".substring(0, traceIndentLevel -= 3) + "   <-");
        }
    }

    public SaneSource[] listSources() {
        return this.sources;
    }

    public SaneSource getDefaultSource() {
        if (this.sources != null) {
            return this.sources[0];
        }
        return null;
    }

    public SaneSource selectSource(Component parent, SaneSource defaultSource) {
        Object[] list = null;
        try {
            list = this.listSources();
            if (list != null && list.length > 0) {
                return (SaneSource)JOptionPane.showInputDialog(parent, MORENA_MESSAGES.getString("SELECT_SANE_SOURCE"), MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), -1, null, list, defaultSource);
            }
            JOptionPane.showMessageDialog(parent, MORENA_MESSAGES.getString("NO_SUCH_SANE_SOURCE"), MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), 0);
        }
        catch (Exception exception) {
            list = null;
            JOptionPane.showMessageDialog(parent, MORENA_MESSAGES.getString("FAILED_TO_GET_LIST_OF_SANE_SOURCES") + exception, MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), 0);
        }
        return null;
    }

    public static SaneSource selectSource(Component parent) {
        Cursor previousCursor = null;
        if (null != parent) {
            previousCursor = parent.getCursor();
        }
        try {
            hostName = (String)JOptionPane.showInputDialog(parent, MORENA_MESSAGES.getString("ENTER_SANE_HOST"), MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), -1, null, null, hostName);
            if (hostName == null) {
                return null;
            }
            if (null != parent) {
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
            SaneConnection connection = SaneConnection.connect(hostName);
            if (null != parent) {
                parent.setCursor(previousCursor);
            }
            return connection.selectSource(parent, null);
        }
        catch (Exception exception) {
            if (null != parent) {
                parent.setCursor(previousCursor);
            }
            JOptionPane.showMessageDialog(parent, MORENA_MESSAGES.getString("FAILED_TO_CONNECT") + hostName + "\n" + exception, MORENA_MESSAGES.getString("SOURCE_SELECTOR_TITLE"), 0);
            return null;
        }
    }

    public static SaneConnection connect(String host, int port, String userName) throws SaneException, IOException {
        return new SaneConnection(host, port, userName);
    }

    public static SaneConnection connect(String host, String userName) throws SaneException, IOException {
        return SaneConnection.connect(host, 6566, userName);
    }

    public static SaneConnection connect(String host) throws SaneException, IOException {
        return SaneConnection.connect(host, 6566, null);
    }

    public String toString() {
        return "SaneConnection[socket=" + this.socket + ", version=0x" + Integer.toHexString(this.remoteVersion) + "]";
    }

    public int getResultCode() {
        return this.lastStatus;
    }

    public void setResultCode(int lastStatus) {
        this.lastStatus = lastStatus;
    }
}

