/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.dbm.impl;

import in.gov.uidai.eca.dbm.IRuntimeDBManager;
import in.gov.uidai.eca.dbm.impl.SchemaExecutor;
import in.gov.uidai.eca.dbm.impl.ZipUtils;
import java.io.File;
import java.net.URL;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeDBManager
implements IRuntimeDBManager {
    private static final String DDL_PATH = "res/eca/runtime-ddl.sql";
    private static final String DB_TMP_PATH = "./temp/dbm";
    private static final String IMPORT_PATH = "./data/import";
    private String encryptPass;
    private String userName;
    private String password;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDBManager.class);

    public void setEncryptPassword(String pass) {
        this.encryptPass = pass;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    @Override
    public void createAndDeploy() throws Exception {
        File dbRoot = new File(DB_TMP_PATH, Long.toString(System.currentTimeMillis(), 36));
        dbRoot = new File(dbRoot, "runtime");
        BasicDataSource bds = new BasicDataSource();
        bds.setUrl("jdbc:derby:" + dbRoot.getAbsolutePath());
        bds.addConnectionProperty("create", "true");
        if (StringUtils.isNotBlank((String)this.encryptPass)) {
            bds.addConnectionProperty("dataEncryption", "true");
            bds.addConnectionProperty("encryptionAlgorithm", "AES/CBC/NoPadding");
            bds.addConnectionProperty("bootPassword", this.encryptPass);
        }
        if (StringUtils.isNotBlank((String)this.userName)) {
            bds.setUsername(this.userName);
        }
        if (StringUtils.isNotBlank((String)this.password)) {
            bds.setPassword(this.password);
        }
        bds.setMaxActive(1);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        URL ddlUrl = cl.getResource(DDL_PATH);
        SchemaExecutor se = new SchemaExecutor((DataSource)bds, ddlUrl);
        se.execute();
        File targetZip = new File(IMPORT_PATH, "runtime.zip");
        if (targetZip.exists()) {
            if (targetZip.delete()) {
                LOGGER.info("File deleted");
            } else {
                LOGGER.info("File not deleted");
            }
        }
        ZipUtils.zipFolder("runtime", dbRoot, targetZip);
        File trigger = new File(IMPORT_PATH, "__deploy_runtime");
        trigger.createNewFile();
        try {
            FileUtils.deleteDirectory((File)dbRoot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

