/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.dbm.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaExecutor.class);
    private DataSource dataSource;
    private URL ddlUrl;

    public SchemaExecutor(DataSource ds, URL ddl) {
        this.dataSource = ds;
        this.ddlUrl = ddl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        InputStream input = null;
        BufferedReader reader = null;
        try {
            String[] statements;
            String oneLine;
            input = this.ddlUrl.openStream();
            reader = new BufferedReader(new InputStreamReader(input));
            StringBuffer ddlContent = new StringBuffer();
            while ((oneLine = reader.readLine()) != null) {
                if ((oneLine = oneLine.trim()).length() == 0 || oneLine.startsWith("--")) continue;
                ddlContent.append(oneLine);
                ddlContent.append(' ');
            }
            for (String stmt : statements = ddlContent.toString().split(";")) {
                this.executeQuery(stmt);
            }
        }
        catch (Exception exep) {
            LOGGER.error("Exception ", (Throwable)exep);
        }
        finally {
            if (input != null) {
                reader.close();
                input.close();
            }
        }
    }

    private void executeQuery(String query) {
        if (StringUtils.isBlank((String)query)) {
            return;
        }
        LOGGER.debug("executing -> " + query);
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement ps = conn.prepareStatement(query);
            ps.execute();
            ps.close();
        }
        catch (SQLException exep) {
            LOGGER.warn(exep.getMessage());
        }
    }
}

