/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.dbm.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static final void zipFolder(String zipSubFolder, File directory, File zip) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        ZipUtils.zipImpl(zipSubFolder, directory, directory, zos);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipImpl(String zipSubFolder, File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        try (FileInputStream in = null;){
            for (File f : files) {
                if (f.isDirectory()) {
                    ZipUtils.zipImpl(zipSubFolder, f, base, zos);
                    continue;
                }
                if (f.getName().contains(".log")) continue;
                in = new FileInputStream(f);
                long pending = f.length();
                String entryName = f.getPath().substring(base.getPath().length() + 1);
                if (StringUtils.isNotBlank((String)zipSubFolder)) {
                    entryName = new File(zipSubFolder, entryName).getPath();
                }
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                byte[] buffer = new byte[10240];
                while (pending > 0L) {
                    int amount = in.read(buffer);
                    zos.write(buffer, 0, amount);
                    pending -= (long)amount;
                }
            }
        }
    }
}

