/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.namedic.impl;

import in.gov.uidai.eca.namedic.INameDictionaryManager;
import in.gov.uidai.eca.ui.prefedit.IClientUIPreference;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameDictionaryManager
implements INameDictionaryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NameDictionaryManager.class);
    private IClientUIPreference cuiPref;

    public final void setCuiPref(IClientUIPreference cuiPref) {
        this.cuiPref = cuiPref;
    }

    @Override
    public void updateNameDictionaries(String dictionaryFile) throws Exception {
        File f = new File(dictionaryFile);
        ZipFile zipArch = new ZipFile(f);
        Enumeration<? extends ZipEntry> contents = zipArch.entries();
        byte[] dic = null;
        String curLocale = this.cuiPref.getTransliterationLocale("xxx");
        ITransliterationProvider provider = TransliterationManager.getInst().getTransliterationProvider(curLocale);
        String tlitClass = provider.getClass().getName();
        while (contents.hasMoreElements()) {
            ZipEntry entry = contents.nextElement();
            dic = this.readZip(zipArch, entry, curLocale, tlitClass);
            if (dic == null) continue;
            TransliterationManager.getInst().getTransliterationProvider(curLocale).importDB(dic, true, new TransliterationHints[]{TransliterationHints.PERSIST});
            LOGGER.info("Successfully imported name dictionary for " + curLocale + ", provider " + provider.getName());
            break;
        }
        if (dic == null) {
            throw new UnsupportedOperationException("Name dictionary file may be corrupted or not in the proper format.");
        }
    }

    private byte[] readZip(ZipFile zipFile, ZipEntry entry, String locale, String tlitClass) throws IOException {
        if (entry.getName().startsWith(tlitClass) && entry.getName().indexOf(locale) > -1) {
            LOGGER.debug("Found dictionary:" + entry.getName());
            InputStream is = zipFile.getInputStream(entry);
            byte[] buf = new byte[is.available()];
            while (is.available() > 0) {
                int res = is.read(buf);
                if (res > 0) {
                    LOGGER.info("Read completed");
                    continue;
                }
                LOGGER.info("No more data present");
            }
            return buf;
        }
        return null;
    }
}

