/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.cid;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.ClientInformation;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.CidOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.CidOtpResponse;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.Pid;
import in.gov.uidai.ec.ecmpapi.xml.cidgenerateotp.PidType;
import in.gov.uidai.ec.ecmpapi.xml.common.ModeType;
import in.gov.uidai.ec.ecmpapi.xml.common.Result;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.DeRegisterStationRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.DeRegisterStationResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.StationDeRegistrationData;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.StationRegistrationData;
import in.gov.uidai.ec.escapi.CompleteDeRegistrationException;
import in.gov.uidai.ec.escapi.StartDeRegistrationException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.PreSyncDelegate;
import in.gov.uidai.ec.service.registration.DeRegisterStationDelegate;
import in.gov.uidai.ec.service.registration.EnrolmentAgency;
import in.gov.uidai.ec.service.registration.IRegistrarAndEADAO;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.registration.RegisterStationDelegate;
import in.gov.uidai.ec.service.registration.Registrar;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.token.TokenManagerDAO;
import in.gov.uidai.eca.ui.cid.CidViewPeer;
import in.gov.uidai.eca.ui.cid.OtpValidationDelegate;
import in.gov.uidai.eca.ui.login.ICurrentAdminProvider;
import in.gov.uidai.eca.ui.main.ECAMainWinDecorator;
import in.gov.uidai.eca.ui.msg.MsgKeysCid;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFormattedTextField;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CidControl
implements IOnScreenDisplayAware,
IEventContextAware {
    private static final String TOKEN_API = "PACKET_STATUS_API";
    private static final Logger LOGGER = LoggerFactory.getLogger(CidControl.class);
    private static int retryOtpCount = 0;
    private final Map<String, Registrar> registrarMap = new HashMap<String, Registrar>();
    private final Map<String, EnrolmentAgency> agencyMap = new HashMap<String, EnrolmentAgency>();
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private IRegistrarAndEADAO registrarAndEADAO;
    private IResourceBundleContext rbCtxt;
    private ECAMainWinDecorator mainWinDec;
    private ICurrentAdminProvider adminProvider;
    private IOnboardingService onboardingService;
    private List<Registrar> registrars = null;
    private boolean firstTime;
    private int regCalCount;
    private boolean agencyFirstTime;
    private IRegistrationService registrationService;
    private ISessionService sessionService;
    private EcmpApiService ecmpApiService;
    private PreSyncDelegate preSyncDelegate;
    private ClientInformation clientInformation;
    private TokenManagerDAO tokenManager;

    public void setClientInformation(ClientInformation clientInformation) {
        this.clientInformation = clientInformation;
    }

    public void setTokenManager(TokenManagerDAO tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setPreSyncDelegate(PreSyncDelegate preSyncDelegate) {
        this.preSyncDelegate = preSyncDelegate;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setRegistrarEA(IRegistrarAndEADAO registrarEA) {
        this.registrarAndEADAO = registrarEA;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setMainWinDec(ECAMainWinDecorator mainWin) {
        this.mainWinDec = mainWin;
    }

    public void setCurrentAdminProvider(ICurrentAdminProvider cap) {
        this.adminProvider = cap;
    }

    @EventHandler(name="hID_Cid_SectionSelect", method="actionPerformed")
    public void onCidSelect(ILiteEvent evt) {
        LOGGER.debug("client identity tab selected");
        this.osd.recompose(evt.getScaffoldId(), "cidView");
        this.firstTime = true;
        this.agencyFirstTime = true;
        String viewId = this.osd.getScaffold(evt.getScaffoldId()).getViewId();
        ILiteView view = this.osd.getView(viewId);
        view.setEnabled(false);
        IVisualExecutionContext xCtxt = view.getVisualExecutionContext();
        if (xCtxt != null) {
            xCtxt.reset();
            xCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysCid.VEX_REFRESH, new Object[0]));
        }
        Map eMap = view.getElementMap();
        this.initRegistrationSection(eMap);
        if (this.registrationService.canDoRegistration()) {
            this.showNoRegMsg(view);
            ((IViewElement)eMap.get("eID_Cid_DeRegBut")).set("enable", (Object)false);
            view.setEnabled(true);
        } else {
            this.showRegMsg(view);
            this.disableEditOfRegistrarAgencyDetails(view);
            if (this.registrationService.isDeregistrationPrerequisitesNotStarted() && !this.registrationService.isRegistrationRequested()) {
                ((IViewElement)eMap.get("eID_Cid_DeRegBut")).set("enable", (Object)true);
            } else if (this.registrationService.isDeregistrationPrerequisitesCompleted()) {
                this.showDeRegInProgressMsg(view, true);
            } else if (this.registrationService.isDeregistrationPrerequisitesInProgress()) {
                this.showDeRegInProgressMsg(view, false);
            }
        }
        view.setEnabled(true);
        if (xCtxt != null) {
            xCtxt.cancel();
        }
    }

    private void initRegistrationSection(Map<String, IViewElement> eMap) {
        this.firstTime = true;
        this.agencyFirstTime = true;
        eMap.get("eID_Cid_MachineCode").set("text", (Object)this.registrationService.getSystemMachineCode());
        if (this.registrars == null || this.registrars.size() <= 0) {
            this.getRegistrars();
        }
        eMap.get("eID_Cid_RegistrarName").set("options", this.registrars);
        Registrar savedRegistrar = this.registrarMap.get(this.registrationService.getRegistrarId());
        if (savedRegistrar != null) {
            eMap.get("eID_Cid_RegistrarCode").set("text", (Object)savedRegistrar.getCode());
            eMap.get("eID_Cid_RegistrarName").set("selectedItem", (Object)savedRegistrar);
        }
        eMap.get("eID_Cid_StationId").set("text", (Object)this.registrationService.getStationId());
        String agencyLocation = this.registrationService.getClientLocation();
        agencyLocation = !StringUtils.isNumericSpace((String)agencyLocation) ? "" : agencyLocation;
        eMap.get("eID_Cid_ClientLocation").set("text", (Object)("" + agencyLocation));
    }

    @EventHandler(name="hID_Cid_Register", method="actionPerformed")
    public void onRequestRegistration(ILiteEvent evt) {
        LOGGER.debug("registering with cidr");
        ILiteView view = this.osd.getView(evt.getViewId());
        if (!this.isMandatoryFieldsEntered(view.getElementMap())) {
            return;
        }
        view.setEnabled(false);
        String registrarId = this.retrieveField(view, "eID_Cid_RegistrarCode");
        String agencyId = this.retrieveField(view, "eID_Cid_AgencyCode");
        String stationId = this.retrieveField(view, "eID_Cid_StationId");
        String aadhaarNo = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)CidViewPeer.aadhaarField, (String)"000000000000");
        String password = "";
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysCid.VEX_REGISTER, new Object[0]));
        }
        CIDRStatus regStatus = this.registerClient(registrarId, agencyId, stationId, aadhaarNo, password, true);
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        if (!regStatus.equals((Object)CIDRStatus.SUCCESS)) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)this.rbCtxt.getMessage((Object)MsgKeysCid.REGISTER, new Object[]{regStatus.getDescription()}), (Component)parent, new Object[0]);
        } else {
            String scafid = this.osd.compose("cidOTPWin", "cidOtpView");
            if (veCtxt != null) {
                veCtxt.reset();
                veCtxt.setMessage("Generating OTP, Please wait.");
            }
            CidOtpRequest cidOtpReq = new CidOtpRequest();
            cidOtpReq.setOperatorId(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)CidViewPeer.aadhaarField, (String)"000000000000"));
            cidOtpReq.setClientType("ECA");
            cidOtpReq.setModeType(ModeType.OFFLINE);
            cidOtpReq.setGenOtpOrVerifyOtp(true);
            this.removeOnboardedUsers(evt);
            try {
                CidOtpResponse cidOtpResponse = this.ecmpApiService.registrationOtpVerify(cidOtpReq);
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                view.setEnabled(true);
                if (cidOtpResponse.getResult().equals((Object)Result.SUCCESS)) {
                    LOGGER.info("Otp Generated Successfully");
                    this.osd.display(scafid, ScaffoldPlacement.CENTERED);
                } else if (cidOtpResponse.getResult().equals((Object)Result.FAILURE)) {
                    LOGGER.info("Failed to Generate Otp");
                }
            }
            catch (Exception e) {
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                LOGGER.info("Error While Generating Otp", (Throwable)e);
                L10nOptionPaneBuilder.getInstance().showError((Object)("Error While Generating Otp. " + e.getMessage()), (Component)parent, new Object[0]);
            }
        }
        if (regStatus.equals((Object)CIDRStatus.SUCCESS)) {
            this.setRegDetails();
            this.removeOnboardedUsers(evt);
            if (StringUtils.isNotBlank((String)this.tokenManager.getToken(TOKEN_API))) {
                this.firePreSyncRequest();
            }
            this.setRegDetails();
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }

    public boolean validateUid(String uid) {
        if (StringUtils.isBlank((String)uid)) {
            return false;
        }
        if (uid.startsWith("0") || uid.startsWith("1")) {
            return false;
        }
        return Verhoeff.validate((String)uid);
    }

    private void removeOnboardedUsers(ILiteEvent evt) {
        try {
            ILocalVerificationService lvs = LVSLocator.instance();
            List opList = this.onboardingService.getAllOnboardedUsers();
            if (opList != null && opList.size() > 0) {
                opList.stream().map(UserCredentials::getUid).forEach(arg_0 -> ((ILocalVerificationService)lvs).deleteUser(arg_0));
                L10nOptionPaneBuilder.getInstance().showInfo((Object)this.rbCtxt.getMessage((Object)MsgKeysCid.ONBOARD_AGAIN, new Object[0]), (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
                LOGGER.debug("List of Onboarded users removed");
            }
        }
        catch (Exception e) {
            LOGGER.error("unable to connect with lvs", (Throwable)e);
        }
    }

    private void firePreSyncRequest() {
        try {
            List opList = this.onboardingService.getAllOnboardedUsers();
            PreSyncRequest preSyncRequest = this.preSyncDelegate.prepareServiceRequest(this.adminProvider.getUserId(), opList, false);
            this.ecmpApiService.preSyncClient(preSyncRequest);
        }
        catch (Exception e) {
            LOGGER.error("PreSync with Server failed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_On_CidOtp_Submit", method="actionPerformed")
    public void otpSubmit(ILiteEvent evt) {
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (!new OtpValidationDelegate().isOtpValid(view)) {
            return;
        }
        CidOtpRequest cidOtpReq = new CidOtpRequest();
        ++retryOtpCount;
        ArrayList<Pid> pidList = new ArrayList<Pid>();
        Pid pid = new Pid();
        pid.setOtpReceived((String)((IViewElement)view.getElementMap().get("eID_Cid_Otp")).get("text"));
        pid.setPidType(PidType.AGENCY_ADMIN);
        pidList.add(pid);
        cidOtpReq.setOperatorId(EnrolHelper.getDeformattedFieldValue((JFormattedTextField)CidViewPeer.aadhaarField, (String)"000000000000"));
        cidOtpReq.setClientType("ECA");
        cidOtpReq.setModeType(ModeType.OFFLINE);
        cidOtpReq.setGenOtpOrVerifyOtp(false);
        cidOtpReq.setPid(pidList);
        try {
            CidOtpResponse cidOtpResponse;
            if (veCtxt != null) {
                veCtxt.reset();
                veCtxt.setMessage("Registering client & Verifying OTP. Please wait.");
            }
            if ((cidOtpResponse = this.ecmpApiService.registrationOtpVerify(cidOtpReq)).getResult().equals((Object)Result.SUCCESS)) {
                String registrarId = CidViewPeer.registrarCode.getText();
                String agencyId = CidViewPeer.agencyCode.getText();
                String stationId = CidViewPeer.stationId.getText();
                String pd = "";
                String aadhaarField = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)CidViewPeer.aadhaarField, (String)"000000000000");
                CIDRStatus regStatus = this.registerClient(registrarId, agencyId, stationId, aadhaarField, pd, false);
                if (!regStatus.equals((Object)CIDRStatus.SUCCESS)) {
                    if (veCtxt != null) {
                        veCtxt.cancel();
                    }
                    L10nOptionPaneBuilder.getInstance().showError((Object)this.rbCtxt.getMessage((Object)MsgKeysCid.REGISTER, new Object[]{regStatus.getDescription()}), (Component)parent, new Object[0]);
                    ILiteScaffold pScaf = this.osd.getScaffold(evt.getScaffoldId());
                    if (pScaf != null) {
                        this.osd.dispose(pScaf.getId());
                    }
                } else {
                    ILiteScaffold pScaf = this.osd.getScaffold(evt.getScaffoldId());
                    if (pScaf != null) {
                        this.osd.dispose(pScaf.getId());
                    }
                    L10nOptionPaneBuilder.getInstance().showInfo((Object)this.rbCtxt.getMessage((Object)MsgKeysCid.REGISTER_DL, new Object[0]), (Component)parent, new Object[0]);
                    this.setRegDetails();
                    this.evtCtxt.fireGenericEvent("showClientIdentity", new Object[0]);
                }
            } else if (cidOtpResponse.getResult().equals((Object)Result.FAILURE)) {
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                if (retryOtpCount >= 3) {
                    L10nOptionPaneBuilder.getInstance().showError((Object)"Exceeded the maximum limit, Please Regenerate Otp", (Component)parent, new Object[0]);
                    ILiteScaffold pScaf = this.osd.getScaffold(evt.getScaffoldId());
                    if (pScaf != null) {
                        this.osd.dispose(pScaf.getId());
                    }
                    retryOtpCount = 0;
                } else {
                    L10nOptionPaneBuilder.getInstance().showError((Object)"OTP failed to verify. Please try again.", (Component)parent, new Object[0]);
                }
                LOGGER.info("Otp Generation Failed");
            }
        }
        catch (Exception e) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)("Error While Generating Otp. " + e.getMessage()), (Component)parent, new Object[0]);
            LOGGER.error("Error While Generating Otp", (Throwable)e);
        }
        finally {
            Object pd = null;
        }
    }

    private CIDRStatus registerClient(String registrarId, String agencyId, String stationId, String aadhaarNo, String password, boolean isStep1) {
        this.clientInformation.setRegistrarId(registrarId);
        this.clientInformation.setAgencyId(agencyId);
        this.clientInformation.setStationId(stationId);
        this.clientInformation.setMachineCode(this.registrationService.getSystemMachineCode());
        this.clientInformation.setVersion(this.registrationService.getApplicationFullVersion());
        CIDRStatus regStatus = CIDRStatus.LOCAL_DATA_ERROR;
        RegisterStationDelegate regDelegate = new RegisterStationDelegate(this.registrationService);
        RegisterStationRequest request = new RegisterStationRequest();
        try {
            StationRegistrationData registrationData = regDelegate.prepareRegistrationDataForRegister(this.clientInformation, isStep1);
            request.setRegistrationData(registrationData);
            RegisterStationResponse response = this.ecmpApiService.makeRegistrationRequest(aadhaarNo, password, request);
            LOGGER.info("Connecting to CIDR was successful.");
            regStatus = regDelegate.processServiceResponse(request, response, isStep1);
        }
        catch (IOException e) {
            LOGGER.error("Connecting to the Server failed.", (Throwable)e);
            regStatus = CIDRStatus.NETWORK_ERROR;
        }
        catch (Exception e) {
            LOGGER.error("Error during client registration", (Throwable)e);
        }
        return regStatus;
    }

    @EventHandler(name="hid_cid_Reg_Select", method="actionPerformed")
    public void onRegistrarNameSelect(ILiteEvent evt) {
        String oldRegistrarCode;
        if (this.firstTime && this.regCalCount < 1) {
            ++this.regCalCount;
            return;
        }
        ILiteView view = this.osd.getView(evt.getViewId());
        view.setEnabled(false);
        Map eMap = view.getElementMap();
        Registrar registrar = (Registrar)((IViewElement)eMap.get("eID_Cid_RegistrarName")).get("selectedItem");
        if (registrar == null) {
            LOGGER.error("Selected Registrar cannot be null");
            return;
        }
        String newRegistrarCode = registrar.getCode();
        if (newRegistrarCode.equals(oldRegistrarCode = (String)((IViewElement)eMap.get("eID_Cid_RegistrarCode")).get("text")) && !this.firstTime) {
            return;
        }
        boolean isSelect = registrar.getName().equalsIgnoreCase("Select");
        String regCode = isSelect ? "0" : newRegistrarCode;
        ((IViewElement)eMap.get("eID_Cid_RegistrarCode")).set("text", (Object)regCode);
        List<EnrolmentAgency> agencies = this.getAgencies(newRegistrarCode, isSelect);
        ((IViewElement)eMap.get("eID_Cid_AgencyName")).set("options", agencies);
        if (this.firstTime) {
            agencies.forEach(agency -> this.agencyMap.put(agency.getCode(), (EnrolmentAgency)agency));
            ((IViewElement)eMap.get("eID_Cid_AgencyName")).set("selectedItem", (Object)this.agencyMap.get(this.registrationService.getAgencyId()));
            this.firstTime = false;
            this.agencyFirstTime = true;
        }
        this.regCalCount = 0;
    }

    @EventHandler(name="hid_cid_Agency_Select", method="actionPerformed")
    public void onAgencyNameSelect(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        view.setEnabled(false);
        Map eMap = view.getElementMap();
        EnrolmentAgency agency = (EnrolmentAgency)((IViewElement)eMap.get("eID_Cid_AgencyName")).get("selectedItem");
        if (agency == null) {
            return;
        }
        boolean isSelect = agency.getName().equalsIgnoreCase("Select");
        ((IViewElement)eMap.get("eID_Cid_AgencyCode")).set("text", (Object)(isSelect ? "0" : agency.getCode()));
        EnrolmentAgency enrolmentAgency = this.agencyMap.get(this.registrationService.getAgencyId());
        if (this.agencyFirstTime && enrolmentAgency != null && agency.getCode().equals(enrolmentAgency.getCode())) {
            this.agencyFirstTime = false;
        } else {
            ((IViewElement)eMap.get("eID_Cid_StationId")).set("text", (Object)"");
            ((IViewElement)eMap.get("eID_Cid_ClientLocation")).set("text", (Object)"");
        }
    }

    @EventHandler(name="hID_Cid_Deregister", method="actionPerformed")
    public void onCIDDeregister(ILiteEvent evt) {
        LOGGER.debug("Deregistering the Client");
        ILiteView view = this.osd.getView(evt.getViewId());
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        if (L10nOptionPaneBuilder.getInstance().showYesNoConfirmation((Object)"This action will start Deregisteration of the client. Do you wish to continue?", (Component)parent).equals((Object)MsgKeysCommon.NO)) {
            return;
        }
        this.registrationService.doStartDeregistrationPrerequisites();
        try {
            this.registrationService.startDeRegistration();
        }
        catch (StartDeRegistrationException e) {
            LOGGER.error("Starting De Registration failed: ", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)e.getMessage(), (Component)parent, new Object[0]);
            return;
        }
        catch (IOException e) {
            LOGGER.error("Error with Aadhaar Enrol Service Client communication: ", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)"Error communicating to Aadhaar Enrol Service Client, Please make sure it is running from system services", (Component)parent, new Object[0]);
            return;
        }
        this.showDeRegInProgressMsg(view, false);
        if (this.registrationService.isDeregistrationPrerequisitesCompleted()) {
            this.onCidSelect(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Cid_Comp_Deregister", method="actionPerformed")
    public void onCidCompDeregister(ILiteEvent evt) {
        block17: {
            LOGGER.debug("Complete Deregistering the Client..");
            Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
            if (L10nOptionPaneBuilder.getInstance().showYesNoConfirmation((Object)"This action will Deregister the client. Do you wish to continue?", (Component)parent).equals((Object)MsgKeysCommon.NO)) {
                return;
            }
            try {
                CIDRStatus deRegStatus;
                ILiteView view = this.osd.getView(evt.getViewId());
                view.setEnabled(false);
                IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
                if (veCtxt != null) {
                    veCtxt.reset();
                    veCtxt.setMessage("Deregistering this enrolment client with CIDR. Please wait.");
                }
                try {
                    DeRegisterStationDelegate deRegisterStationDelegate = new DeRegisterStationDelegate();
                    deRegisterStationDelegate.prepareServiceRequest(this.adminProvider.getUserId(), this.registrationService);
                    StationDeRegistrationData stationDeRegistrationData = deRegisterStationDelegate.prepareServiceRequest(this.adminProvider.getUserId(), this.registrationService);
                    DeRegisterStationRequest request = new DeRegisterStationRequest();
                    request.setDeRegistrationData(stationDeRegistrationData);
                    DeRegisterStationResponse deRegisterStationResponse = this.ecmpApiService.deregisterClient(request);
                    LOGGER.info("Connecting to CIDR was successful.");
                    deRegStatus = deRegisterStationDelegate.processServiceResponse(deRegisterStationResponse);
                }
                catch (IOException e) {
                    LOGGER.error("Connecting to the Server failed.", (Throwable)e);
                    deRegStatus = CIDRStatus.NETWORK_ERROR;
                }
                catch (Exception e) {
                    LOGGER.error("Deregistration failed", (Throwable)e);
                    deRegStatus = CIDRStatus.LOCAL_DATA_ERROR;
                }
                finally {
                    if (veCtxt != null) {
                        veCtxt.cancel();
                    }
                    view.setEnabled(true);
                }
                if (!CIDRStatus.SUCCESS.equals((Object)deRegStatus)) {
                    L10nOptionPaneBuilder.getInstance().showInfo((Object)("Deregistration unsuccessful due to " + deRegStatus.getDescription()), (Component)parent, new Object[0]);
                    break block17;
                }
                this.registrationService.doDeregistration();
                this.sessionService.deleteSessionFiles();
                try {
                    this.registrationService.completeDeRegistration();
                }
                catch (CompleteDeRegistrationException e) {
                    L10nOptionPaneBuilder.getInstance().showError((Object)e.getMessage(), (Component)parent, new Object[0]);
                    throw e;
                }
                catch (IOException e) {
                    L10nOptionPaneBuilder.getInstance().showError((Object)"Error communicating to Aadhaar Enrol Service Client, Please make sure it is running from system services", (Component)parent, new Object[0]);
                    throw e;
                }
                ((IViewElement)view.getElementMap().get("eID_Cid_DeRegBut")).set("enable", (Object)false);
                L10nOptionPaneBuilder.getInstance().showInfo((Object)"De-registration successfully completed. Please register the application for further enrolment.", (Component)parent, new Object[0]);
                this.onCidSelect(evt);
            }
            catch (Exception e) {
                LOGGER.debug("De-registration failed. ", (Throwable)e);
            }
        }
    }

    @EventHandler(name="hID_Cid_Dereg_Checklist", method="actionPerformed")
    public void onShowDeregChecklistWin(ILiteEvent evt) {
        String scafId = this.osd.compose(evt.getScaffoldId(), "deregChecklistWin", "deregChecklistView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    private String retrieveField(ILiteView view, String fieldName) {
        return (String)((IViewElement)view.getElementMap().get(fieldName)).get("text");
    }

    private void showNoRegMsg(ILiteView view) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Cid_RegMsg")).set("visible", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_NoRegMsg")).set("visible", (Object)true);
        ((IViewElement)eMap.get("eID_Cid_MissingRegMsg")).set("visible", (Object)false);
    }

    private void enableUsernamePassword(ILiteView view) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Cid_UserName")).set("enable", (Object)true);
        ((IViewElement)eMap.get("eID_Cid_Password")).set("enable", (Object)true);
    }

    private void showRegMsg(ILiteView view) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Cid_RegMsg")).set("visible", (Object)true);
        ((IViewElement)eMap.get("eID_Cid_NoRegMsg")).set("visible", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_MissingRegMsg")).set("visible", (Object)false);
    }

    private void disableEditOfRegistrarAgencyDetails(ILiteView view) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Cid_StationId")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_AgencyCode")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_AgencyName")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_RegistrarName")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_RegistrarCode")).set("enable", (Object)false);
        ((IViewElement)eMap.get("eID_Cid_ClientLocation")).set("enable", (Object)false);
    }

    private void showDeRegInProgressMsg(ILiteView view, boolean deregInProgress) {
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Cid_DeRegMsg")).set("visible", (Object)true);
        ((IViewElement)eMap.get("eID_Cid_CompDeRegMsg")).set("enable", (Object)deregInProgress);
        ((IViewElement)eMap.get("eID_Cid_DeRegBut")).set("visible", (Object)false);
    }

    private boolean isMandatoryFieldsEntered(Map<String, IViewElement> eMap) {
        boolean allMandatoryFieldsEntered = true;
        String mandateMsg = "This is a mandatory field and cannot be empty";
        int registrarIndex = (Integer)eMap.get("eID_Cid_RegistrarName").get("selectedIndex");
        int agencyIndex = (Integer)eMap.get("eID_Cid_AgencyName").get("selectedIndex");
        String stationId = (String)eMap.get("eID_Cid_StationId").get("text");
        String aadhaarNo = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)CidViewPeer.aadhaarField, (String)"000000000000");
        this.clearNotification(eMap);
        if (registrarIndex <= 0) {
            eMap.get("eID_Cid_RegistrarName").mset("notify", new Object[]{"error", mandateMsg});
            allMandatoryFieldsEntered = false;
        }
        if (agencyIndex <= 0) {
            eMap.get("eID_Cid_AgencyName").mset("notify", new Object[]{"error", mandateMsg});
            allMandatoryFieldsEntered = false;
        }
        if (StringUtils.isBlank((String)stationId)) {
            eMap.get("eID_Cid_StationId").mset("notify", new Object[]{"error", mandateMsg});
            allMandatoryFieldsEntered = false;
        } else if (stationId.length() < 5) {
            eMap.get("eID_Cid_StationId").mset("notify", new Object[]{"error", "Station id should be 5 digits."});
            allMandatoryFieldsEntered = false;
        }
        if (!this.validateUid(aadhaarNo)) {
            eMap.get("eID_Cid_AadhaarNo").mset("notify", new Object[]{"error", "Invalid Aadhaar No."});
            allMandatoryFieldsEntered = false;
        }
        return allMandatoryFieldsEntered;
    }

    private void clearNotification(Map<String, IViewElement> eMap) {
        eMap.get("eID_Cid_AgencyName").mset("notify", new Object[]{""});
        eMap.get("eID_Cid_RegistrarName").mset("notify", new Object[]{""});
        eMap.get("eID_Cid_StationId").mset("notify", new Object[]{""});
    }

    private Registrar getSelectOptionAsRegistrar() {
        Registrar registrar = new Registrar();
        registrar.setCode("0");
        registrar.setName("Select");
        return registrar;
    }

    private void getRegistrars() {
        try {
            this.registrars = this.registrarAndEADAO.readAllRegistrars();
        }
        catch (ClientException ce) {
            LOGGER.debug("", (Throwable)ce);
        }
        if (this.registrars == null) {
            this.registrars = new ArrayList<Registrar>();
        }
        this.registrars.add(0, this.getSelectOptionAsRegistrar());
        this.registrars.forEach(registrar -> this.registrarMap.put(registrar.getCode(), (Registrar)registrar));
    }

    private List<EnrolmentAgency> getAgencies(String registrarCode, boolean isSelect) {
        ArrayList<EnrolmentAgency> agencies = null;
        EnrolmentAgency enAgency = new EnrolmentAgency();
        enAgency.setCode("0");
        enAgency.setName("Select");
        try {
            if (!isSelect) {
                agencies = this.registrarAndEADAO.findAgenciesByRegistrar(registrarCode);
            }
        }
        catch (ClientException ce) {
            LOGGER.debug("", (Throwable)ce);
        }
        if (agencies == null) {
            agencies = new ArrayList<EnrolmentAgency>();
        }
        agencies.add(0, enAgency);
        return agencies;
    }

    private void setRegDetails() {
        Map<String, IViewElement> map = this.mainWinDec.getElementMap();
        if (map == null) {
            return;
        }
        String regDetails = this.registrationService.getRegistrarId() + "-" + this.registrationService.getAgencyId() + "-" + this.registrationService.getStationId();
        map.get("eid_Reg_Details").set("text", (Object)regDetails);
    }

    @EventHandler(name="hID_On_CidOtp_Escape", method="actionPerformed")
    public void onEscCloseWin(ILiteEvent evt) {
        retryOtpCount = 0;
        this.osd.dispose(evt.getScaffoldId());
    }
}

