/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.dbm;

import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.dbm.IDBVolumeManager;
import in.gov.uidai.eca.dbm.IRuntimeDBManager;
import in.gov.uidai.eca.namedic.INameDictionaryManager;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import java.awt.Window;
import java.io.File;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbmControl
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbmControl.class);
    private IOnScreenDisplay osd;
    private IRuntimeDBManager runDbMgr;
    private IDBVolumeManager volMan;
    private INameDictionaryManager dicMan;
    private IRegistrationService registrationService;

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setRuntimeDBManager(IRuntimeDBManager mgr) {
        this.runDbMgr = mgr;
        LOGGER.debug("runtime db manager set");
    }

    public void setVolumeManager(IDBVolumeManager mgr) {
        this.volMan = mgr;
        LOGGER.debug("db volume manager set");
    }

    public final void setDictionaryManager(INameDictionaryManager dictionaryManager) {
        this.dicMan = dictionaryManager;
        LOGGER.debug("Dictionary manager set");
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        LOGGER.debug("on screen display set");
    }

    @EventHandler(name="hID_Dbm_SectionSelect", method="actionPerformed")
    public void onDbmSelect(ILiteEvent evt) {
        LOGGER.debug("database mgmt tab selected");
        this.osd.recompose(evt.getScaffoldId(), "dbmView");
        String viewId = this.osd.getScaffold(evt.getScaffoldId()).getViewId();
        ILiteView view = this.osd.getView(viewId);
        view.setEnabled(false);
        Map eMap = view.getElementMap();
        boolean shouldEnableImport = !this.registrationService.isDeregistrationInProgress();
        ((IViewElement)eMap.get("eID_Dbm_RegistrarName")).set("enable", (Object)shouldEnableImport);
        ((IViewElement)eMap.get("eID_Dbm_REGISTRAR_SELECT_BUTTON")).set("enable", (Object)shouldEnableImport);
        ((IViewElement)eMap.get("eID_Dbm_REGISTRAR_IMPORT_BUTTON")).set("enable", (Object)shouldEnableImport);
        view.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Dbm_CreateDb", method="actionPerformed")
    public void onDbCreate(ILiteEvent evt) {
        LOGGER.debug("creating runtime database");
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        JOptionPane optPane = new JOptionPane("Are you sure, you want to re-create the runtime database?", 3);
        optPane.setOptions(new String[]{"Yes", "No"});
        optPane.setInitialValue("No");
        JDialog dlg = optPane.createDialog("Aadhaar Warning");
        dlg.setVisible(true);
        if (StringUtils.equalsIgnoreCase((String)optPane.getValue().toString(), (String)"No")) {
            return;
        }
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Creating the runtime databse. Please wait.");
        }
        try {
            this.runDbMgr.createAndDeploy();
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Runtime database successfully created. Please restart your application to continue", "Database Creation Complete", -1, 1, null, options, options[0]);
        }
        catch (Exception exep) {
            LOGGER.error("failed", (Throwable)exep);
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Internal error encountered in creting runtime database.", "Database Creation Error", -1, 0, null, options, options[0]);
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }

    @EventHandler(name="hID_Dbm_SelectRegistrar", method="actionPerformed")
    public void onRegistrarFileSelect(ILiteEvent evt) {
        LOGGER.debug("selecting registrar db file");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Dbm_RegistrarName")).get("text");
        JFileChooser chooser = new JFileChooser(new File(fileName));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Compressed Database File (*.zip)", "zip");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(win);
        if (returnVal == 0) {
            ((IViewElement)eMap.get("eID_Dbm_RegistrarName")).set("text", (Object)chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @EventHandler(name="hID_Dbm_ImportRegistrar", method="actionPerformed")
    public void onRegistrarFileImport(ILiteEvent evt) {
        LOGGER.debug("importing registrar db file");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Dbm_RegistrarName")).get("text");
        LOGGER.debug("loading from: " + fileName);
        if (StringUtils.isBlank((String)fileName)) {
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Please enter a file name to import", "Registrar Data Import Error", -1, 0, null, options, options[0]);
            return;
        }
        File registrarFile = new File(fileName);
        if (!registrarFile.exists() || !registrarFile.isFile()) {
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "The selected file does not exist", "Registrar Data Import Error", -1, 0, null, options, options[0]);
            return;
        }
        try {
            this.volMan.importRegistrarDB(registrarFile.getCanonicalPath());
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Registrar data imported successfully.", "Import Complete", -1, 1, null, options, options[0]);
        }
        catch (Exception exep) {
            LOGGER.error("registrar data import", (Throwable)exep);
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "There was an internal error in importing registrar data", "Registrar Data Import Error", -1, 0, null, options, options[0]);
        }
    }

    @EventHandler(name="hID_Dbm_SelectNameDictionary", method="actionPerformed")
    public void onNameDictionaryFileSelect(ILiteEvent evt) {
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Dbm_DictionaryName")).get("text");
        JFileChooser chooser = new JFileChooser(new File(fileName));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Name Dictionary File (*.zip)", "zip");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(win);
        if (returnVal == 0) {
            ((IViewElement)eMap.get("eID_Dbm_DictionaryName")).set("text", (Object)chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @EventHandler(name="hID_Dbm_ImportNameDictionary", method="actionPerformed")
    public void onNameDictionaryFileImport(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        Map eMap = view.getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Dbm_DictionaryName")).get("text");
        LOGGER.debug("loading from: " + fileName);
        if (StringUtils.isBlank((String)fileName)) {
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Please enter a file name to import", "Name Dictionary Data Import Error", -1, 0, null, options, options[0]);
            return;
        }
        File dictionaryFile = new File(fileName);
        if (!dictionaryFile.exists() || !dictionaryFile.isFile()) {
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "The selected file does not exist", "Name Dictionary Data Import Error", -1, 0, null, options, options[0]);
            return;
        }
        try {
            this.dicMan.updateNameDictionaries(dictionaryFile.getCanonicalPath());
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "Name Dictionary data imported successfully.", "Import Complete", -1, 1, null, options, options[0]);
        }
        catch (UnsupportedOperationException uoe) {
            LOGGER.error("Name Dictionary data import error:" + uoe.getMessage());
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, uoe.getMessage(), "Name Dictionary Data Import Error", -1, 0, null, options, options[0]);
        }
        catch (Exception exep) {
            LOGGER.error("Name Dictionary data import", (Throwable)exep);
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, "There was an internal error in importing the name dictionary:\n" + exep.getMessage(), "Name Dictionary Data Import Error", -1, 0, null, options, options[0]);
        }
    }
}

