/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.login;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.swing.notify.AlwaysOnTopOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ECACredentialsLoader
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ECACredentialsLoader.class);
    private Resource credDataLoc;
    private IOnboardingAdminService onboardingAdminService;

    public void setUserCredentialsData(Resource dataLoc) {
        this.credDataLoc = dataLoc;
    }

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardingAdminService = onboardingAdminService;
    }

    public void afterPropertiesSet() {
        LVSLocator lvsLocator = null;
        try {
            lvsLocator = new LVSLocator();
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (lvsLocator.get() == null) {
            String msg = "The Local Verification Service is not accessible. This application will now terminate.";
            AlwaysOnTopOptionPane.create().messageType(0).optionType(-1).message(msg).title("Aadhaar").winIcon("res/images/frame_icon.png").show();
            System.exit(1);
        }
        try {
            this.onboardingAdminService.load(this.credDataLoc.getURL(), true);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            AlwaysOnTopOptionPane.create().messageType(0).optionType(-1).message("Fatal error loading user credentials. Detailed message is: " + e.getMessage() + "\nThis application will now terminate.").title("Aadhaar").winIcon("res/images/frame_icon.png").show();
            System.exit(1);
        }
    }
}

