/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.login;

import in.gov.uidai.ec.icas.preference.PreferencesPostProcessor;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.ui.login.ICurrentAdminProvider;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ECALoginControl
implements IEventContextAware,
IOnScreenDisplayAware,
ApplicationListener,
ICurrentAdminProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ECALoginControl.class);
    private IEventContext evtCtxt;
    private IOnScreenDisplay osd;
    private IRegistrationService registrationService;
    private IOnboardingService onboardingService;
    private String operatorId;
    private String operatorName;

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        if (PreferencesPostProcessor.PropertiesLoadError) {
            LOGGER.error(PreferencesPostProcessor.PropertiesLoadErrorDesc);
            L10nOptionPaneBuilder.getInstance().showError((Object)PreferencesPostProcessor.PropertiesLoadErrorDesc, null, new Object[0]);
            System.exit(0);
            return;
        }
        if (!(evt instanceof ContextRefreshedEvent)) {
            return;
        }
        String sId = this.osd.compose("loginWin", "loginView");
        this.osd.display(sId, ScaffoldPlacement.CENTERED);
    }

    @Override
    public String getUserId() {
        return this.operatorId;
    }

    @Override
    public String getUserName() {
        return this.operatorName;
    }

    @EventHandler(name="opLoginWinHandler", method="windowOpened")
    public void onWindowOpened(ILiteEvent evt) {
        LOGGER.debug("opening operator login window");
        this.checkClientReg(evt);
        ArrayList userIdList = this.onboardingService.getAllUsers().stream().map(UserCredentials::getOperatorId).collect(Collectors.toCollection(ArrayList::new));
        ILiteScaffold scaffold = this.osd.getScaffold(evt.getScaffoldId());
        ILiteView view = this.osd.getView(scaffold.getViewId());
        IViewElement opIdElement = (IViewElement)view.getElementMap().get("eID_LoginOpId");
        opIdElement.set("options", (Object)userIdList);
    }

    @EventHandler(name="opLoginWinEscHandler", method="actionPerformed")
    public void onWindowEscaped(ILiteEvent evt) {
        LOGGER.debug("escape pressed on operator login window");
        System.exit(0);
    }

    @EventHandler(name="opLogin", method="actionPerformed")
    public void onOperatorLogin(ILiteEvent evt) {
        LOGGER.debug("handling operator login");
        ILiteView view = this.osd.getView(evt.getViewId());
        view.setEnabled(false);
        if (!this.performLoginAuth(evt, view)) {
            view.setEnabled(true);
            return;
        }
        this.performMachineCodeCheck(evt);
        this.osd.dispose(evt.getScaffoldId());
        this.evtCtxt.fireGenericEvent("showMainWin", new Object[0]);
    }

    private boolean performLoginAuth(ILiteEvent evt, ILiteView view) {
        IViewElement opIdElement = (IViewElement)view.getElementMap().get("eID_LoginOpId");
        this.operatorId = (String)opIdElement.get("selectedItem");
        IViewElement opNameElement = (IViewElement)view.getElementMap().get("eID_LoginOpName");
        this.operatorName = (String)opNameElement.get("text");
        IViewElement opUIdElement = (IViewElement)view.getElementMap().get("eID_LoginOpUid");
        String operatorUid = (String)opUIdElement.get("value");
        UserCredentials cred = this.onboardingService.getUser(this.operatorId);
        String message = "";
        if (cred == null || StringUtils.isBlank((String)cred.getAuthId())) {
            message = "User credentials not found";
        } else if (StringUtils.isBlank((String)operatorUid)) {
            message = "Please enter Operator UID for authentication";
        } else if (!operatorUid.equals(cred.getUid())) {
            message = "Invalid Operator UID.";
            opUIdElement.set("value", (Object)"");
        }
        if (!message.isEmpty()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)message, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            return false;
        }
        return true;
    }

    private void performMachineCodeCheck(ILiteEvent evt) {
        boolean isMachineCodeChanged;
        try {
            isMachineCodeChanged = this.registrationService.hasMachineCodeChanged();
        }
        catch (Exception e) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Error performing machine code check.\nPlease shut down the client and revert to earlier system configuration or re-register the station.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            LOGGER.error("error performing machine code check: ", (Throwable)e);
            return;
        }
        if (isMachineCodeChanged) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Change in machine code detected, this may be due to a change in system configuration. \nPlease shut down the client and revert to earlier system configuration or re-register the station.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            LOGGER.debug("There was machine code mismatch.!");
        }
    }

    @EventHandler(name="opLoginCancel", method="actionPerformed")
    public void onOperatorCancel(ILiteEvent evt) {
        LOGGER.debug("handling operator login cancel");
        System.exit(0);
    }

    @EventHandler(name="opIdSelect", method="itemStateChanged")
    public void onOperatorIdSelect(ILiteEvent evt) {
        ItemEvent ie = (ItemEvent)evt.getEvent();
        if (ie.getStateChange() == 2) {
            return;
        }
        LOGGER.debug("handling operator id select");
        ILiteView view = this.osd.getView(evt.getViewId());
        IViewElement opIdElement = (IViewElement)view.getElementMap().get("eID_LoginOpId");
        IViewElement opNameElement = (IViewElement)view.getElementMap().get("eID_LoginOpName");
        ((IViewElement)view.getElementMap().get("eID_LoginOpUid")).set("text", (Object)"");
        String userId = (String)opIdElement.get("selectedItem");
        UserCredentials cred = this.onboardingService.getUser(userId);
        String fullName = cred != null ? cred.getFullName() : "";
        opNameElement.set("text", (Object)fullName);
    }

    private void checkClientReg(ILiteEvent evt) {
        if (this.registrationService.isDeregistered()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"This copy of the enrolment client administration is not registered. Please register the Application.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
    }
}

