/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.login;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.eca.ui.onboard.IUIPreference;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.EidUidFieldBuilder;
import in.gov.uidai.swing.ImageArea;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.util.AutoSearchHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ECALoginViewPeer
extends StandardViewPeer {
    @ExportViewElement(as="eID_LoginOpUid", using=StandardSwingElementFactory.class)
    protected JFormattedTextField operatorUidField;
    @ExportViewElement(as="eID_LoginOpId", using=StandardSwingElementFactory.class)
    private JComboBox<DefaultListCellRenderer> opIdField;
    @ExportViewElement(as="eID_LoginOpName", using=StandardSwingElementFactory.class)
    private JLabel opNameField;
    private JLabel opUidField;
    private JButton loginBut;
    private JButton cancelBut;
    private IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    protected void enableImpl(boolean flag) {
        this.opIdField.setEnabled(flag);
        this.opUidField.setEnabled(flag);
        this.loginBut.setEnabled(flag);
        if (flag) {
            Cursor cursor = Cursor.getDefaultCursor();
            this.getContentPane().setCursor(cursor);
        } else {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.getContentPane().setCursor(cursor);
        }
        this.cancelBut.setCursor(Cursor.getDefaultCursor());
    }

    protected void prepareImpl() {
        this.setMenuBar(null);
        this.opIdField = new JComboBox();
        this.opIdField.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                return this;
            }

            @Override
            public Insets getInsets(Insets insets) {
                return new Insets(2, 2, 2, 2);
            }
        });
        this.opNameField = new JLabel("xxx");
        this.opNameField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        this.operatorUidField = EidUidFieldBuilder.createUidField();
        this.loginBut = new JButton("Login");
        this.cancelBut = new JButton("Cancel");
        double[][] guides = new double[][]{{250.0, 5.0, 100.0, 50.0, 5.0, 50.0, 20.0}, {10.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 5.0, 25.0, 25.0, 25.0}};
        TransparentBox cntPane = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.setContentPane((JComponent)cntPane);
        ImageArea logo = new ImageArea("res/images/aadhar_logo.png");
        cntPane.add((Component)logo, (Object)"0, 1, 0, 7, f, b");
        String logoText = "<html><div align='center'>Enrolment Client Administration<br>version " + ApplicationVersion.FULLDISPLAYVERSION;
        cntPane.add((Component)new JLabel(logoText), (Object)"0, 8, 0, 9, c, t");
        this.opUidField = new JLabel("Operator UID");
        ldeco.localize(this.opUidField, (Object)"Operator UID", new Object[0]);
        cntPane.add((Component)new JLabel("Operator ID"), (Object)"2, 1, 5, 1, f, f");
        cntPane.add(this.opIdField, (Object)"2, 2, 5, 2, f, f");
        cntPane.add((Component)new JLabel("Operator Name"), (Object)"2, 3, 5, 3, f, c");
        cntPane.add((Component)this.opNameField, (Object)"2, 4, 5, 4, f, f");
        cntPane.add((Component)this.opUidField, (Object)"2, 5, 5, 5, f, c");
        cntPane.add((Component)this.operatorUidField, (Object)"2, 6, 5, 6, f, f");
        cntPane.add((Component)this.loginBut, (Object)"3, 8, f, c");
        cntPane.add((Component)this.cancelBut, (Object)"5, 8, f, c");
        JLabel copyright = new JLabel("Copyright (c) UID Authority of India, all rights reserved");
        copyright.setHorizontalAlignment(0);
        copyright.setBackground(Color.decode("#84a9d8"));
        copyright.setOpaque(true);
        copyright.setBorder(new EmptyBorder(0, 0, 0, 0));
        cntPane.add((Component)copyright, (Object)"0, 10, 6, 10, f, f");
        ItemListener idHandler = (ItemListener)this.getEventContext().getEventListener("opIdSelect", ItemListener.class);
        this.opIdField.addItemListener(idHandler);
        this.opIdField.setEditable(true);
        new AutoSearchHandler(this.opIdField);
        ActionListener loginAxn = (ActionListener)this.getEventContext().getEventListener("opLogin", ActionListener.class);
        this.loginBut.addActionListener(loginAxn);
        ActionListener cancelAxn = (ActionListener)this.getEventContext().getEventListener("opLoginCancel", ActionListener.class);
        this.cancelBut.addActionListener(cancelAxn);
        this.operatorUidField.addActionListener(loginAxn);
    }

    protected void disposeImpl() {
    }
}

