/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.main;

import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.util.Map;

public class ECAMainWinControl
implements IOnScreenDisplayAware {
    private IOnScreenDisplay osd;
    private ILiteScaffold mainWin;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    @GenericEventHandler(value="showMainWin")
    public void onShowMainWin() {
        String sId = this.osd.compose("mainWin", "blankView");
        this.osd.display(sId, ScaffoldPlacement.MAXIMIZED);
        this.mainWin = this.osd.getScaffold(sId);
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("mainWin.clientIdentity")).call("click");
    }

    @GenericEventHandler(value="timeChangeClosing")
    public void ChangingTime() {
        String sId = this.osd.compose("mainWin", "blankView");
        L10nOptionPaneBuilder.getInstance().showError((Object)"System time has been changed, application will be closed!", null, new Object[0]);
        this.osd.dispose(sId);
        System.exit(0);
    }

    @GenericEventHandler(value="timeZoneChangeClosing")
    public void ChangingTimeZone() {
        String sId = this.osd.compose("mainWin", "blankView");
        L10nOptionPaneBuilder.getInstance().showError((Object)"System timezone does not match with (UTC+05:30)Chennai,Kolkata,Mumbai,New Delhi, Application will be closed !", null, new Object[0]);
        this.osd.dispose(sId);
        System.exit(0);
    }

    @EventHandler(name="mainWinHandler", method="windowClosing")
    public void onWindowClosing(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
        System.exit(0);
    }

    @GenericEventHandler(value="showClientIdentity")
    public void onShowClientIdentity() {
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("mainWin.clientIdentity")).call("click");
    }

    @GenericEventHandler(value="showClientSecurity")
    public void onShowClientSecurity() {
        Map elementMap = this.mainWin.getElementMap();
        ((IViewElement)elementMap.get("mainWin.security")).call("click");
    }
}

