/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.main;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.SampleFormatInfo;
import in.gov.uidai.ec.biometrics.device.VideoFormatInfo;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.machineidentity.MachineInfo;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.ui.login.ICurrentAdminProvider;
import in.gov.uidai.eca.ui.main.IEACMainWinConstants;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.tsb.ITsbDecorator;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ImageArea;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.StatusBarClock;
import in.gov.uidai.swing.StatusBarGPS;
import in.gov.uidai.swing.ToolBarButton;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationPopup;
import in.gov.uidai.swing.painter.IPaintDelegate;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECAMainWinDecorator
implements ITsbDecorator,
IEACMainWinConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ECAMainWinDecorator.class);
    private static final String DEVICE_STATUS = "device-status";
    private static final String SB_SLAP_ON = "SB_SLAP_ON";
    private static final String SB_SLAP_OFF = "SB_SLAP_OFF";
    private static final String SB_IRIS_ON = "SB_IRIS_ON";
    private static final String SB_IRIS_OFF = "SB_IRIS_OFF";
    private static final String KS_MONITOR_SYSTEM_INFO = "alt control I";
    private final Map<String, IViewElement> elementMap = new HashMap<String, IViewElement>();
    @ExportViewElement(as="eid_Reg_Details", using=StandardSwingElementFactory.class)
    JLabel regDetails;
    private IEventContext evtCtxt;
    private ICurrentAdminProvider adminProvider;
    private JToolBar toolBar;
    private TransparentBox statusBar;
    private ImageArea slapStatus;
    private ImageArea irisStatus;
    private IClientDeviceManager clientDevMgr;
    private IRegistrationService registrationService;
    private StatusBarGPS statusBarGPS;

    public void setCurrentAdminProvider(ICurrentAdminProvider cap) {
        this.adminProvider = cap;
        LOGGER.debug("current admin provider set");
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.clientDevMgr = cdm;
    }

    public void setDeviceLifeCycleListener(DeviceLifeCycleListener deviceLifeCycleListener) {
        deviceLifeCycleListener.addDeviceStartedListener(this::doDeviceStarted);
        deviceLifeCycleListener.addDeviceStoppedListener(this::doDeviceStopped);
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setStatusBarGPS(StatusBarGPS statusBarGPS) {
        this.statusBarGPS = statusBarGPS;
    }

    public void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void prepare() {
        this.toolBar = new JToolBar(0);
        this.toolBar.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        try {
            ImageArea logo = new ImageArea("res/eca/images/aadhar_logo_tb.png");
            this.toolBar.add((Component)logo, "West");
        }
        catch (Exception exep) {
            LOGGER.warn("cannot find logo", (Throwable)exep);
        }
        StandardSwingElementFactory ssef = new StandardSwingElementFactory();
        TransparentBox buttonArea = new TransparentBox();
        BoxLayout buttonAreaLayout = new BoxLayout((Container)buttonArea, 0);
        buttonArea.setLayout((LayoutManager)buttonAreaLayout);
        this.toolBar.add((Component)buttonArea, "East");
        this.addShortCutToMonitorCPUAndMemoryUsage();
        ButtonGroup butGrp2 = new ButtonGroup();
        ToolBarButton tbCid = new ToolBarButton("Client Identity", "res/eca/images/tb-client-identity.png");
        buttonArea.add((Component)tbCid);
        butGrp2.add((AbstractButton)tbCid);
        tbCid.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_Cid_SectionSelect", ActionListener.class));
        this.elementMap.put("mainWin.clientIdentity", ssef.get((Object)tbCid, "mainWin.clientIdentity"));
        ToolBarButton tbOnboard = new ToolBarButton("Local Enrolment", "res/eca/images/tb-onboard.png");
        buttonArea.add((Component)tbOnboard);
        butGrp2.add((AbstractButton)tbOnboard);
        tbOnboard.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_Ob_SectionSelect", ActionListener.class));
        this.elementMap.put("mainWin.dbm", ssef.get((Object)tbOnboard, "mainWin.dbm"));
        ToolBarButton tbSecurity = new ToolBarButton("Client Security", "res/eca/images/tb-security.png");
        buttonArea.add((Component)tbSecurity);
        butGrp2.add((AbstractButton)tbSecurity);
        tbSecurity.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_Security_Section_Select", ActionListener.class));
        this.elementMap.put("mainWin.security", ssef.get((Object)tbSecurity, "mainWin.security"));
        ToolBarButton tbDemo = new ToolBarButton("Demographics Screen", "res/eca/images/tb-demo-custom.png");
        buttonArea.add((Component)tbDemo);
        butGrp2.add((AbstractButton)tbDemo);
        tbDemo.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_PrefEdit_Select", ActionListener.class));
        this.elementMap.put("mainWin.demoCustom", ssef.get((Object)tbDemo, "mainWin.demoCustom"));
        ToolBarButton tbDbm = new ToolBarButton("Database Mgmt.", "res/eca/images/tb-dbm.png");
        buttonArea.add((Component)tbDbm);
        butGrp2.add((AbstractButton)tbDbm);
        tbDbm.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_Dbm_SectionSelect", ActionListener.class));
        this.elementMap.put("mainWin.dbm", ssef.get((Object)tbDbm, "mainWin.dbm"));
        this.statusBar = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        LinearGradientBackground statusBg = new LinearGradientBackground().direction(1).borderSize(0.0f).roundingSize(2, 2).gradientColors("#6a6a6a, #404040").gradientStops("0, 1");
        this.statusBar.setBackground((IPaintDelegate)statusBg);
        this.statusBar.setPreferredSize(new Dimension(32, 32));
        TransparentBox devStatusArea = new TransparentBox((LayoutManager)new GridLayout(1, 2, 4, 4));
        devStatusArea.setBorder((Border)new EmptyBorder(4, 4, 4, 4));
        this.statusBar.add((Component)devStatusArea, (Object)"West");
        this.slapStatus = new ImageArea();
        this.slapStatus.setPreferredSize(new Dimension(28, 28));
        this.slapStatus.setBorder((Border)new RoundedBorder().lineColor("#ffffff").lineThickness(1.0f).rounding(3, 3));
        NotificationPopup.getToolTip((JComponent)this.slapStatus, (String)DEVICE_STATUS).setLocation(NotificationLocation.TOP);
        this.slapStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_SLAP_OFF));
        devStatusArea.add((Component)this.slapStatus);
        this.irisStatus = new ImageArea();
        this.irisStatus.setPreferredSize(new Dimension(28, 28));
        this.irisStatus.setBorder((Border)new RoundedBorder().lineColor("#ffffff").lineThickness(1.0f).rounding(3, 3));
        NotificationPopup.getToolTip((JComponent)this.irisStatus, (String)DEVICE_STATUS).setLocation(NotificationLocation.TOP);
        this.irisStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_IRIS_OFF));
        devStatusArea.add((Component)this.irisStatus);
        this.clientDevMgr.refreshDeviceStates();
        this.statusBar.add((Component)this.createApplicationStatus(), (Object)"East");
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JComponent getStatusBar() {
        return this.statusBar;
    }

    public Map<String, IViewElement> getElementMap() {
        return this.elementMap;
    }

    private void addShortCutToMonitorCPUAndMemoryUsage() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MachineInfo.monitorCPUAndMemoryUsage();
            }
        };
        String keyAction = "MonitorCPUAndMemoryUsage";
        InputMap inMap = this.toolBar.getInputMap(2);
        inMap.put(KeyStroke.getKeyStroke(KS_MONITOR_SYSTEM_INFO), keyAction);
        ActionMap axnMap = this.toolBar.getActionMap();
        axnMap.put(keyAction, action);
    }

    private void doDeviceStarted(DeviceType type) {
        if (type == null) {
            return;
        }
        IDeviceContext devCtxt = this.clientDevMgr.getDeviceContext(type);
        if (devCtxt == null) {
            return;
        }
        DeviceInfo devInfo = devCtxt.getDeviceInformation();
        Map attribMap = devInfo.getDeviceAttributes();
        StringBuffer tipText = new StringBuffer("<html>");
        for (Object key : attribMap.keySet()) {
            String value = (String)attribMap.get(key);
            tipText.append("<b>").append((String)key).append(":</b> ").append(value).append("<br>");
        }
        tipText.append("<b>Video Formats:</b> ");
        List vfiList = devInfo.getVideoFormats();
        if (vfiList.isEmpty()) {
            tipText.append("information not available");
        } else {
            for (VideoFormatInfo vfi : vfiList) {
                tipText.append("modality=").append(vfi.getModality()).append(" ").append(vfi.getWidth() + "x" + vfi.getHeight()).append(" ").append(vfi.getPixelFormat()).append(" ");
            }
        }
        List sfiList = devInfo.getSampleFormats();
        tipText.append("<br><b>Sample Formats:</b> ");
        if (sfiList.isEmpty()) {
            tipText.append("information not available");
        } else {
            for (SampleFormatInfo sfi : sfiList) {
                tipText.append(sfi.getWidth() + "x" + sfi.getHeight()).append(" ").append(sfi.getResolution()).append(" ");
            }
        }
        switch (type) {
            case FINGERPRINT: {
                this.slapStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_SLAP_ON));
                this.slapStatus.setToolTipText(tipText.toString());
                NotificationPopup.getToolTip((JComponent)this.slapStatus, (String)DEVICE_STATUS).showToolTip("Fingerprint capure device is now available", true);
                break;
            }
            case IRIS: {
                this.irisStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_IRIS_ON));
                this.irisStatus.setToolTipText(tipText.toString());
                NotificationPopup.getToolTip((JComponent)this.irisStatus, (String)DEVICE_STATUS).showToolTip("Iris capture device is now available", true);
            }
        }
    }

    private void doDeviceStopped(DeviceType type) {
        if (type == null) {
            return;
        }
        switch (type) {
            case FINGERPRINT: {
                this.slapStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_SLAP_OFF));
                this.slapStatus.setToolTipText("Fingerprint scanner unplugged/not available");
                NotificationPopup.getToolTip((JComponent)this.slapStatus, (String)DEVICE_STATUS).showToolTip("Fingerprint scanner unplugged/not available", true);
                break;
            }
            case IRIS: {
                this.irisStatus.setIcon((Icon)ImageIconCache.getInst().getIcon(SB_IRIS_OFF));
                this.irisStatus.setToolTipText("Iris scanner unplugged/not available");
                NotificationPopup.getToolTip((JComponent)this.irisStatus, (String)DEVICE_STATUS).showToolTip("Iris scanner unplugged/not available", true);
            }
        }
    }

    private JComponent createApplicationStatus() {
        StandardSwingElementFactory ssef = new StandardSwingElementFactory();
        TransparentBox appStatusArea = new TransparentBox((LayoutManager)new FlowLayout(2, 0, 0));
        appStatusArea.setBorder((Border)new EmptyBorder(8, 4, 0, 0));
        SingleLineBorder slb = new SingleLineBorder().lineThickness(1.0f).lineColor("#ffffff").drawEdges(false, false, false, true);
        CompoundBorder cb = new CompoundBorder((Border)slb, new EmptyBorder(0, 4, 0, 4));
        String opId = this.adminProvider.getUserId();
        String opName = this.adminProvider.getUserName();
        JLabel opDetails = new JLabel("(" + opId + ") " + opName);
        opDetails.setForeground(Color.WHITE);
        opDetails.setBorder(cb);
        String regId = this.registrationService.getRegistrarId();
        String eacId = this.registrationService.getAgencyId();
        String stationId = this.registrationService.getStationId();
        String location = this.registrationService.getClientLocation();
        if (location.equals("0")) {
            location = "000000";
        }
        String registrationDetails = StringUtils.isNotBlank((String)location) ? regId + "-" + eacId + "-" + stationId + "-" + location : regId + "-" + eacId + "-" + stationId;
        this.regDetails = new JLabel(registrationDetails);
        this.regDetails.setForeground(Color.WHITE);
        this.regDetails.setBorder(cb);
        this.elementMap.put("eid_Reg_Details", ssef.get((Object)this.regDetails, "eid_Reg_Details"));
        JLabel verDetails = new JLabel("version " + ApplicationVersion.FULLDISPLAYVERSION);
        verDetails.setForeground(Color.WHITE);
        verDetails.setBorder(cb);
        StatusBarClock clock = new StatusBarClock("dd-MMM-yyyy hh:mm:ss a", 500, this.evtCtxt);
        clock.setForeground(Color.WHITE);
        clock.setBorder((Border)cb);
        this.statusBarGPS.init();
        this.statusBarGPS.setForeground(Color.WHITE);
        this.statusBarGPS.setBorder((Border)new EmptyBorder(0, 5, 0, 4));
        appStatusArea.add((Component)opDetails);
        appStatusArea.add((Component)this.regDetails);
        appStatusArea.add((Component)verDetails);
        appStatusArea.add((Component)clock);
        appStatusArea.add((Component)this.statusBarGPS);
        return appStatusArea;
    }

    static {
        ImageIconCache.getInst().addIcon(SB_SLAP_ON, "res/eca/images/sb-slap.png");
        ImageIconCache.getInst().addIcon(SB_SLAP_OFF, "res/eca/images/sb-slap-off.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_ON, "res/images/sb-iris.png");
        ImageIconCache.getInst().addIcon(SB_IRIS_OFF, "res/images/sb-iris-off.png");
    }
}

