/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.eca.ui.onboard.IOnboardConstants;
import in.gov.uidai.eca.ui.onboard.IUIPreference;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.NucleusLayout;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureGroup;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CaptureIrisViewComposite
implements IViewElementComposite,
IOnboardConstants {
    private IResourceBundleContext resBundleCtxt;
    private IEventContext evtCtxt;
    private IClientDeviceManager cdm;
    private IBioxDataProvider bdp;
    private TransparentBox irisPanel;
    private IUIPreference uiPref;
    @ExportViewElement(as="eID_Ob_IrisTab_LeftEye", using=BiometricsElementFactory.class)
    private BiometricsCaptureField leftEyeField;
    @ExportViewElement(as="eID_Ob_IrisTab_RightEye", using=BiometricsElementFactory.class)
    private BiometricsCaptureField rightEyeField;
    @ExportViewElement(as="eID_Ob_IrisTab_BothEyes", using=BiometricsElementFactory.class)
    private BiometricsCaptureField bothEyesField;
    @ExportViewElement(as="eID_Ob_IrisTab_ModeOpt", using=StandardSwingElementFactory.class)
    private JCheckBox modeOpt;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
    }

    public void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    public final void setBioxDataProvider(IBioxDataProvider provider) {
        this.bdp = provider;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void prepare() {
        PreviewPlayer2 previewPlayer = new PreviewPlayer2();
        L10nDecorator ldeco = new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false));
        this.leftEyeField = new BiometricsCaptureField("Left Iris", BiometricPosition.LEFT_IRIS, new EnrollmentService[0]);
        this.leftEyeField.localize(ldeco);
        this.leftEyeField.setPreviewPlayer((AbstractPreviewPlayer)previewPlayer);
        this.leftEyeField.setClientDeviceManager(this.cdm);
        this.addQSSListener("eID_Ob_IrisTab_LeftEye", this.leftEyeField, null, "hID_QSS_Iris");
        this.addBioListener("eID_Ob_IrisTab_LeftEye", this.leftEyeField, "hID_QSS_Iris_Capture");
        this.leftEyeField.addBiometricsListener((IBiometricsListener)this.evtCtxt.getEventListener("hID_QSSDedup_IrisCapture", IBiometricsListener.class));
        this.rightEyeField = new BiometricsCaptureField("Right Iris", BiometricPosition.RIGHT_IRIS, new EnrollmentService[0]);
        this.rightEyeField.localize(ldeco);
        this.rightEyeField.setPreviewPlayer((AbstractPreviewPlayer)previewPlayer);
        this.rightEyeField.setClientDeviceManager(this.cdm);
        this.addQSSListener("eID_Ob_IrisTab_RightEye", this.rightEyeField, null, "hID_QSS_Iris");
        this.addBioListener("eID_Ob_IrisTab_RightEye", this.rightEyeField, "hID_QSS_Iris_Capture");
        this.rightEyeField.addBiometricsListener((IBiometricsListener)this.evtCtxt.getEventListener("hID_QSSDedup_IrisCapture", IBiometricsListener.class));
        BiometricsCaptureGroup bioGrp = new BiometricsCaptureGroup();
        bioGrp.addField(this.leftEyeField);
        bioGrp.addField(this.rightEyeField);
        this.bothEyesField = new BiometricsCaptureField("Both Iris", BiometricPosition.BOTH_IRIS, new EnrollmentService[0]);
        this.bothEyesField.localize(ldeco);
        this.bothEyesField.setPreviewPlayer((AbstractPreviewPlayer)previewPlayer);
        this.bothEyesField.setClientDeviceManager(this.cdm);
        this.bothEyesField.setBioxDataProvider(this.bdp);
        this.addQSSListener("eID_Ob_IrisTab_BothEyes", this.bothEyesField, BiometricPosition.LEFT_IRIS, "hID_QSS_Iris");
        this.addQSSListener("eID_Ob_IrisTab_BothEyes", this.bothEyesField, BiometricPosition.RIGHT_IRIS, "hID_QSS_Iris");
        this.addBioListener("eID_Ob_IrisTab_BothEyes", this.bothEyesField, "hID_QSS_Dual_Iris_Capture");
        this.bothEyesField.addBiometricsListener((IBiometricsListener)this.evtCtxt.getEventListener("hID_QSSDedup_IrisCapture", IBiometricsListener.class));
        this.modeOpt = new JCheckBox("Capture Each Iris Separately");
        this.leftEyeField.setMinimumSize(new Dimension(200, 200));
        this.leftEyeField.setPreferredSize(new Dimension(450, 450));
        this.rightEyeField.setMinimumSize(new Dimension(200, 200));
        this.rightEyeField.setPreferredSize(new Dimension(450, 450));
        this.bothEyesField.setMinimumSize(new Dimension(200, 450));
        this.bothEyesField.setPreferredSize(new Dimension(900, 450));
        this.irisPanel = new TransparentBox((LayoutManager)new NucleusLayout(5, 5));
        this.irisPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.irisPanel.add((Component)previewPlayer, (Object)"Center");
        this.irisPanel.add((Component)this.rightEyeField);
        this.irisPanel.add((Component)this.leftEyeField);
        this.irisPanel.add((Component)this.bothEyesField);
        this.irisPanel.setOpaque(true);
        this.irisPanel.setBackground(Color.GRAY);
        this.irisPanel.setFocusable(true);
        this.leftEyeField.setVisible(false);
        this.rightEyeField.setVisible(false);
    }

    public JCheckBox getModeOption() {
        return this.modeOpt;
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        eftp.addComponent((Component)this.bothEyesField).addComponent((Component)this.rightEyeField).addComponent((Component)this.leftEyeField);
    }

    public JComponent toSwing() {
        return this.irisPanel;
    }

    private void addQSSListener(String fieldName, BiometricsCaptureField field, BiometricPosition bioPos, String hid) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        if (bioPos != null) {
            evtParams.put("prm_BioFieldSubType", (String)bioPos);
            field.addQSSActionListener((ActionListener)this.evtCtxt.getEventListener(hid, ActionListener.class, evtParams), bioPos);
        } else {
            field.addQSSActionListener((ActionListener)this.evtCtxt.getEventListener(hid, ActionListener.class, evtParams));
        }
    }

    private void addBioListener(String fieldName, BiometricsCaptureField field, String hid) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        field.addBiometricsListener((IBiometricsListener)this.evtCtxt.getEventListener(hid, IBiometricsListener.class, evtParams));
    }
}

