/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.eca.ui.msg.MsgKeysOnboard;
import in.gov.uidai.eca.ui.onboard.IEcaQSSConstants;
import in.gov.uidai.eca.ui.onboard.QATableEntry;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FingerprintQualityFeedback;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcaQssControl
implements IOnScreenDisplayAware,
IEcaQSSConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcaQssControl.class);
    private static final DecimalFormat SCORE_FORMAT = new DecimalFormat("###.00");
    private IResourceBundleContext rbCtxt;
    private IOnScreenDisplay osd;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        LOGGER.debug("OSD populated");
    }

    @EventHandler(name="hID_QSS_Close", method="actionPerformed")
    public void onCloseQSS(ILiteEvent evt) {
        LOGGER.debug("disposing scaffold " + evt.getScaffoldId());
        this.osd.dispose(evt.getScaffoldId());
        LOGGER.debug("disposing view " + evt.getViewId());
        this.osd.disposeView(evt.getViewId());
    }

    @EventHandler(name="hID_QSS_Slap_Capture", method="componentIsBusy")
    public void onSlapBusy(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext vex = view.getVisualExecutionContext();
        if (vex != null) {
            vex.reset();
            vex.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_QSS, new Object[0]));
        }
    }

    @EventHandler(name="hID_QSS_Slap_Capture", method="componentIsReady")
    public void onSlapReady(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext vex = view.getVisualExecutionContext();
        if (vex != null) {
            vex.cancel();
        }
    }

    @EventHandler(name="hID_QSS_Slap_Capture", method="sampleReceived")
    public void onShowSlapQSSCapture(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        LOGGER.debug("called from scaffold " + pScafId);
        ILiteView pView = this.osd.getView(evt.getViewId());
        CaptureAttempt attempt = (CaptureAttempt)((IViewElement)pView.getElementMap().get(evt.getExtraParameters().get("prm_BioFieldName"))).get("currentAttempt");
        if (attempt == null) {
            return;
        }
        Object qssData = attempt.getQSS();
        if (qssData == null) {
            return;
        }
        Compliance compliance = ((FingerprintQSS)qssData).getOverallCompliance();
        if (compliance != null && compliance.equals((Object)Compliance.OK)) {
            return;
        }
        String scafId = this.osd.compose(pScafId, "qssWin", "fingerQssView");
        String viewId = this.osd.getScaffold(scafId).getViewId();
        ILiteView view = this.osd.getView(viewId);
        this.populateFingerQSS((FingerprintQSS)qssData, view.getElementMap(), true);
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_QSS_Slap", method="actionPerformed")
    public void onShowSlapQSS(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        LOGGER.debug("called from scaffold " + pScafId);
        ILiteView pView = this.osd.getView(evt.getViewId());
        CaptureAttempt attempt = (CaptureAttempt)((IViewElement)pView.getElementMap().get(evt.getExtraParameters().get("prm_BioFieldName"))).get("currentAttempt");
        if (attempt == null) {
            return;
        }
        Object qssData = attempt.getQSS();
        if (qssData == null) {
            return;
        }
        String scafId = this.osd.compose(pScafId, "qssWin", "fingerQssView");
        String viewId = this.osd.getScaffold(scafId).getViewId();
        ILiteView view = this.osd.getView(viewId);
        this.populateFingerQSS((FingerprintQSS)qssData, view.getElementMap(), false);
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    private void populateFingerQSS(FingerprintQSS qss, Map<String, IViewElement> eMap, boolean initial) {
        eMap.get("eID_Qss_OverallScore").set("text", (Object)SCORE_FORMAT.format(qss.getOverallScore()));
        eMap.get("eID_Qss_OverallCompliance").set("text", (Object)qss.getOverallCompliance().toString());
        eMap.get("eID_Qss_OverallComment").set("text", (Object)("<html>" + qss.getOverallComments()));
        List fqbList = qss.getQualityFeedback();
        ArrayList<QATableEntry> tableData = new ArrayList<QATableEntry>(fqbList.size());
        for (FingerprintQualityFeedback fqb : fqbList) {
            if (initial && !fqb.getCompliance().equals((Object)Compliance.ERROR)) continue;
            QATableEntry entry = new QATableEntry();
            entry.setQualityAttribute(fqb.getQualityAttribute().toString());
            entry.setValue(SCORE_FORMAT.format(fqb.getScore()));
            entry.setCompliance(fqb.getCompliance().toString());
            entry.setComment(fqb.getComments());
            tableData.add(entry);
        }
        eMap.get("eID_Qss_Details").set("value", tableData);
    }
}

