/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.eca.ui.onboard.ComplianceCellRenderer;
import in.gov.uidai.eca.ui.onboard.IEcaQSSConstants;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.widgets.BeanTableModel;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcaQssViewPeer
extends StandardViewPeer
implements IEcaQSSConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcaQssViewPeer.class);
    private IResourceBundleContext resBundleCtxt;
    @ExportViewElement(as="eID_Qss_OverallScore", using=StandardSwingElementFactory.class)
    private JLabel overallScoreField;
    @ExportViewElement(as="eID_Qss_OverallCompliance", using=StandardSwingElementFactory.class)
    private JLabel overallComplianceField;
    @ExportViewElement(as="eID_Qss_OverallComment", using=StandardSwingElementFactory.class)
    private JLabel overallCommentField;
    @ExportViewElement(as="eID_Qss_Details", using=StandardSwingElementFactory.class)
    private JTable detailsTable;

    public final void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
        LOGGER.debug("set");
    }

    public final void setWindowTitle(String title) {
        this.setTitle(title);
    }

    protected void enableImpl(boolean flag) {
    }

    protected void prepareImpl() {
        this.setMenuBar(null);
        TransparentBox cntPane = new TransparentBox();
        cntPane.setLayout((LayoutManager)new BoxLayout((Container)cntPane, 1));
        cntPane.add((Component)this.createSummaryArea());
        cntPane.add((Component)this.createDetailsArea());
        cntPane.add((Component)this.createNavArea());
        this.setContentPane((JComponent)cntPane);
    }

    protected void disposeImpl() {
    }

    private JComponent createSummaryArea() {
        double[][] guides = new double[][]{{70.0, 5.0, -1.0}, {5.0, 20.0, 2.0, 20.0, 2.0, 30.0, 2.0}};
        TransparentBox summaryArea = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.overallScoreField = new JLabel();
        this.overallComplianceField = new JLabel();
        this.overallCommentField = new JLabel();
        summaryArea.add((Component)new JLabel("Score:"), (Object)"0, 1, right, top");
        summaryArea.add((Component)this.overallScoreField, (Object)"2, 1, full, top");
        summaryArea.add((Component)new JLabel("Compliance:"), (Object)"0, 3, right, top");
        summaryArea.add((Component)this.overallComplianceField, (Object)"2, 3, full, top");
        summaryArea.add((Component)new JLabel("Comments:"), (Object)"0, 5, right, top");
        summaryArea.add((Component)this.overallCommentField, (Object)"2, 5, full, top");
        return summaryArea;
    }

    private JComponent createDetailsArea() {
        BeanTableModel tableModel = new BeanTableModel();
        tableModel.addColumn("*", "compliance", String.class);
        tableModel.addColumn("Quality Attribute", "qualityAttribute", String.class);
        tableModel.addColumn("Value", "value", String.class);
        tableModel.addColumn("Comments", "comment", String.class);
        this.detailsTable = new JTable((TableModel)tableModel);
        this.detailsTable.setAutoResizeMode(4);
        this.detailsTable.setRowHeight(20);
        TableColumn col0 = this.detailsTable.getColumnModel().getColumn(0);
        col0.setCellRenderer(new ComplianceCellRenderer());
        col0.setMaxWidth(25);
        col0.setMinWidth(25);
        col0.setPreferredWidth(25);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public boolean isOpaque() {
                return true;
            }

            @Override
            public Insets getInsets(Insets insets) {
                if (insets == null) {
                    return null;
                }
                insets.left = 5;
                return insets;
            }
        };
        TableColumn col1 = this.detailsTable.getColumnModel().getColumn(1);
        col1.setMaxWidth(120);
        col1.setMinWidth(120);
        col1.setCellRenderer(renderer);
        TableColumn col2 = this.detailsTable.getColumnModel().getColumn(2);
        col2.setMaxWidth(45);
        col2.setMinWidth(45);
        col2.setCellRenderer(renderer);
        TableColumn col3 = this.detailsTable.getColumnModel().getColumn(3);
        col3.setCellRenderer(renderer);
        TransparentBox detailsArea = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        detailsArea.setPreferredSize(new Dimension(500, 150));
        detailsArea.add((Component)new JScrollPane(this.detailsTable), (Object)"Center");
        detailsArea.setBorder((Border)new EmptyBorder(0, 5, 0, 5));
        return detailsArea;
    }

    private JComponent createNavArea() {
        TransparentBox navArea = new TransparentBox((LayoutManager)new FlowLayout(1, 0, 0));
        navArea.setBorder((Border)new EmptyBorder(10, 5, 2, 5));
        JButton closeButton = new JButton("Close");
        ActionListener closeAxn = (ActionListener)this.getEventContext().getEventListener("hID_QSS_Close", ActionListener.class);
        closeButton.addActionListener(closeAxn);
        navArea.add((Component)closeButton);
        return navArea;
    }
}

