/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.eca.ui.onboard.IOnboardConstants;
import in.gov.uidai.eca.ui.onboard._ValidationDelegate;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardBioxDataProvider
implements IBioxDataProvider,
IOnboardConstants,
IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnboardBioxDataProvider.class);
    private List<BiometricPosition> availableFingers;
    private List<BiometricPosition> missingFingers;
    private List<BiometricPosition> availableEyes;
    private List<BiometricPosition> missingEyes;
    private _ValidationDelegate validDel;
    private IOnScreenDisplay osd;

    public OnboardBioxDataProvider() {
        this.resetData();
        this.validDel = new _ValidationDelegate();
        this.validDel.setBioxDataProvider(this);
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        LOGGER.debug("on screen display set");
    }

    @EventHandler(name="hID_Ob_BioxTabChange", method="stateChanged")
    public void onBioxTabChanged(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null) {
            return;
        }
        Map eMap = view.getElementMap();
        if (eMap == null) {
            return;
        }
        IViewElement leftHand = (IViewElement)eMap.get("eID_Ob_BioxLeftHand");
        IViewElement rightHand = (IViewElement)eMap.get("eID_Ob_BioxRightHand");
        this.availableFingers = new ArrayList<BiometricPosition>();
        this.missingFingers = new ArrayList<BiometricPosition>();
        List list = null;
        list = (List)leftHand.get("available");
        this.availableFingers.addAll(list);
        list = (List)rightHand.get("available");
        this.availableFingers.addAll(list);
        list = (List)leftHand.get("missing");
        this.missingFingers.addAll(list);
        list = (List)rightHand.get("missing");
        this.missingFingers.addAll(list);
        this.validDel.validateFingerprint(view);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("available fingers: " + this.availableFingers);
            LOGGER.debug("missing fingers: " + this.missingFingers);
        }
    }

    public List<BiometricPosition> getAvailableEyes() {
        return this.availableEyes;
    }

    public List<BiometricPosition> getAvailableFingers() {
        return this.availableFingers;
    }

    public List<BiometricPosition> getMissingEyes() {
        return this.missingEyes;
    }

    public List<BiometricPosition> getMissingFingers() {
        return this.missingFingers;
    }

    public final void resetData() {
        this.availableEyes = new ArrayList<BiometricPosition>();
        this.availableEyes.add(BiometricPosition.LEFT_IRIS);
        this.availableEyes.add(BiometricPosition.RIGHT_IRIS);
        this.missingEyes = new ArrayList<BiometricPosition>();
        List<BiometricPosition> list = Arrays.asList(BiometricPosition.LEFT_INDEX, BiometricPosition.LEFT_MIDDLE, BiometricPosition.LEFT_RING, BiometricPosition.LEFT_LITTLE, BiometricPosition.LEFT_THUMB, BiometricPosition.RIGHT_INDEX, BiometricPosition.RIGHT_MIDDLE, BiometricPosition.RIGHT_RING, BiometricPosition.RIGHT_LITTLE, BiometricPosition.RIGHT_THUMB);
        this.availableFingers = new ArrayList<BiometricPosition>(list);
        this.missingFingers = new ArrayList<BiometricPosition>();
    }
}

