/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperator;
import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperators;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncResponse;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.security.impl.JarIntegrityCheck;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.presync.PreSyncDelegate;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.ui.msg.MsgKeysOnboard;
import in.gov.uidai.eca.ui.onboard.UserTableData;
import in.gov.uidai.eca.ui.onboard._OnboardDelegate;
import in.gov.uidai.eca.ui.onboard._ValidationDelegate;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.notify.AlwaysOnTopOptionPane;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardControl
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnboardControl.class);
    private final _ValidationDelegate validDel = new _ValidationDelegate();
    private final _OnboardDelegate onboardDel = new _OnboardDelegate();
    private IOnScreenDisplay osd;
    private IResourceBundleContext rbCtxt;
    private IPreSyncPreference preSyncPref;
    private IOnboardingService onboardingService;
    private IRegistrationService registrationService;
    private EcmpApiService ecmpApiService;
    private PreSyncDelegate preSyncDelegate;

    public void setBioxDataProvider(IBioxDataProvider biox) {
        this.validDel.setBioxDataProvider(biox);
        this.onboardDel.setBioxDataProvider(biox);
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
        this.onboardDel.setResourceBundleContext(this.rbCtxt);
    }

    public void setPreSyncDelegate(PreSyncDelegate preSyncDelegate) {
        this.preSyncDelegate = preSyncDelegate;
    }

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardDel.setOnboardingAdminService(onboardingAdminService);
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
        this.onboardDel.setRegistrationService(registrationService);
    }

    public void setPreSyncPref(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        this.onboardDel.setOSD(osd);
        LOGGER.debug("on screen display set");
    }

    @EventHandler(name="hID_Ob_SectionSelect", method="actionPerformed")
    public void onboardSelect(ILiteEvent evt) {
        LOGGER.debug("onboard tab selected");
        this.osd.recompose(evt.getScaffoldId(), "onboardView");
        String viewId = this.osd.getScaffold(evt.getScaffoldId()).getViewId();
        ((IViewElement)this.osd.getView(viewId).getElementMap().get("eID_Ob_ListRefreshBut")).call("click");
    }

    @EventHandler(name="hID_Ob_TabSwitch", method="stateChanged")
    public void onTabSwitch(ILiteEvent evt) {
        boolean isSuspended;
        LOGGER.debug("handling tab switch");
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null || !view.isValid()) {
            return;
        }
        Map eMap = view.getElementMap();
        if (eMap == null || eMap.isEmpty()) {
            return;
        }
        UserTableData userData = this.getUserTableData(view);
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        ((IViewElement)eMap.get("eID_Ob_CapOnboardBut")).set("enable", (Object)true);
        if (userData != null && ((isSuspended = this.isSuspended(userData.getUid())) || this.isInactive(userData.getUserId()))) {
            ((IViewElement)eMap.get("eID_Ob_CapOnboardBut")).set("enable", (Object)false);
            String message = isSuspended ? "Cannot onboard the selected operator since the operator is suspended" : "Cannot onboard the selected operator since the operator is listed as Inactive";
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, message, this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 2, null, options, options[0]);
        }
        ((IViewElement)eMap.get("eID_Ob_CapLeftSlap")).call("stopCapture");
        ((IViewElement)eMap.get("eID_Ob_CapRightSlap")).call("stopCapture");
        ((IViewElement)eMap.get("eID_Ob_CapThumbSlap")).call("stopCapture");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @EventHandler(name="hID_Ob_CapOnboard", method="actionPerformed")
    public void onboardUser(ILiteEvent evt) {
        ILiteView view;
        List opList;
        block21: {
            IVisualExecutionContext veCtxt;
            block20: {
                UserTableData userData;
                Window win;
                block19: {
                    block17: {
                        block18: {
                            LOGGER.debug("onboarding");
                            opList = null;
                            boolean signVerification = false;
                            try {
                                signVerification = new JarIntegrityCheck().verifyJar(ApplicationVersion.VERSION);
                            }
                            catch (Exception e) {
                                LOGGER.error("unable to verify jar integrity for the application", (Throwable)e);
                            }
                            if (!signVerification) {
                                AlwaysOnTopOptionPane.create().messageType(1).optionType(-1).message("The application is invalid as one or more jar files seems to be tampered.Cannot proceed.Please re install the application.").title("Aadhaar").winIcon("res/images/frame_icon.png").show();
                                System.exit(0);
                            }
                            view = this.osd.getView(evt.getViewId());
                            win = this.osd.getWindowForScaffold(evt.getScaffoldId());
                            userData = null;
                            if (!this.validDel.validateUserSelection(view)) {
                                Object[] options = new Object[]{"Ok"};
                                JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)"msg-stat:onboard.nouser", new Object[0]), this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 0, null, options, options[0]);
                                return;
                            }
                            if (!this.validDel.validateFingerprint(view) || !this.validDel.validateIris(view)) {
                                Object[] options = new Object[]{"Ok"};
                                JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)"msg-stat:onboard.add.nobio", new Object[0]), this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 0, null, options, options[0]);
                                return;
                            }
                            veCtxt = view.getVisualExecutionContext();
                            if (veCtxt != null) {
                                veCtxt.reset();
                                veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_ONBOARD, new Object[0]));
                            }
                            opList = this.onboardingService.getAllOnboardedUsers();
                            userData = this.getUserTableData(view);
                            UserCredentials cred = new UserCredentials();
                            cred.setOperatorId(userData.getUserId());
                            cred.setUid(userData.getUid());
                            cred.setOnboard(false);
                            opList.add(cred);
                            if (!"Operator".equalsIgnoreCase(userData.getUserType()) && !"Supervisor".equalsIgnoreCase(userData.getUserType())) break block17;
                            if (null != userData.getEacode()) break block18;
                            Object[] options = new Object[]{"Ok"};
                            JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_LATEST_FILE, new Object[0]), this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 0, null, options, options[0]);
                            veCtxt.cancel();
                            return;
                        }
                        if (this.registrationService.getAgencyId().equalsIgnoreCase(userData.getEacode())) break block17;
                        Object[] options = new Object[]{"Ok"};
                        JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_CORRECT_FILE, new Object[0]), this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 0, null, options, options[0]);
                        veCtxt.cancel();
                        return;
                    }
                    PreSyncRequest preSyncRequest = this.preSyncDelegate.prepareServiceRequest(userData.getUserId(), opList, false);
                    PreSyncResponse preSyncResponse = this.ecmpApiService.preSyncClient(preSyncRequest);
                    this.preSyncDelegate.storeOperatorDetails(preSyncResponse);
                    CIDRStatus preSyncStatus = this.preSyncDelegate.processServiceResponse((Object)preSyncResponse);
                    if (preSyncStatus == CIDRStatus.SUCCESS) break block19;
                    Object[] options = new Object[]{"Ok"};
                    JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_INTERNAL, new Object[]{userData.getFullName()}), this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 0, null, options, options[0]);
                    veCtxt.cancel();
                    return;
                }
                boolean isSuspended = this.isSuspended(userData.getUid());
                if (!isSuspended) break block20;
                Object[] options = new Object[]{"Ok"};
                JOptionPane.showOptionDialog(win, "Cannot onboard the selected operator since the operator is suspended", this.rbCtxt.getMessage((Object)"msg-stat:msg.title", new Object[0]), -1, 2, null, options, options[0]);
                veCtxt.cancel();
                return;
            }
            try {
                break block21;
                catch (StationInfoStoreException e) {
                    LOGGER.error("PreSync with Server failed.Unable to store station settings via Enrolment Service Client", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to communicate with Enrolment Service Client. Please ensure that enrolment service client is running.", (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("PreSync with Server failed", (Throwable)e);
                }
            }
            finally {
                veCtxt.cancel();
            }
        }
        if (this.onboardDel.onboardUser(evt.getViewId(), opList)) {
            LOGGER.info("Operator onboarded successfully.");
            IViewElement tabPane = (IViewElement)view.getElementMap().get("eID_Ob_TabPane");
            tabPane.set("selected-index", (Object)0);
            ((IViewElement)view.getElementMap().get("eID_Ob_ListRefreshBut")).call("click");
        }
    }

    private boolean isSuspended(String uid) {
        List<String> uidList;
        String[] suspended = this.preSyncPref.getSuspendedOperatorIDs();
        return suspended != null && (uidList = Arrays.asList(suspended)).contains(uid);
    }

    private boolean isInactive(String userId) {
        List inactiveOpList = null;
        inactiveOpList = InActiveOperators.getInActiveOperatorList((String[])this.preSyncPref.getInactiveOperatorList(), (String)";");
        InActiveOperator op = new InActiveOperator();
        op.setUserCode(userId);
        return inactiveOpList.contains(op);
    }

    private UserTableData getUserTableData(ILiteView view) {
        Map eMap = view.getElementMap();
        List selectedRows = (List)((IViewElement)eMap.get("eID_Ob_ListUserTable")).get("selectedRows");
        if (selectedRows.size() > 0) {
            List userTableDataList = (List)view.getExtraDataMap().get("eID_Ob_ListUserTable");
            UserTableData userTableData = (UserTableData)userTableDataList.get((Integer)selectedRows.get(0));
            return userTableData;
        }
        return null;
    }
}

