/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.onboarding.IIntroducerDetailsDAO;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.IntroducerDetails;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureProcessor;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.ui.msg.MsgKeysCommon;
import in.gov.uidai.eca.ui.msg.MsgKeysOnboard;
import in.gov.uidai.eca.ui.onboard.UserTableData;
import in.gov.uidai.eca.ui.onboard._LazyUserDataLoader;
import in.gov.uidai.eca.ui.onboard._OnboardDelegate;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.Window;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnboardListControl
implements IOnScreenDisplayAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnboardListControl.class);
    private static final BiometricPosition[] ALLPOS = new BiometricPosition[]{BiometricPosition.LEFT_INDEX, BiometricPosition.LEFT_MIDDLE, BiometricPosition.LEFT_RING, BiometricPosition.LEFT_LITTLE, BiometricPosition.LEFT_THUMB, BiometricPosition.RIGHT_INDEX, BiometricPosition.RIGHT_MIDDLE, BiometricPosition.RIGHT_RING, BiometricPosition.RIGHT_LITTLE, BiometricPosition.RIGHT_THUMB};
    private IOnScreenDisplay osd;
    private IIntroducerDetailsDAO introDAO;
    private IResourceBundleContext rbCtxt;
    private _OnboardDelegate onboardDelegate = new _OnboardDelegate();
    private IRegistrationService registrationService;
    private IOnboardingService onboardingService;
    private DisclosureProcessor disclosureProcessor;
    private DisclosureInfoData disclosureInfoData;
    private ILiteScaffold mainWin;

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
        this.onboardDelegate.setRegistrationService(registrationService);
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardDelegate.setOnboardingAdminService(onboardingAdminService);
    }

    public void setIntroducerDetailsDAO(IIntroducerDetailsDAO dao) {
        this.introDAO = dao;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
        this.onboardDelegate.setResourceBundleContext(this.rbCtxt);
    }

    public void setDisclosureProcessor(DisclosureProcessor disclosureProcessor) {
        this.disclosureProcessor = disclosureProcessor;
    }

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        this.onboardDelegate.setOSD(osd);
        LOGGER.debug("on screen display set");
    }

    @EventHandler(name="hID_Ob_ListRefresh", method="actionPerformed")
    public void onListRefresh(ILiteEvent evt) {
        LOGGER.debug("refresh user list");
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null) {
            return;
        }
        Map eMap = view.getElementMap();
        _LazyUserDataLoader ludl = new _LazyUserDataLoader();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Loading list of operators, supervisors and introducers");
        }
        ArrayList<UserTableData> utdList = new ArrayList<UserTableData>();
        String queryStr = (String)((IViewElement)eMap.get("eID_Ob_ListQueryStr")).get("text");
        boolean allOpt = (Boolean)((IViewElement)eMap.get("eID_Ob_ListOptAll")).get("isSelected");
        boolean opOpt = (Boolean)((IViewElement)eMap.get("eID_Ob_ListOptOp")).get("isSelected");
        boolean supOpt = (Boolean)((IViewElement)eMap.get("eID_Ob_ListOptSup")).get("isSelected");
        boolean introOpt = (Boolean)((IViewElement)eMap.get("eID_Ob_ListOptIntro")).get("isSelected");
        if (allOpt) {
            List userList = this.onboardingService.getAllUsers();
            this.loadUserTableData(ludl, userList, utdList);
        } else if (opOpt) {
            List userList = this.onboardingService.getAllOperators();
            this.loadUserTableData(ludl, userList, utdList);
        } else if (supOpt) {
            List userList = this.onboardingService.getAllSupervisors();
            this.loadUserTableData(ludl, userList, utdList);
        } else if (introOpt) {
            List introList = this.introDAO.getAllIntroducers();
            this.loadIntroducers(ludl, introList, utdList);
        }
        if (StringUtils.isNotBlank((String)queryStr)) {
            utdList = this.filterByQueryStr(queryStr, utdList);
        }
        ((IViewElement)eMap.get("eID_Ob_ListUserTable")).set("value", utdList);
        view.getExtraDataMap().put("eID_Ob_ListUserTable", utdList);
        if (veCtxt != null) {
            veCtxt.cancel();
        }
    }

    @EventHandler(name="hID_Ob_ListSelChange", method="valueChanged")
    public void onUserListSelectionChanged(ILiteEvent evt) {
        if (this.registrationService.isDeregistrationPrerequisitesInProgress() || this.registrationService.isDeregistrationPrerequisitesCompleted() || this.registrationService.isDeregistered()) {
            return;
        }
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        this.refreshSelection(view, eMap);
    }

    @EventHandler(name="hID_Ob_ListUnboard", method="actionPerformed")
    public void onListUnboard(ILiteEvent evt) {
        Window msgPeer = this.osd.getWindowForScaffold(evt.getScaffoldId());
        this.disclosureProcessor.readingFromDisclosureDatFile();
        this.disclosureInfoData = this.disclosureProcessor.getDisclosureInfoData();
        Map res = this.disclosureInfoData.getDisclosedData();
        boolean flag = false;
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        UserTableData utd = null;
        List selectedRow = (List)((IViewElement)eMap.get("eID_Ob_ListUserTable")).get("selectedRows");
        if (selectedRow.size() > 0) {
            List utdList = (List)view.getExtraDataMap().get("eID_Ob_ListUserTable");
            utd = (UserTableData)utdList.get((Integer)selectedRow.get(0));
        }
        if (res.containsKey(utd.getUserId()) && !((String)res.get(utd.getUserId())).equals(LocalDate.now().toString())) {
            String scafId = this.osd.compose("DisclosurePopupAtUnboardingWin", "DisclosurePopupAtUnboardingView");
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        } else {
            int choice = JOptionPane.showConfirmDialog(msgPeer, this.rbCtxt.getMessage((Object)MsgKeysOnboard.CONFIRM_REMOVE, new Object[0]), this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), 0);
            if (choice != 0) {
                return;
            }
            if (!this.onboardDelegate.unboardUser(evt.getViewId())) {
                Object[] options = new Object[]{"Ok"};
                JOptionPane.showOptionDialog(msgPeer, this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_REMOVE, new Object[0]), this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), -1, 0, null, options, options[0]);
            } else {
                Object[] options = new Object[]{"Ok"};
                JOptionPane.showOptionDialog(msgPeer, this.rbCtxt.getMessage((Object)MsgKeysOnboard.SUCCESS_REMOVE, new Object[0]), this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), -1, 1, null, options, options[0]);
            }
            this.onListRefresh(evt);
        }
    }

    private void refreshSelection(ILiteView view, Map<String, IViewElement> eMap) {
        eMap.get("eID_Ob_ListDeleteBut").set("enable", (Object)false);
        eMap.get("eID_Ob_ListNextBut").set("enable", (Object)false);
        eMap.get("eID_Ob_ListLeftHand").call("reset");
        eMap.get("eID_Ob_ListRightHand").call("reset");
        eMap.get("eID_Ob_BioxLeftHand").call("reset");
        eMap.get("eID_Ob_BioxRightHand").call("reset");
        eMap.get("eID_Ob_CapLeftSlap").call("clear");
        eMap.get("eID_Ob_CapRightSlap").call("clear");
        eMap.get("eID_Ob_CapThumbSlap").call("clear");
        eMap.get("eID_Ob_IrisTab_BothEyes").call("clear");
        eMap.get("eID_Ob_TabPane").set("enable", (Object)false);
        UserTableData utd = null;
        List selectedRows = (List)eMap.get("eID_Ob_ListUserTable").get("selectedRows");
        if (!selectedRows.isEmpty()) {
            List utdList = (List)view.getExtraDataMap().get("eID_Ob_ListUserTable");
            utd = (UserTableData)utdList.get((Integer)selectedRows.get(0));
        }
        if (utd != null) {
            String enrolstatus = utd.getOnboardStatus();
            if (utd.isNotBoarded()) {
                eMap.get("eID_Ob_ListDeleteBut").set("enable", (Object)false);
                eMap.get("eID_Ob_ListNextBut").set("enable", (Object)true);
                eMap.get("eID_Ob_TabPane").set("enable", (Object)true);
            } else {
                eMap.get("eID_Ob_ListDeleteBut").set("enable", (Object)true);
                eMap.get("eID_Ob_ListNextBut").set("enable", (Object)false);
                eMap.get("eID_Ob_TabPane").set("enable", (Object)false);
            }
            ArrayList<BiometricPosition> missingPos = new ArrayList<BiometricPosition>();
            missingPos.addAll(Arrays.asList(ALLPOS));
            RegistrationResult rrs = utd.getRegistrationResult();
            if (rrs != null && enrolstatus.equalsIgnoreCase("Enrolled")) {
                missingPos.removeAll(rrs.getAllPositions());
                eMap.get("eID_Ob_ListLeftHand").set("missing", missingPos);
                eMap.get("eID_Ob_ListRightHand").set("missing", missingPos);
                List verifiedPos = rrs.getVerifiedPositions();
                eMap.get("eID_Ob_ListLeftHand").set("authenticated", (Object)verifiedPos);
                eMap.get("eID_Ob_ListRightHand").set("authenticated", (Object)verifiedPos);
            }
        }
    }

    private void loadUserTableData(_LazyUserDataLoader ludl, List<UserCredentials> usersList, List<UserTableData> utdList) {
        for (UserCredentials userCr : usersList) {
            UserTableData utd = new UserTableData(ludl);
            utd.setFullName(userCr.getFullName());
            utd.setUserId(userCr.getOperatorId());
            utd.setUid(userCr.getUid());
            utd.setEacode(userCr.getEacode());
            utd.setUserType(userCr.getType() == 0 ? "Operator" : "Supervisor");
            utdList.add(utd);
        }
    }

    private void loadIntroducers(_LazyUserDataLoader ludl, List<IntroducerDetails> introList, List<UserTableData> utdList) {
        for (IntroducerDetails intro : introList) {
            UserTableData utd = new UserTableData(ludl);
            utd.setFullName(intro.getFullName());
            utd.setUid(intro.getIntroducerId());
            utd.setUserType("Introducer");
            utdList.add(utd);
        }
    }

    private ArrayList<UserTableData> filterByQueryStr(String queryStr, ArrayList<UserTableData> utdList) {
        String[] parts = queryStr.split("[\\s\\p{Punct}]");
        ArrayList<UserTableData> result = new ArrayList<UserTableData>(utdList);
        for (UserTableData utd : utdList) {
            boolean match = false;
            for (String part : parts) {
                if (StringUtils.containsIgnoreCase((String)utd.getFullName(), (String)part)) {
                    match = true;
                    break;
                }
                if (StringUtils.containsIgnoreCase((String)utd.getUserId(), (String)part)) {
                    match = true;
                    break;
                }
                if (!StringUtils.containsIgnoreCase((String)utd.getUid(), (String)part)) continue;
                match = true;
                break;
            }
            if (match) continue;
            result.remove(utd);
        }
        return result;
    }
}

