/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.eca.ui.onboard._LazyUserDataLoader;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.lvs.model.RegistrationResult;
import org.apache.commons.lang.StringUtils;

public class UserTableData {
    private String uid;
    private String userId;
    private String fullName;
    private String userType;
    private OnBoardingStatus obStat;
    private String statStr;
    private RegistrationResult regres;
    private _LazyUserDataLoader loader;
    protected String eacode;

    public UserTableData(_LazyUserDataLoader ludl) {
        this.loader = ludl;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String id) {
        this.uid = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        this.fullName = name;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String type) {
        this.userType = type;
    }

    public String getOnboardStatus() {
        if (StringUtils.isNotBlank((String)this.statStr)) {
            return this.statStr;
        }
        this.loader.updateLvsData(this);
        return this.statStr;
    }

    public void setOnboardStatus(OnBoardingStatus status) {
        this.obStat = status;
        if (this.obStat == null) {
            this.statStr = "";
        } else {
            switch (status) {
                case NOT_BOARDED: {
                    this.statStr = "Not Enrolled";
                    break;
                }
                case PARTIALLY_BOARDED: {
                    this.statStr = "Partially Enrolled";
                    break;
                }
                case ONBOARD: {
                    this.statStr = "Enrolled";
                }
            }
        }
    }

    public boolean isNotBoarded() {
        if (this.obStat == null) {
            return true;
        }
        return this.obStat.equals((Object)OnBoardingStatus.NOT_BOARDED);
    }

    public RegistrationResult getRegistrationResult() {
        return this.regres;
    }

    public void setRegistrationResult(RegistrationResult rrs) {
        this.regres = rrs;
    }

    public String getEacode() {
        return this.eacode;
    }

    public void setEacode(String eacode) {
        this.eacode = eacode;
    }
}

