/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.eca.ui.onboard.UserTableData;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.lvs.model.RegistrationResult;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _LazyUserDataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(_LazyUserDataLoader.class);
    private ILocalVerificationService lvs = null;

    public _LazyUserDataLoader() {
        try {
            this.lvs = LVSLocator.instance();
        }
        catch (Exception exep) {
            LOGGER.error("unable to locate lvs", (Throwable)exep);
            return;
        }
    }

    public boolean updateLvsData(UserTableData utd) {
        boolean result = true;
        OnBoardingStatus status = OnBoardingStatus.NOT_BOARDED;
        RegistrationResult rrs = null;
        try {
            status = this.lvs.getStatus(utd.getUid());
            status = status == null ? OnBoardingStatus.NOT_BOARDED : status;
            rrs = this.lvs.getRegistrationResult(utd.getUid());
        }
        catch (Exception exep) {
            LOGGER.error("while loading lvs data", (Throwable)exep);
            status = OnBoardingStatus.NOT_BOARDED;
            result = false;
        }
        utd.setRegistrationResult(rrs);
        utd.setOnboardStatus(status);
        return result;
    }
}

