/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.ec.service.onboarding.OnboardingStatus;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.eca.ui.msg.MsgKeysCommon;
import in.gov.uidai.eca.ui.msg.MsgKeysOnboard;
import in.gov.uidai.eca.ui.onboard.IOnboardConstants;
import in.gov.uidai.eca.ui.onboard.UserTableData;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _OnboardDelegate
implements IOnboardConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(_OnboardDelegate.class);
    private IOnScreenDisplay osd;
    private IBioxDataProvider biox;
    private IResourceBundleContext rbCtxt;
    private IRegistrationService registrationService;
    private IOnboardingAdminService onboardingAdminService;
    private byte[] leftEyeImageByte;
    private byte[] rightEyeImageByte;

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardingAdminService = onboardingAdminService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOSD(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setBioxDataProvider(IBioxDataProvider biox) {
        this.biox = biox;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean onboardUser(String viewId, List<UserCredentials> opList) {
        view = this.osd.getView(viewId);
        win = this.osd.getWindowForScaffold(viewId);
        if (this.biox.getAvailableFingers().size() < 2) {
            options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)MsgKeysOnboard.MIN_FINGERS, new Object[0]), this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), -1, 0, null, options, options[0]);
            return false;
        }
        veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_ONBOARD, new Object[0]));
        }
        utd = this.getUserTableData(view);
        message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_INTERNAL, new Object[]{utd.getFullName()});
        onBoardStatus = false;
        errorFlag = true;
        try {
            eMap = view.getElementMap();
            utd1 = this.getUserTableData(view);
            veCtxt1 = view.getVisualExecutionContext();
            if (veCtxt1 != null) {
                veCtxt1.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_TPL_LEFT, new Object[0]));
            }
            leftTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapLeftSlap"), BiometricPosition.LEFT_SLAP, false);
            leftIsoTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapLeftSlap"), BiometricPosition.LEFT_SLAP, true);
            if (veCtxt1 != null) {
                veCtxt1.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_TPL_RIGHT, new Object[0]));
            }
            rightTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapRightSlap"), BiometricPosition.RIGHT_SLAP, false);
            rightIsoTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapRightSlap"), BiometricPosition.RIGHT_SLAP, true);
            if (veCtxt1 != null) {
                veCtxt1.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_TPL_THUMBS, new Object[0]));
            }
            thumbTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapThumbSlap"), BiometricPosition.BOTH_THUMBS, false);
            thumbIsoTemplates = this.getTemplates((IViewElement)eMap.get("eID_Ob_CapThumbSlap"), BiometricPosition.BOTH_THUMBS, true);
            if (veCtxt1 != null) {
                veCtxt1.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_TPL_IRIS, new Object[0]));
            }
            bothIrisTemplates = this.getIrisTemplates((IViewElement)eMap.get("eID_Ob_IrisTab_BothEyes"), false);
            bothIrisIsoTemplates = this.getIrisTemplates((IViewElement)eMap.get("eID_Ob_IrisTab_BothEyes"), true);
            biometricTemplates = this.mergeTemplates(leftTemplates, rightTemplates, thumbTemplates, bothIrisTemplates);
            isoTemplates = this.mergeTemplates(leftIsoTemplates, rightIsoTemplates, thumbIsoTemplates, bothIrisIsoTemplates);
            if (veCtxt1 != null) {
                veCtxt1.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_ONBOARD_IN_PROGRESS, new Object[0]));
            }
            try {
                lvs = LVSLocator.instance();
                lvs.setClientInformation(this.registrationService.getRegistrarId(), this.registrationService.getAgencyId(), this.registrationService.getStationId(), this.registrationService.getRegisteredMachineCode(), this.registrationService.getApplicationFullVersion());
                onboardingStatus = this.onboardingAdminService.onboardUser(utd1.getUid(), utd1.getUserId(), utd1.getUserType(), biometricTemplates, isoTemplates, opList, lvs);
            }
            catch (StationInfoStoreException | IOException e) {
                onboardingStatus = OnboardingStatus.UNABLE_TO_CONNECT_TO_OUC;
                _OnboardDelegate.LOGGER.error("unable to store checksum details to checksum.json via Enrolment Service Client", e);
            }
            catch (Exception e) {
                onboardingStatus = OnboardingStatus.LVS_CONNECTTION_FAILURE;
                _OnboardDelegate.LOGGER.error("unable to connect with lvs", (Throwable)e);
            }
            switch (1.$SwitchMap$in$gov$uidai$ec$service$onboarding$OnboardingStatus[onboardingStatus.ordinal()]) {
                case 1: {
                    _OnboardDelegate.LOGGER.info("Pre sync and on boarding success.");
                    errorFlag = false;
                    onBoardStatus = true;
                    ** break;
lbl58:
                    // 1 sources

                    break;
                }
                case 2: {
                    var25_30 = false;
                    return var25_30;
                }
                case 3: {
                    _OnboardDelegate.LOGGER.error("Pre sync failed after on boarding.");
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_PRESYNC, new Object[]{utd.getFullName()});
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 4: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_AUTH_PARTIAL, new Object[]{utd.getFullName()});
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 5: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_AUTH, new Object[]{utd.getFullName()});
                    ** break;
lbl74:
                    // 1 sources

                    break;
                }
                case 6: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_DUP_USER, new Object[]{utd.getFullName()});
                    ** break;
lbl78:
                    // 1 sources

                    break;
                }
                case 7: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_INTERNAL, new Object[]{utd.getFullName()});
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 8: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_DUP_BIO, new Object[]{utd.getFullName()});
                    ** break;
lbl86:
                    // 1 sources

                    break;
                }
                case 9: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_SEGMENT, new Object[]{utd.getFullName()});
                    ** break;
lbl90:
                    // 1 sources

                    break;
                }
                case 10: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_NOUSER, new Object[]{utd.getFullName()});
                    ** break;
lbl94:
                    // 1 sources

                    break;
                }
                case 11: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_OUC_NOT_ONLINE, new Object[]{utd.getFullName()});
                    ** break;
lbl98:
                    // 1 sources

                    break;
                }
                default: {
                    message = this.rbCtxt.getMessage((Object)MsgKeysOnboard.ERROR_INTERNAL, new Object[]{utd.getFullName()});
                    break;
                }
            }
        }
        catch (Exception e) {
            _OnboardDelegate.LOGGER.error(e.getMessage(), (Throwable)e);
            errorFlag = true;
        }
        finally {
            veCtxt.cancel();
        }
        if (errorFlag) {
            options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, message, this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), -1, 0, null, options, options[0]);
        } else {
            options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(win, this.rbCtxt.getMessage((Object)MsgKeysOnboard.SUCCESS, new Object[]{utd.getFullName()}), this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0]), -1, 1, null, options, options[0]);
        }
        return onBoardStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unboardUser(String viewId) {
        LOGGER.debug("unboarding user from list");
        ILiteView view = this.osd.getView(viewId);
        if (view == null) {
            return false;
        }
        Map eMap = view.getElementMap();
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysOnboard.VEX_REMOVE, new Object[0]));
        }
        try {
            UserTableData utd = null;
            List selectedRows = (List)((IViewElement)eMap.get("eID_Ob_ListUserTable")).get("selectedRows");
            if (selectedRows.size() > 0) {
                List utdList = (List)view.getExtraDataMap().get("eID_Ob_ListUserTable");
                utd = (UserTableData)utdList.get((Integer)selectedRows.get(0));
            }
            boolean bl = this.onboardingAdminService.unboardUser(utd.getUid());
            return bl;
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }

    private ArrayList<BiometricTemplate> mergeTemplates(List<BiometricTemplate> leftTemplates, List<BiometricTemplate> rightTemplates, List<BiometricTemplate> thumbTemplates, List<BiometricTemplate> bothIrisTemplates) {
        ArrayList<BiometricTemplate> biometricTemplates = new ArrayList<BiometricTemplate>();
        biometricTemplates.addAll(leftTemplates);
        biometricTemplates.addAll(rightTemplates);
        biometricTemplates.addAll(thumbTemplates);
        biometricTemplates.addAll(bothIrisTemplates);
        return biometricTemplates;
    }

    private List<BiometricTemplate> getTemplates(IViewElement bioField, BiometricPosition biopos, boolean iso) {
        List<Object> tplList = new ArrayList<BiometricTemplate>();
        CaptureAttempt attempt = (CaptureAttempt)bioField.get("currentAttempt");
        if (attempt == null) {
            return tplList;
        }
        ArrayList<BiometricPosition> missingFingers = this.biox.getMissingFingers();
        missingFingers = this.filterMissingFingers(biopos, (List<BiometricPosition>)missingFingers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("missing fingers for " + biopos + ": " + missingFingers);
        }
        tplList = Qssitv.getInst().getFingerTemplate(attempt.getImage().getOriginalData(), missingFingers, 0, iso);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("extraction returned --");
            for (BiometricTemplate biometricTemplate : tplList) {
                LOGGER.debug(biometricTemplate.getBiometricPosition() + ", probe length: " + biometricTemplate.getProbeTemplate().length + ", gallery length: " + biometricTemplate.getGalleryTemplate().length);
            }
        }
        return tplList;
    }

    private ArrayList<BiometricPosition> filterMissingFingers(BiometricPosition bpos, List<BiometricPosition> missingList) {
        ArrayList<BiometricPosition> list;
        block4: {
            block5: {
                block3: {
                    list = new ArrayList<BiometricPosition>();
                    if (bpos != BiometricPosition.LEFT_SLAP) break block3;
                    for (BiometricPosition bp : missingList) {
                        if (!bp.toString().startsWith("Left") || bp.equals((Object)BiometricPosition.LEFT_THUMB)) continue;
                        list.add(bp);
                    }
                    break block4;
                }
                if (bpos != BiometricPosition.RIGHT_SLAP) break block5;
                for (BiometricPosition bp : missingList) {
                    if (!bp.toString().startsWith("Right") || bp.equals((Object)BiometricPosition.RIGHT_THUMB)) continue;
                    list.add(bp);
                }
                break block4;
            }
            if (bpos != BiometricPosition.BOTH_THUMBS) break block4;
            for (BiometricPosition bp : missingList) {
                if (!bp.equals((Object)BiometricPosition.LEFT_THUMB) && !bp.equals((Object)BiometricPosition.RIGHT_THUMB)) continue;
                list.add(bp);
            }
        }
        return list;
    }

    private UserTableData getUserTableData(ILiteView view) {
        Map eMap = view.getElementMap();
        List selectedRows = (List)((IViewElement)eMap.get("eID_Ob_ListUserTable")).get("selectedRows");
        if (selectedRows.size() > 0) {
            List userTableDataList = (List)view.getExtraDataMap().get("eID_Ob_ListUserTable");
            UserTableData userTableData = (UserTableData)userTableDataList.get((Integer)selectedRows.get(0));
            return userTableData;
        }
        return null;
    }

    private List<BiometricTemplate> getIrisTemplates(IViewElement bioField, boolean iso) {
        ArrayList<BiometricTemplate> tplList = new ArrayList<BiometricTemplate>();
        Map attemptMap = (Map)bioField.get("currentAttemptMultiPos");
        ArrayList<CaptureAttempt> allAttempts = new ArrayList<CaptureAttempt>();
        CaptureAttempt at = (CaptureAttempt)attemptMap.get(BiometricPosition.RIGHT_IRIS);
        CaptureAttempt at1 = (CaptureAttempt)attemptMap.get(BiometricPosition.LEFT_IRIS);
        allAttempts.add(at);
        allAttempts.add(at1);
        for (CaptureAttempt captureAttempt : allAttempts) {
            if (((BiometricTemplate)captureAttempt.getTemplates().get(0)).getBiometricPosition().toString().equals(BiometricPosition.LEFT_IRIS.toString()) && iso) {
                this.leftEyeImageByte = captureAttempt.getImage().getOriginalData();
                ((BiometricTemplate)Qssitv.getInst().getIrisTemplate(captureAttempt.getImage().getOriginalData(), iso).get(0)).getProbeTemplate();
            } else if (((BiometricTemplate)captureAttempt.getTemplates().get(0)).getBiometricPosition().toString().equals(BiometricPosition.RIGHT_IRIS.toString()) && iso) {
                this.rightEyeImageByte = captureAttempt.getImage().getOriginalData();
                ((BiometricTemplate)Qssitv.getInst().getIrisTemplate(captureAttempt.getImage().getOriginalData(), iso).get(0)).getProbeTemplate();
            }
            tplList.addAll(Qssitv.getInst().getIrisTemplate(captureAttempt.getImage().getOriginalData(), iso));
        }
        for (BiometricTemplate tpl : tplList) {
            LOGGER.debug(tpl.getBiometricPosition() + ", probe length: " + tpl.getProbeTemplate().length + ", gallery length: " + tpl.getGalleryTemplate().length);
            if (tpl.getBiometricPosition().toString().equals(BiometricPosition.LEFT_IRIS.toString()) && iso) {
                tpl.setProbeTemplate(this.leftEyeImageByte);
                continue;
            }
            if (!tpl.getBiometricPosition().toString().equals(BiometricPosition.RIGHT_IRIS.toString()) || !iso) continue;
            tpl.setProbeTemplate(this.rightEyeImageByte);
        }
        return tplList;
    }
}

