/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.onboard;

import in.gov.uidai.ec.biometrics.postcap.BioxDataAnalyzer;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IViewElement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _ValidationDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(_ValidationDelegate.class);
    private IBioxDataProvider bioxProvider;

    _ValidationDelegate() {
    }

    public void setBioxDataProvider(IBioxDataProvider biox) {
        this.bioxProvider = biox;
    }

    public boolean validateIris(ILiteView view) {
        LOGGER.debug("validating Iris biometrics");
        IViewElement bothEye = (IViewElement)view.getElementMap().get("eID_Ob_IrisTab_BothEyes");
        boolean status = true;
        if (BioxDataAnalyzer.hasBothIris((IBioxDataProvider)this.bioxProvider)) {
            bothEye.set("enable", (Object)true);
            status &= ((Boolean)bothEye.get("qualityPass")).booleanValue();
        } else {
            bothEye.set("enable", (Object)false);
        }
        return status;
    }

    public boolean validateFingerprint(ILiteView view) {
        LOGGER.debug("validating fingerprint biometrics");
        IViewElement leftSlap = (IViewElement)view.getElementMap().get("eID_Ob_CapLeftSlap");
        IViewElement rightSlap = (IViewElement)view.getElementMap().get("eID_Ob_CapRightSlap");
        IViewElement thumbSlap = (IViewElement)view.getElementMap().get("eID_Ob_CapThumbSlap");
        boolean status = true;
        if (BioxDataAnalyzer.hasLeftSlap((IBioxDataProvider)this.bioxProvider)) {
            leftSlap.set("enable", (Object)true);
            status = (Boolean)leftSlap.get("qualityPass");
        } else {
            leftSlap.set("enable", (Object)false);
        }
        if (BioxDataAnalyzer.hasRightSlap((IBioxDataProvider)this.bioxProvider)) {
            rightSlap.set("enable", (Object)true);
            status &= ((Boolean)rightSlap.get("qualityPass")).booleanValue();
        } else {
            rightSlap.set("enable", (Object)false);
        }
        if (BioxDataAnalyzer.hasBothThumbs((IBioxDataProvider)this.bioxProvider)) {
            thumbSlap.set("enable", (Object)true);
            status &= ((Boolean)thumbSlap.get("qualityPass")).booleanValue();
        } else {
            thumbSlap.set("enable", (Object)false);
        }
        return status;
    }

    public boolean validateUserSelection(ILiteView view) {
        Map eMap = view.getElementMap();
        List selectedRows = (List)((IViewElement)eMap.get("eID_Ob_ListUserTable")).get("selectedRows");
        return !selectedRows.isEmpty();
    }
}

