/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.prefedit;

import in.gov.uidai.ec.escapi.LocalisationInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.eca.ui.prefedit.IClientUIPreference;
import in.gov.uidai.eca.ui.prefedit.PrefEditViewPeer;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.widgets.ComboElement;
import in.gov.uidai.litef.widgets.LabelElement;
import in.gov.uidai.swing.combo.DropDownItem;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefEditControl
implements IOnScreenDisplayAware,
IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefEditControl.class);
    private static final Properties LOCALE_OPTIONS = new Properties();
    private static final String ENROL_LABELS_XTRN = "./conf/label-stat-xtrn.properties";
    private static final String TRANSLIT_LABELS_XTRN = "./conf/label-tlit-xtrn";
    private IOnScreenDisplay osd;
    private IClientUIPreference cuiPref;
    private IPreferenceStore prefStore;
    private IOucDataStore oucDataStore;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        LOGGER.debug("on screen display set");
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
        LOGGER.debug("preference store set");
    }

    public void setClientUIPreference(IClientUIPreference pref) {
        this.cuiPref = pref;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    @EventHandler(name="hID_PrefEdit_Select", method="actionPerformed")
    public void onPrefEditSelect(ILiteEvent evt) {
        LOGGER.debug("preferences edit tab selected");
        String scafId = this.osd.recompose(evt.getScaffoldId(), "prefEditView");
        String viewId = this.osd.getScaffold(scafId).getViewId();
        ILiteView view = this.osd.getView(viewId);
        Map eMap = view.getElementMap();
        ComboElement langSel = (ComboElement)eMap.get("eID_PrefEdit_LangSel");
        LabelElement langName = (LabelElement)eMap.get("eID_PrefEdit_LangName");
        ArrayList options = (ArrayList)langSel.get("options");
        LOGGER.debug("available locales: " + options);
        String currLocale = this.cuiPref.getTransliterationLocale("xxx");
        LOGGER.debug("current locale: " + currLocale);
        for (DropDownItem option : options) {
            if (!StringUtils.equalsIgnoreCase((String)currLocale, (String)option.getKey())) continue;
            langSel.set("selectedItem", (Object)option);
            langName.set("text", (Object)option.getValue());
            break;
        }
        boolean localizeFlag = this.cuiPref.getApplicationLocalize(false);
        ((IViewElement)eMap.get("eID_PrefEdit_Localize")).set("setSelected", (Object)localizeFlag);
        Properties enrolProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File(ENROL_LABELS_XTRN));
            enrolProps.load(fis);
            fis.close();
        }
        catch (Exception exep) {
            LOGGER.warn("xtrn field labels not loaded");
        }
        String houseLabel = enrolProps.getProperty("addr.house", "");
        String streetLabel = enrolProps.getProperty("addr.street", "");
        String landmarkLabel = enrolProps.getProperty("addr.landmark", "");
        String localityLabel = enrolProps.getProperty("addr.locality", "");
        ((IViewElement)eMap.get("eID_PrefEdit_House")).set("text", (Object)houseLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_Street")).set("text", (Object)streetLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_Landmark")).set("text", (Object)landmarkLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_Locality")).set("text", (Object)localityLabel);
        Properties translitProps = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File("./conf/label-tlit-xtrn_" + currLocale + ".properties"));
            translitProps.load(fis);
            fis.close();
        }
        catch (Exception exep) {
            LOGGER.warn("xtrn translit field labels not loaded" + exep.getMessage());
        }
        String locHouseLabel = translitProps.getProperty("addr.house", "");
        String locStreetLabel = translitProps.getProperty("addr.street", "");
        String locLandmarkLabel = translitProps.getProperty("addr.landmark", "");
        String locLocalityLabel = translitProps.getProperty("addr.locality", "");
        try {
            locHouseLabel = new String(locHouseLabel.getBytes("ISO-8859-1"), "UTF-8");
            locStreetLabel = new String(locStreetLabel.getBytes("ISO-8859-1"), "UTF-8");
            locLandmarkLabel = new String(locLandmarkLabel.getBytes("ISO-8859-1"), "UTF-8");
            locLocalityLabel = new String(locLocalityLabel.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException exep) {
            LOGGER.debug("unable to convert label to UTF8", (Throwable)exep);
        }
        ((IViewElement)eMap.get("eID_PrefEdit_LocHouse")).set("textDirect", (Object)locHouseLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_LocStreet")).set("textDirect", (Object)locStreetLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_LocLandmark")).set("textDirect", (Object)locLandmarkLabel);
        ((IViewElement)eMap.get("eID_PrefEdit_LocLocality")).set("textDirect", (Object)locLocalityLabel);
    }

    @EventHandler(name="hID_PrefEdit_LangSave", method="actionPerformed")
    public void onLocalLangSave(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        DropDownItem ddi = (DropDownItem)((IViewElement)eMap.get("eID_PrefEdit_LangSel")).get("selectedItem");
        String locale = ddi.getKey();
        if (StringUtils.isNotBlank((String)locale)) {
            this.cuiPref.setTransliterationLocale(locale);
            boolean localizeFlag = (Boolean)((IViewElement)eMap.get("eID_PrefEdit_Localize")).get("isSelected");
            this.cuiPref.setApplicationLocalize(localizeFlag);
            LocalisationInfo localisationInfo = new LocalisationInfo();
            localisationInfo.setLocalise(localizeFlag);
            localisationInfo.setLocale(locale);
            Object[] options = new Object[]{"Ok"};
            try {
                this.oucDataStore.setLocalisationInfo(localisationInfo);
                LOGGER.debug("transliteration locale set to" + locale);
                L10nOptionPaneBuilder.getInstance().showInfo((Object)"Locale updated successfully. Changes will be reflected the next time you start the enrolment client.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to connect to enrol service client", (Object[])e.getStackTrace());
                L10nOptionPaneBuilder.getInstance().showError((Object)"Locale could not be updated. Make sure OTA Update Client is running.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            }
            catch (StationInfoStoreException e) {
                LOGGER.error("Could not store localisation info to enrol service client", (Object[])e.getStackTrace());
                L10nOptionPaneBuilder.getInstance().showError((Object)"Locale could not be updated. Please try again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            }
        }
        ILiteScaffold scaffold = this.osd.getScaffoldForView(evt.getViewId());
        Map scafMap = scaffold.getElementMap();
        ((IViewElement)scafMap.get("mainWin.demoCustom")).call("click");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_PrefEdit_Save", method="actionPerformed")
    public void onDemoTabPrefSave(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        DropDownItem ddi = (DropDownItem)((IViewElement)eMap.get("eID_PrefEdit_LangSel")).get("selectedItem");
        String locale = ddi.getKey();
        if (StringUtils.isBlank((String)locale)) {
            LOGGER.error("locale cannot be blank");
            return;
        }
        String houseLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_House")).get("text");
        String streetLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_Street")).get("text");
        String landmarkLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_Landmark")).get("text");
        String localityLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_Locality")).get("text");
        Properties enrolProps = new Properties();
        try {
            if (StringUtils.isNotBlank((String)houseLabel)) {
                enrolProps.setProperty("addr.house", houseLabel);
            }
            if (StringUtils.isNotBlank((String)streetLabel)) {
                enrolProps.setProperty("addr.street", streetLabel);
            }
            if (StringUtils.isNotBlank((String)landmarkLabel)) {
                enrolProps.setProperty("addr.landmark", landmarkLabel);
            }
            if (StringUtils.isNotBlank((String)localityLabel)) {
                enrolProps.setProperty("addr.locality", localityLabel);
            }
            FileOutputStream fos = new FileOutputStream(new File(ENROL_LABELS_XTRN));
            enrolProps.store(fos, "");
            fos.flush();
            fos.close();
        }
        catch (Exception exep) {
            LOGGER.debug("xtrn field labels not saved", (Throwable)exep);
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()), "Internal error saving demographic form labels.", "Demographics Changes", -1, 0, null, options, options[0]);
            return;
        }
        String locHouseLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_LocHouse")).get("text");
        String locStreetLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_LocStreet")).get("text");
        String locLandmarkLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_LocLandmark")).get("text");
        String locLocalityLabel = (String)((IViewElement)eMap.get("eID_PrefEdit_LocLocality")).get("text");
        PrintWriter output = null;
        try {
            output = new PrintWriter(new File("./conf/label-tlit-xtrn_" + locale + ".properties"), "UTF-8");
            if (StringUtils.isNotBlank((String)locHouseLabel)) {
                output.append("addr.house=").append(locHouseLabel);
                output.println();
            }
            if (StringUtils.isNotBlank((String)locStreetLabel)) {
                output.append("addr.street=").append(locStreetLabel);
                output.println();
            }
            if (StringUtils.isNotBlank((String)locLandmarkLabel)) {
                output.append("addr.landmark=").append(locLandmarkLabel);
                output.println();
            }
            if (StringUtils.isNotBlank((String)locLocalityLabel)) {
                output.append("addr.locality=").append(locLocalityLabel);
                output.println();
            }
        }
        catch (Exception exep) {
            LOGGER.error("xtrn translit field labels not saved", (Throwable)exep);
            Object[] options = new Object[]{"Ok"};
            JOptionPane.showOptionDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()), "Internal error saving demographic form labels for transliteration fields.", "Demographics Changes", -1, 0, null, options, options[0]);
            return;
        }
        finally {
            if (output != null) {
                output.flush();
                output.close();
            }
        }
        Object[] options = new Object[]{"Ok"};
        JOptionPane.showOptionDialog(this.osd.getWindowForScaffold(evt.getScaffoldId()), "Changes updated successfully. These will be reflected the next time you start the enrolment client.", "Demographics Changes", -1, 1, null, options, options[0]);
    }

    static {
        ClassLoader cl = PrefEditViewPeer.class.getClassLoader();
        InputStream input = cl.getResourceAsStream("res/eca/local-languages.properties");
        try {
            LOCALE_OPTIONS.load(input);
            input.close();
        }
        catch (Exception exep) {
            LOGGER.error("unable to load locale options", (Throwable)exep);
        }
    }
}

