/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.security;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.util.ICmdLineEncryptionPreference;
import in.gov.uidai.ec.service.onboarding.IOnboardingAdminService;
import in.gov.uidai.eca.ui.msg.MsgKeysSecurity;
import in.gov.uidai.eca.ui.security.ISecurityConstants;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityControl
implements IOnScreenDisplayAware,
IEventContextAware,
IPreferenceStoreAware,
ISecurityConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityControl.class);
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private ICmdLineEncryptionPreference encPref;
    private IPreferenceStore prefStore;
    private IOnboardingAdminService onboardingAdminService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setEncryptionPref(ICmdLineEncryptionPreference pref) {
        this.encPref = pref;
    }

    public void setOnboardingAdminService(IOnboardingAdminService onboardingAdminService) {
        this.onboardingAdminService = onboardingAdminService;
    }

    @EventHandler(name="hID_Security_Section_Select", method="actionPerformed")
    public void onSecuritySelect(ILiteEvent evt) {
        LOGGER.debug("security tab selected");
        this.osd.recompose(evt.getScaffoldId(), "securityView");
        ILiteView view = this.osd.getView(this.osd.getScaffold(evt.getScaffoldId()).getViewId());
        view.setEnabled(false);
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_Security_Cli_Encrypt")).set("text", (Object)this.encPref.getEncryptionCommandLine());
        ((IViewElement)eMap.get("eID_Security_Cli_Decrypt")).set("text", (Object)this.encPref.getDecryptionCommandLine());
        view.setEnabled(true);
    }

    @EventHandler(name="hID_Security_Select_Cred", method="actionPerformed")
    public void onCredFileSelect(ILiteEvent evt) {
        LOGGER.debug("selecting user credentials file");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Security_Cred_FileName")).get("text");
        JFileChooser chooser = new JFileChooser(new File(fileName));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML (*.xml) Files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }
        });
        int returnVal = chooser.showOpenDialog(win);
        if (returnVal == 0) {
            ((IViewElement)eMap.get("eID_Security_Cred_FileName")).set("text", (Object)chooser.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Security_Import_Cred", method="actionPerformed")
    public void onCredFileImport(ILiteEvent evt) {
        LVSLocator lvsLocator;
        LOGGER.debug("importing user credentials file");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        String fileName = (String)((IViewElement)eMap.get("eID_Security_Cred_FileName")).get("text");
        LOGGER.debug("loading credentials from: " + fileName);
        if (StringUtils.isBlank((String)fileName)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_NONAME, (Component)win, new Object[0]);
            return;
        }
        File credFile = new File(fileName);
        if (!credFile.exists() || !credFile.isFile()) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_NOFILE, (Component)win, new Object[0]);
            return;
        }
        try {
            lvsLocator = new LVSLocator();
        }
        catch (Exception e) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_NOLVS, (Component)win, new Object[0]);
            return;
        }
        if (lvsLocator.get() == null) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_NOLVS, (Component)win, new Object[0]);
            return;
        }
        boolean verify = false;
        try {
            this.onboardingAdminService.load(credFile.toURI().toURL(), false);
            verify = true;
        }
        catch (Exception e) {
            LOGGER.error("during verify", (Throwable)e);
        }
        if (!verify) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_VERIFY, (Component)win, new Object[0]);
            return;
        }
        OutputStream fos = null;
        FileInputStream fis = null;
        try {
            int oneByte;
            fos = new FileOutputStream(new File("./data/userCredentials.xml"));
            fis = new FileInputStream(credFile);
            byte[] chunk = new byte[10248];
            while ((oneByte = fis.read()) >= 0) {
                ((FileOutputStream)fos).write(oneByte);
                int amt = fis.read(chunk);
                ((FileOutputStream)fos).write(chunk, 0, amt);
            }
        }
        catch (Exception exep) {
            LOGGER.error("saving user credentials", (Throwable)exep);
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysSecurity.CRED_IMPORT_SAVE, (Component)win, new Object[0]);
            return;
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                    fis.close();
                }
            }
            catch (Exception exep) {
                LOGGER.error("Error while closing the i/o streams ", (Throwable)exep);
            }
        }
        L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysSecurity.CRED_IMPORT_SUCCESS, (Component)win, new Object[0]);
        this.evtCtxt.fireGenericEvent("showClientSecurity", new Object[0]);
    }

    @EventHandler(name="hID_Security_Download_Cred", method="actionPerformed")
    public void onCredFileDownload(ILiteEvent evt) {
    }

    @EventHandler(name="hID_Security_Cli_Save", method="actionPerformed")
    public void onCliSave(ILiteEvent evt) {
        LOGGER.debug("saving cli for encryptor and decryptor");
        LOGGER.debug("scaffold is: " + evt.getScaffoldId());
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        String encryptCli = (String)((IViewElement)eMap.get("eID_Security_Cli_Encrypt")).get("text");
        String decryptCli = (String)((IViewElement)eMap.get("eID_Security_Cli_Decrypt")).get("text");
        this.encPref.setEncryptionCommandLine(encryptCli);
        this.encPref.setDecryptionCommandLine(decryptCli);
        this.prefStore.save();
        L10nOptionPaneBuilder.getInstance().showInfo((Object)MsgKeysSecurity.CLI_SUCCESS, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        this.evtCtxt.fireGenericEvent("showClientSecurity", new Object[0]);
    }
}

