/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.swing.bio;

import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class BioStatField
extends JComponent {
    private static final float[] DASH_INTERVALS = new float[]{4.0f, 2.0f};
    private static final ImageIcon BIOX_ICON;
    private static final ImageIcon AUTH_ICON;
    private final Map<String, Rectangle> hotSpotMap = new HashMap<String, Rectangle>();
    private final Map<String, Boolean> bioxMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> authMap = new HashMap<String, Boolean>();
    private ImageIcon bioPic;
    private String title;

    protected BioStatField() {
        this.setFont(FontManager.getInst().getScreenFont("broadside.ttf", 1, 14));
    }

    protected final void setBioPic(String path) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        if (cldr == null) {
            cldr = this.getClass().getClassLoader();
        }
        this.bioPic = new ImageIcon(cldr.getResource(path));
    }

    protected final void addHotSpot(String name, int x, int y, int width, int height) {
        Rectangle hotSpot = new Rectangle(x, y, width, height);
        this.hotSpotMap.put(name, hotSpot);
        this.bioxMap.put(name, false);
        this.authMap.put(name, false);
    }

    protected final void setBiox(String name) {
        this.bioxMap.put(name, true);
    }

    protected final void setAuth(String name) {
        this.authMap.put(name, true);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public final void reset() {
        Iterator<String> iter1 = this.bioxMap.keySet().iterator();
        while (iter1.hasNext()) {
            this.bioxMap.put(iter1.next(), false);
        }
        Iterator<String> iter2 = this.authMap.keySet().iterator();
        while (iter2.hasNext()) {
            this.authMap.put(iter2.next(), false);
        }
        this.repaint();
    }

    protected abstract void setMissing(List<BiometricPosition> var1);

    protected abstract void setAuthenticated(List<BiometricPosition> var1);

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bioPic == null) {
            return new Dimension(1, 1);
        }
        int titleHeight = 0;
        if (this.title != null && this.getFont() != null) {
            Font compFont = this.getFont();
            FontMetrics fm = this.getFontMetrics(compFont);
            titleHeight = fm.getHeight() + 5;
        }
        return new Dimension(this.bioPic.getIconWidth(), this.bioPic.getIconHeight() + titleHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font compFont;
        FontMetrics fm;
        int textWidth;
        if (this.bioPic == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, dim.width, dim.height);
        if (dim.height < this.bioPic.getIconHeight()) {
            return;
        }
        if (dim.width < this.bioPic.getIconWidth()) {
            return;
        }
        if (this.bioPic != null) {
            g.drawImage(this.bioPic.getImage(), 0, 0, this);
        }
        for (String key : this.hotSpotMap.keySet()) {
            int iy;
            int ix;
            Rectangle hotSpot = this.hotSpotMap.get(key);
            if (hotSpot == null) continue;
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, DASH_INTERVALS, 0.0f));
            g.setColor(Color.GRAY);
            g.drawRect(hotSpot.x, hotSpot.y, hotSpot.width, hotSpot.height);
            boolean bioxFlag = this.bioxMap.get(key);
            boolean authFlag = this.authMap.get(key);
            if (bioxFlag) {
                ix = hotSpot.x + (hotSpot.width / 2 - BIOX_ICON.getIconWidth() / 2);
                iy = hotSpot.y + (hotSpot.height / 2 - BIOX_ICON.getIconHeight() / 2);
                BIOX_ICON.paintIcon(this, g2, ix, iy);
            }
            if (!authFlag) continue;
            ix = hotSpot.x + (hotSpot.width / 2 - AUTH_ICON.getIconWidth() / 2);
            iy = hotSpot.y + (hotSpot.height / 2 - AUTH_ICON.getIconHeight() / 2);
            AUTH_ICON.paintIcon(this, g2, ix, iy);
        }
        if (this.title != null && this.getFont() != null && (textWidth = (fm = this.getFontMetrics(compFont = this.getFont())).stringWidth(this.title)) < this.getWidth()) {
            int posx = this.getWidth() / 2 - textWidth / 2;
            int posy = this.getHeight() - 5;
            g.setColor(Color.BLACK);
            g.setFont(compFont);
            g.drawString(this.title, posx, posy);
        }
    }

    static {
        ClassLoader cldr = BioStatField.class.getClassLoader();
        BIOX_ICON = new ImageIcon(cldr.getResource("res/eca/images/finger-missing.png"));
        AUTH_ICON = new ImageIcon(cldr.getResource("res/eca/images/finger-auth.png"));
    }
}

