/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.swing.bio;

import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class EcaBioxField
extends JComponent {
    private static final float[] DASH_INTERVALS = new float[]{4.0f, 2.0f};
    private static final ImageIcon OVL_ICON;
    private static final Cursor DEFAULT_CURSOR;
    private static final Cursor HAND_CURSOR;
    private final Map<String, Rectangle> hotSpotMap = new HashMap<String, Rectangle>();
    private final Map<String, Boolean> toggleMap = new HashMap<String, Boolean>();
    private ImageIcon bioPic;
    private String title;

    protected EcaBioxField() {
        MouseAdapter pointClickHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EcaBioxField.this.doMouseClicked(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                EcaBioxField.this.doMouseMoved(evt);
            }
        };
        this.addMouseListener(pointClickHandler);
        this.addMouseMotionListener(pointClickHandler);
        this.setFont(FontManager.getInst().getScreenFont("broadside.ttf", 1, 14));
    }

    protected final void setBioPic(String path) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        if (cldr == null) {
            cldr = this.getClass().getClassLoader();
        }
        this.bioPic = new ImageIcon(cldr.getResource(path));
    }

    protected final void addHotSpot(String name, int x, int y, int width, int height) {
        Rectangle hotSpot = new Rectangle(x, y, width, height);
        this.hotSpotMap.put(name, hotSpot);
        this.toggleMap.put(name, true);
    }

    protected final void toggleBioPresent(String name) {
        if (this.toggleMap.containsKey(name)) {
            this.toggleMap.put(name, this.toggleMap.get(name) == false);
        }
        this.repaint();
    }

    protected final boolean isBioPresent(String name) {
        if (this.toggleMap.containsKey(name)) {
            return this.toggleMap.get(name);
        }
        return false;
    }

    protected final void setBioPresent(String name, boolean flag) {
        this.toggleMap.put(name, flag);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public final void reset() {
        Iterator<String> iter = this.toggleMap.keySet().iterator();
        while (iter.hasNext()) {
            this.toggleMap.put(iter.next(), true);
        }
        this.repaint();
    }

    protected abstract List<BiometricPosition> available(List<BiometricPosition> var1);

    protected abstract List<BiometricPosition> missing(List<BiometricPosition> var1);

    protected abstract void setMissing(List<BiometricPosition> var1);

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bioPic == null) {
            return new Dimension(1, 1);
        }
        int titleHeight = 0;
        if (this.title != null && this.getFont() != null) {
            Font compFont = this.getFont();
            FontMetrics fm = this.getFontMetrics(compFont);
            titleHeight = fm.getHeight() + 5;
        }
        return new Dimension(this.bioPic.getIconWidth(), this.bioPic.getIconHeight() + titleHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font compFont;
        FontMetrics fm;
        int textWidth;
        if (this.bioPic == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, dim.width, dim.height);
        if (dim.height < this.bioPic.getIconHeight()) {
            return;
        }
        if (dim.width < this.bioPic.getIconWidth()) {
            return;
        }
        if (this.bioPic != null) {
            g.drawImage(this.bioPic.getImage(), 0, 0, this);
        }
        for (String key : this.hotSpotMap.keySet()) {
            Rectangle hotSpot = this.hotSpotMap.get(key);
            if (hotSpot == null) continue;
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, DASH_INTERVALS, 0.0f));
            g.setColor(Color.GRAY);
            g.drawRect(hotSpot.x, hotSpot.y, hotSpot.width, hotSpot.height);
            boolean flag = this.toggleMap.get(key);
            if (flag) continue;
            int ix = hotSpot.x + (hotSpot.width / 2 - OVL_ICON.getIconWidth() / 2);
            int iy = hotSpot.y + (hotSpot.height / 2 - OVL_ICON.getIconHeight() / 2);
            OVL_ICON.paintIcon(this, g2, ix, iy);
        }
        if (this.title != null && this.getFont() != null && (textWidth = (fm = this.getFontMetrics(compFont = this.getFont())).stringWidth(this.title)) < this.getWidth()) {
            int posx = this.getWidth() / 2 - textWidth / 2;
            int posy = this.getHeight() - 5;
            g.setColor(Color.BLACK);
            g.setFont(compFont);
            g.drawString(this.title, posx, posy);
        }
    }

    private void doMouseClicked(MouseEvent evt) {
        if (evt.isAltDown() || evt.isControlDown() || evt.isShiftDown() || evt.isMetaDown() || evt.isPopupTrigger()) {
            return;
        }
        if (evt.getButton() != 1) {
            return;
        }
        Point loc = evt.getPoint();
        for (String key : this.hotSpotMap.keySet()) {
            Rectangle hotSpot = this.hotSpotMap.get(key);
            if (hotSpot == null || !hotSpot.contains(loc)) continue;
            this.toggleMap.put(key, this.toggleMap.get(key) == false);
            break;
        }
        this.repaint();
    }

    private void doMouseMoved(MouseEvent evt) {
        Point loc = evt.getPoint();
        for (String key : this.hotSpotMap.keySet()) {
            Rectangle hotSpot = this.hotSpotMap.get(key);
            if (hotSpot == null || !hotSpot.contains(loc)) continue;
            this.setCursor(HAND_CURSOR);
            return;
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    static {
        ClassLoader cldr = EcaBioxField.class.getClassLoader();
        OVL_ICON = new ImageIcon(cldr.getResource("res/eca/images/finger-missing-large.png"));
        HAND_CURSOR = new Cursor(12);
        DEFAULT_CURSOR = new Cursor(0);
    }
}

