/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.swing.bio;

import in.gov.uidai.eca.ui.swing.bio.EcaBioxField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LeftHandField
extends EcaBioxField {
    private static final String FINGER_1 = "finger1";
    private static final String FINGER_2 = "finger2";
    private static final String FINGER_3 = "finger3";
    private static final String FINGER_4 = "finger4";
    private static final String THUMB = "thumb";

    public LeftHandField() {
        this.setTitle("Left Hand");
        this.setBioPic("res/eca/images/hand-left-big.png");
        this.addHotSpot(THUMB, 6, 160, 40, 40);
        this.addHotSpot(FINGER_1, 69, 34, 40, 40);
        this.addHotSpot(FINGER_2, 139, 8, 40, 40);
        this.addHotSpot(FINGER_3, 193, 26, 40, 40);
        this.addHotSpot(FINGER_4, 238, 78, 40, 40);
        this.enableEvents(8L);
        HierarchyListener hl = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                LeftHandField.this.createKeyboardBinding(LeftHandField.FINGER_1, "control F6");
                LeftHandField.this.createKeyboardBinding(LeftHandField.FINGER_2, "control F7");
                LeftHandField.this.createKeyboardBinding(LeftHandField.FINGER_3, "control F8");
                LeftHandField.this.createKeyboardBinding(LeftHandField.FINGER_4, "control F9");
                LeftHandField.this.createKeyboardBinding(LeftHandField.THUMB, "control F10");
            }
        };
        this.addHierarchyListener(hl);
    }

    @Override
    public List<BiometricPosition> available(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.LEFT_INDEX);
        }
        if (this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.LEFT_MIDDLE);
        }
        if (this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.LEFT_RING);
        }
        if (this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.LEFT_LITTLE);
        }
        if (this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.LEFT_THUMB);
        }
        return result;
    }

    @Override
    public List<BiometricPosition> missing(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (!this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.LEFT_INDEX);
        }
        if (!this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.LEFT_MIDDLE);
        }
        if (!this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.LEFT_RING);
        }
        if (!this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.LEFT_LITTLE);
        }
        if (!this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.LEFT_THUMB);
        }
        return result;
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        this.reset();
        if (posList.contains(BiometricPosition.LEFT_INDEX)) {
            this.setBioPresent(FINGER_1, false);
        }
        if (posList.contains(BiometricPosition.LEFT_MIDDLE)) {
            this.setBioPresent(FINGER_2, false);
        }
        if (posList.contains(BiometricPosition.LEFT_RING)) {
            this.setBioPresent(FINGER_3, false);
        }
        if (posList.contains(BiometricPosition.LEFT_LITTLE)) {
            this.setBioPresent(FINGER_4, false);
        }
        if (posList.contains(BiometricPosition.LEFT_THUMB)) {
            this.setBioPresent(THUMB, false);
        }
    }

    private void createKeyboardBinding(final String name, String shortcut) {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root == null) {
            return;
        }
        root.getInputMap().put(KeyStroke.getKeyStroke(shortcut), "left-" + name);
        AbstractAction axn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LeftHandField.this.toggleBioPresent(name);
            }
        };
        root.getActionMap().put("left-" + name, axn);
    }
}

