/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.eca.ui.swing.bio;

import in.gov.uidai.eca.ui.swing.bio.BioStatField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.List;

public class RightHandStatField
extends BioStatField {
    private static final String FINGER_1 = "finger1";
    private static final String FINGER_2 = "finger2";
    private static final String FINGER_3 = "finger3";
    private static final String FINGER_4 = "finger4";
    private static final String THUMB = "thumb";

    public RightHandStatField() {
        this.setTitle("Right Hand");
        this.setBioPic("res/eca/images/hand-right-stat.png");
        this.addHotSpot(FINGER_4, 1, 43, 20, 20);
        this.addHotSpot(FINGER_3, 25, 13, 20, 20);
        this.addHotSpot(FINGER_2, 55, 5, 20, 20);
        this.addHotSpot(FINGER_1, 93, 19, 20, 20);
        this.addHotSpot(THUMB, 127, 85, 20, 20);
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        if (posList.contains(BiometricPosition.RIGHT_INDEX)) {
            this.setBiox(FINGER_1);
        }
        if (posList.contains(BiometricPosition.RIGHT_MIDDLE)) {
            this.setBiox(FINGER_2);
        }
        if (posList.contains(BiometricPosition.RIGHT_RING)) {
            this.setBiox(FINGER_3);
        }
        if (posList.contains(BiometricPosition.RIGHT_LITTLE)) {
            this.setBiox(FINGER_4);
        }
        if (posList.contains(BiometricPosition.RIGHT_THUMB)) {
            this.setBiox(THUMB);
        }
    }

    @Override
    public void setAuthenticated(List<BiometricPosition> posList) {
        if (posList.contains(BiometricPosition.RIGHT_INDEX)) {
            this.setAuth(FINGER_1);
        }
        if (posList.contains(BiometricPosition.RIGHT_MIDDLE)) {
            this.setAuth(FINGER_2);
        }
        if (posList.contains(BiometricPosition.RIGHT_RING)) {
            this.setAuth(FINGER_3);
        }
        if (posList.contains(BiometricPosition.RIGHT_LITTLE)) {
            this.setAuth(FINGER_4);
        }
        if (posList.contains(BiometricPosition.RIGHT_THUMB)) {
            this.setAuth(THUMB);
        }
    }
}

