/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

class PowerShellCommandProcessor
implements Callable {
    private static final String CRLF = "\r\n";
    private final BufferedReader reader;
    private final boolean checkTimeout;
    private final String name;

    public PowerShellCommandProcessor(String name, PrintWriter commandWriter, InputStream inputStream, boolean checkTimeout) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.checkTimeout = checkTimeout;
        this.name = name;
    }

    public String call() throws IOException, InterruptedException {
        StringBuilder powerShellOutput = new StringBuilder();
        if (this.startReading()) {
            String line;
            while (null != (line = this.reader.readLine())) {
                powerShellOutput.append(line).append(CRLF);
                try {
                    if (this.continueReading()) continue;
                    break;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PowerShellCommandProcessor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return powerShellOutput.toString();
    }

    private boolean startReading() throws IOException, InterruptedException {
        int timeWaiting = 0;
        while (!this.reader.ready()) {
            Thread.sleep(10L);
            if (!this.checkTimeout || (timeWaiting += 10) <= 2000) continue;
            return false;
        }
        return true;
    }

    private boolean continueReading() throws IOException, InterruptedException {
        Thread.sleep(10L);
        return this.reader.ready();
    }
}

