/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.fiducial.calib.circle.DetectCircleHexagonalGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.fiducial.calib.circle.KeyPointsCircleHexagonalGrid;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.ConfigEllipseDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.image.GrayF32;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class CalibrationDetectorCircleHexagonalGrid
implements DetectorFiducialCalibration {
    private DetectCircleHexagonalGrid<GrayF32> detector;
    private KeyPointsCircleHexagonalGrid keypoint = new KeyPointsCircleHexagonalGrid();
    private List<Point2D_F64> layout;
    private CalibrationObservation results;
    double spaceToDiameter;

    public CalibrationDetectorCircleHexagonalGrid(ConfigCircleHexagonalGrid config) {
        InputToBinary inputToBinary = FactoryThresholdBinary.threshold((ConfigThreshold)config.thresholding, GrayF32.class);
        BinaryEllipseDetector ellipseDetector = FactoryShapeDetector.ellipse((ConfigEllipseDetector)config.ellipse, GrayF32.class);
        this.spaceToDiameter = config.centerDistance / config.circleDiameter;
        double spaceToRadius = 2.0 * this.spaceToDiameter;
        double factor = 2.0 * Math.sin(1.0471975511965976) + 0.25;
        EllipsesIntoClusters e2c = new EllipsesIntoClusters(spaceToRadius * factor, config.ellipseSizeSimilarity, config.edgeIntensitySimilarityTolerance);
        this.detector = new DetectCircleHexagonalGrid(config.numRows, config.numCols, inputToBinary, ellipseDetector, e2c);
        this.layout = CalibrationDetectorCircleHexagonalGrid.createLayout(this.detector.getRows(), this.detector.getColumns(), config.centerDistance);
    }

    public boolean process(GrayF32 input) {
        this.results = new CalibrationObservation(input.width, input.height);
        this.detector.process(input);
        List<EllipseClustersIntoGrid.Grid> grids = this.detector.getGrids();
        if (grids.size() != 1) {
            return false;
        }
        if (!this.keypoint.process(grids.get(0))) {
            return false;
        }
        FastQueue<Point2D_F64> foundPixels = this.keypoint.getKeyPoints();
        for (int i = 0; i < foundPixels.size; ++i) {
            this.results.add((Point2D_F64)foundPixels.get(i), i);
        }
        return true;
    }

    public CalibrationObservation getDetectedPoints() {
        return this.results;
    }

    public List<Point2D_F64> getLayout() {
        return this.layout;
    }

    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.detector.getEllipseDetector().setLensDistortion(null, null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            this.detector.getEllipseDetector().setLensDistortion((PixelTransform)distToUndist, (PixelTransform)undistToDist);
        }
    }

    public static List<Point2D_F64> createLayout(int numRows, int numCols, double centerDistance) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double spaceX = centerDistance / 2.0;
        double spaceY = centerDistance * Math.sin(UtilAngle.radian((float)60.0f));
        double width = (double)(numCols - 1) * spaceX;
        double height = (double)(numRows - 1) * spaceY;
        for (int row = 0; row < numRows; ++row) {
            double y = (double)row * spaceY - height / 2.0;
            for (int col = row % 2; col < numCols; col += 2) {
                double x = (double)col * spaceX - width / 2.0;
                ret.add(new Point2D_F64(x, y));
            }
        }
        return ret;
    }

    public DetectCircleHexagonalGrid<GrayF32> getDetector() {
        return this.detector;
    }

    public KeyPointsCircleHexagonalGrid getKeypointFinder() {
        return this.keypoint;
    }

    public int getRows() {
        return this.detector.getRows();
    }

    public int getColumns() {
        return this.detector.getColumns();
    }

    public double getSpaceToDiameter() {
        return this.spaceToDiameter;
    }
}

