/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigSquareGrid
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public ConfigThreshold thresholding = ConfigThreshold.local((ThresholdType)ThresholdType.BLOCK_MEAN, (ConfigLength)ConfigLength.relative((double)0.02, (int)5));
    public ConfigPolygonDetector square = new ConfigPolygonDetector();
    public double squareWidth;
    public double spaceWidth;

    public ConfigSquareGrid(int numRows, int numCols, double squareWidth, double spaceWidth) {
        this.thresholding.scale = 0.85;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).cornerScorePenalty = 0.5;
        this.square.detector.minimumContour = ConfigLength.fixed((double)10.0);
        this.square.refineGray.cornerOffset = 1.0;
        this.square.refineGray.lineSamples = 15;
        this.square.refineGray.convergeTolPixels = 0.2;
        this.square.refineGray.maxIterations = 10;
        this.numRows = numRows;
        this.numCols = numCols;
        this.squareWidth = squareWidth;
        this.spaceWidth = spaceWidth;
    }

    public double getSpacetoSquareRatio() {
        return this.spaceWidth / this.squareWidth;
    }

    public void checkValidity() {
        if (this.numCols <= 0 || this.numRows <= 0) {
            throw new IllegalArgumentException("Must specify then number of rows and columns in the target");
        }
    }
}

