/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

public class EciEncoding {
    public static final String UTF8 = "UTF8";
    public static final String ISO8859_1 = "ISO8859_1";
    public static final String JIS = "JIS";

    public static String guessEncoding(byte[] message) {
        boolean isUtf8 = true;
        boolean isJis = true;
        boolean isIso = true;
        for (int i = 0; i < message.length; ++i) {
            int v = message[i] & 0xFF;
            if (isUtf8) {
                isUtf8 = EciEncoding.isValidUTF8(v);
            }
            if (isJis) {
                isJis = EciEncoding.isValidJIS(v);
            }
            if (!isIso) continue;
            isIso = EciEncoding.isValidIso8869_1(v);
        }
        if (isUtf8) {
            return UTF8;
        }
        if (isIso) {
            return ISO8859_1;
        }
        if (isJis) {
            return JIS;
        }
        return UTF8;
    }

    public static boolean isValidUTF8(int v) {
        return v >= 0 && v <= 191 || v >= 195 && v <= 244;
    }

    public static boolean isValidJIS(int v) {
        return v >= 32 && v <= 126 || v >= 161 && v <= 223;
    }

    public static boolean isValidIso8869_1(int v) {
        return v >= 32 && v <= 126 || v >= 160 && v <= 255;
    }

    public static String getEciCharacterSet(int designator) {
        switch (designator) {
            case 0: 
            case 2: {
                return "Cp437";
            }
            case 1: 
            case 3: {
                return ISO8859_1;
            }
            case 4: {
                return "ISO8859_2";
            }
            case 5: {
                return "ISO8859_3";
            }
            case 6: {
                return "ISO8859_4";
            }
            case 7: {
                return "ISO8859_5";
            }
            case 8: {
                return "ISO8859_6";
            }
            case 9: {
                return "ISO8859_7";
            }
            case 10: {
                return "ISO8859_8";
            }
            case 11: {
                return "ISO8859_9";
            }
            case 12: {
                return "ISO8859_10";
            }
            case 13: {
                return "ISO8859_11";
            }
            case 14: {
                return "ISO8859_12";
            }
            case 15: {
                return "ISO8859_13";
            }
            case 16: {
                return "ISO8859_14";
            }
            case 17: {
                return "ISO8859_15";
            }
            case 18: {
                return "ISO8859_16";
            }
            case 20: {
                return "SJIS";
            }
            case 21: {
                return "Cp1250";
            }
            case 22: {
                return "Cp1251";
            }
            case 23: {
                return "Cp1252";
            }
            case 24: {
                return "Cp1256";
            }
            case 25: {
                return "UnicodeBigUnmarked";
            }
            case 26: {
                return UTF8;
            }
            case 27: 
            case 170: {
                return "ASCII";
            }
            case 28: {
                return "Big5";
            }
            case 29: {
                return "GB18030";
            }
            case 30: {
                return "EUC_KR";
            }
        }
        throw new IllegalArgumentException("Unknown ECI designator " + designator);
    }
}

