/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.ReidSolomonCodes;
import georegression.struct.point.Point2D_I32;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.ddogleg.struct.GrowQueue_I8;
import org.ejml.data.BMatrixRMaj;
import org.ejml.ops.CommonOps_BDRM;

public class QrCodeEncoder {
    public static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";
    private ReidSolomonCodes rscodes = new ReidSolomonCodes(8, 285);
    private QrCode qr = new QrCode();
    private boolean autoErrorCorrection;
    private boolean autoMask;
    private Charset byteCharacterSet = StandardCharsets.UTF_8;
    PackedBits8 packed = new PackedBits8();
    private GrowQueue_I8 message = new GrowQueue_I8();
    private GrowQueue_I8 ecc = new GrowQueue_I8();
    private List<MessageSegment> segments = new ArrayList<MessageSegment>();
    Set<Character.UnicodeBlock> japaneseUnicodeBlocks = new HashSet<Character.UnicodeBlock>(){
        {
            this.add(Character.UnicodeBlock.HIRAGANA);
            this.add(Character.UnicodeBlock.KATAKANA);
            this.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        }
    };
    CharsetEncoder asciiEncoder = Charset.forName("ISO-8859-1").newEncoder();

    public QrCodeEncoder() {
        this.reset();
    }

    public void reset() {
        this.qr.reset();
        this.qr.version = -1;
        this.packed.size = 0;
        this.autoMask = true;
        this.autoErrorCorrection = true;
        this.segments.clear();
    }

    public QrCodeEncoder setVersion(int version) {
        this.qr.version = version;
        return this;
    }

    public QrCodeEncoder setError(@Nullable QrCode.ErrorLevel level) {
        this.autoErrorCorrection = level == null;
        this.qr.error = level;
        return this;
    }

    public QrCodeEncoder setMask(QrCodeMaskPattern pattern) {
        this.autoMask = false;
        this.qr.mask = pattern;
        return this;
    }

    public QrCodeEncoder addAutomatic(String message) {
        if (this.containsKanji(message)) {
            int start = 0;
            boolean kanji = this.isKanji(message.charAt(0));
            for (int i = 0; i < message.length(); ++i) {
                if (this.isKanji(message.charAt(i))) {
                    if (kanji) continue;
                    this.addAutomatic(message.substring(start, i));
                    start = i;
                    kanji = true;
                    continue;
                }
                if (!kanji) continue;
                this.addKanji(message.substring(start, i));
                start = i;
                kanji = false;
            }
            if (kanji) {
                this.addKanji(message.substring(start, message.length()));
            } else {
                this.addAutomatic(message.substring(start, message.length()));
            }
            return this;
        }
        if (this.containsByte(message)) {
            return this.addBytes(message);
        }
        if (this.containsAlphaNumeric(message)) {
            return this.addAlphanumeric(message);
        }
        return this.addNumeric(message);
    }

    private boolean isKanji(char c) {
        return !this.asciiEncoder.canEncode(c);
    }

    private boolean containsKanji(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (!this.isKanji(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean containsByte(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (ALPHANUMERIC.indexOf(message.charAt(i)) != -1) continue;
            return true;
        }
        return false;
    }

    private boolean containsAlphaNumeric(String message) {
        for (int i = 0; i < message.length(); ++i) {
            int c = message.charAt(i) - 48;
            if (c >= 0 && c <= 9) continue;
            return true;
        }
        return false;
    }

    public QrCodeEncoder addNumeric(String message) {
        byte[] numbers = new byte[message.length()];
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            int values = c - 48;
            if (values < 0 || values > 9) {
                throw new RuntimeException("Expected each character to be a number from 0 to 9");
            }
            numbers[i] = (byte)values;
        }
        return this.addNumeric(numbers);
    }

    public QrCodeEncoder addNumeric(byte[] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] >= 0 && numbers[i] <= 9) continue;
            throw new IllegalArgumentException("All numbers must have a value from 0 to 9");
        }
        StringBuilder builder = new StringBuilder(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            builder.append(Integer.toString(numbers[i]));
        }
        MessageSegment segment = new MessageSegment();
        segment.message = builder.toString();
        segment.data = numbers;
        segment.length = numbers.length;
        segment.mode = QrCode.Mode.NUMERIC;
        segment.encodedSizeBits += 4;
        segment.encodedSizeBits += 10 * (segment.length / 3);
        if (segment.length % 3 == 2) {
            segment.encodedSizeBits += 7;
        } else if (segment.length % 3 == 1) {
            segment.encodedSizeBits += 4;
        }
        this.segments.add(segment);
        return this;
    }

    private void encodeNumeric(byte[] numbers, int length) {
        int value;
        this.qr.mode = QrCode.Mode.NUMERIC;
        int lengthBits = QrCodeEncoder.getLengthBitsNumeric(this.qr.version);
        this.packed.append(1, 4, false);
        this.packed.append(length, lengthBits, false);
        int index = 0;
        while (length - index >= 3) {
            value = numbers[index] * 100 + numbers[index + 1] * 10 + numbers[index + 2];
            this.packed.append(value, 10, false);
            index += 3;
        }
        if (length - index == 2) {
            value = numbers[index] * 10 + numbers[index + 1];
            this.packed.append(value, 7, false);
        } else if (length - index == 1) {
            value = numbers[index];
            this.packed.append(value, 4, false);
        }
    }

    public QrCodeEncoder addAlphanumeric(String alphaNumeric) {
        byte[] values = QrCodeEncoder.alphanumericToValues(alphaNumeric);
        MessageSegment segment = new MessageSegment();
        segment.message = alphaNumeric;
        segment.data = values;
        segment.length = values.length;
        segment.mode = QrCode.Mode.ALPHANUMERIC;
        segment.encodedSizeBits += 4;
        segment.encodedSizeBits += 11 * (segment.length / 2);
        if (segment.length % 2 == 1) {
            segment.encodedSizeBits += 6;
        }
        this.segments.add(segment);
        return this;
    }

    private void encodeAlphanumeric(byte[] numbers, int length) {
        int value;
        this.qr.mode = QrCode.Mode.ALPHANUMERIC;
        int lengthBits = QrCodeEncoder.getLengthBitsAlphanumeric(this.qr.version);
        this.packed.append(2, 4, false);
        this.packed.append(length, lengthBits, false);
        int index = 0;
        while (length - index >= 2) {
            value = numbers[index] * 45 + numbers[index + 1];
            this.packed.append(value, 11, false);
            index += 2;
        }
        if (length - index == 1) {
            value = numbers[index];
            this.packed.append(value, 6, false);
        }
    }

    public static byte[] alphanumericToValues(String data) {
        byte[] output = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            int value = ALPHANUMERIC.indexOf(c);
            if (value < 0) {
                throw new IllegalArgumentException("Unsupported character '" + c + "' = " + c);
            }
            output[i] = (byte)value;
        }
        return output;
    }

    public static char valueToAlphanumeric(int value) {
        if (value < 0 || value >= ALPHANUMERIC.length()) {
            throw new RuntimeException("Value out of range");
        }
        return ALPHANUMERIC.charAt(value);
    }

    public QrCodeEncoder addBytes(String message) {
        return this.addBytes(message.getBytes(this.byteCharacterSet));
    }

    public QrCodeEncoder addBytes(byte[] data) {
        StringBuilder builder = new StringBuilder(data.length);
        for (int i = 0; i < data.length; ++i) {
            builder.append((char)data[i]);
        }
        MessageSegment segment = new MessageSegment();
        segment.message = builder.toString();
        segment.data = data;
        segment.length = data.length;
        segment.mode = QrCode.Mode.BYTE;
        segment.encodedSizeBits += 4;
        segment.encodedSizeBits += 8 * segment.length;
        this.segments.add(segment);
        return this;
    }

    private void encodeBytes(byte[] data, int length) {
        this.qr.mode = QrCode.Mode.BYTE;
        int lengthBits = QrCodeEncoder.getLengthBitsBytes(this.qr.version);
        this.packed.append(4, 4, false);
        this.packed.append(length, lengthBits, false);
        for (int i = 0; i < length; ++i) {
            this.packed.append(data[i] & 0xFF, 8, false);
        }
    }

    public QrCodeEncoder addKanji(String message) {
        byte[] bytes;
        try {
            bytes = message.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
        MessageSegment segment = new MessageSegment();
        segment.message = message;
        segment.data = bytes;
        segment.length = message.length();
        segment.mode = QrCode.Mode.KANJI;
        segment.encodedSizeBits += 4;
        segment.encodedSizeBits += 13 * segment.length;
        this.segments.add(segment);
        return this;
    }

    private void encodeKanji(byte[] bytes, int length) {
        this.qr.mode = QrCode.Mode.KANJI;
        int lengthBits = QrCodeEncoder.getLengthBitsKanji(this.qr.version);
        this.packed.append(8, 4, false);
        this.packed.append(length, lengthBits, false);
        for (int i = 0; i < bytes.length; i += 2) {
            int adjusted;
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            if (code >= 33088 && code <= 40956) {
                adjusted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                adjusted = code - 49472;
            } else {
                throw new IllegalArgumentException("Invalid byte sequence. At " + i / 2);
            }
            int encoded = (adjusted >> 8) * 192 + (adjusted & 0xFF);
            this.packed.append(encoded, 13, false);
        }
    }

    public static int getLengthBitsNumeric(int version) {
        return QrCodeEncoder.getLengthBits(version, 10, 12, 14);
    }

    public static int getLengthBitsAlphanumeric(int version) {
        return QrCodeEncoder.getLengthBits(version, 9, 11, 13);
    }

    public static int getLengthBitsBytes(int version) {
        return QrCodeEncoder.getLengthBits(version, 8, 16, 16);
    }

    public static int getLengthBitsKanji(int version) {
        return QrCodeEncoder.getLengthBits(version, 8, 10, 12);
    }

    private static int getLengthBits(int version, int bitsA, int bitsB, int bitsC) {
        int lengthBits = version < 10 ? bitsA : (version < 27 ? bitsB : bitsC);
        return lengthBits;
    }

    public QrCode eci() {
        return null;
    }

    public QrCode fixate() {
        this.autoSelectVersionAndError();
        int expectedBitSize = this.bitsAtVersion(this.qr.version);
        this.qr.message = "";
        block6: for (MessageSegment m : this.segments) {
            this.qr.message = this.qr.message + m.message;
            switch (m.mode) {
                case NUMERIC: {
                    this.encodeNumeric(m.data, m.length);
                    continue block6;
                }
                case ALPHANUMERIC: {
                    this.encodeAlphanumeric(m.data, m.length);
                    continue block6;
                }
                case BYTE: {
                    this.encodeBytes(m.data, m.length);
                    continue block6;
                }
                case KANJI: {
                    this.encodeKanji(m.data, m.length);
                    continue block6;
                }
            }
            throw new RuntimeException("Unknown");
        }
        if (this.packed.size != expectedBitSize) {
            throw new RuntimeException("Bad size code. " + this.packed.size + " vs " + expectedBitSize);
        }
        int maxBits = QrCode.VERSION_INFO[this.qr.version].codewords * 8;
        if (this.packed.size > maxBits) {
            throw new IllegalArgumentException("The message is longer than the max possible size");
        }
        if (this.packed.size + 4 <= maxBits) {
            this.packed.append(0, 4, false);
        }
        this.bitsToMessage(this.packed);
        if (this.autoMask) {
            this.qr.mask = QrCodeEncoder.selectMask(this.qr);
        }
        return this.qr;
    }

    static QrCodeMaskPattern selectMask(QrCode qr) {
        int N = qr.getNumberOfModules();
        int totalBytes = QrCode.VERSION_INFO[qr.version].codewords;
        List<Point2D_I32> locations = QrCode.LOCATION_BITS[qr.version];
        QrCodeMaskPattern bestMask = null;
        double bestScore = Double.MAX_VALUE;
        PackedBits8 bits = new PackedBits8();
        bits.size = totalBytes * 8;
        bits.data = qr.rawbits;
        if (bits.size > locations.size()) {
            throw new RuntimeException("BUG in code");
        }
        QrCodeCodeWordLocations matrix = new QrCodeCodeWordLocations(qr.version);
        for (QrCodeMaskPattern mask : QrCodeMaskPattern.values()) {
            double score = QrCodeEncoder.scoreMask(N, locations, bits, matrix, mask);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestMask = mask;
        }
        return bestMask;
    }

    private static double scoreMask(int N, List<Point2D_I32> locations, PackedBits8 bits, QrCodeCodeWordLocations matrix, QrCodeMaskPattern mask) {
        FoundFeatures features = new FoundFeatures();
        int blackInBlock = 0;
        for (int i = 0; i < bits.size; ++i) {
            Point2D_I32 p = locations.get(i);
            boolean v = mask.apply(p.y, p.x, bits.get(i)) == 1;
            matrix.unsafe_set(p.y, p.x, v);
            if (v) {
                ++blackInBlock;
            }
            if ((i + 1) % 8 != 0) continue;
            if (blackInBlock == 0 || blackInBlock == 8) {
                ++features.sameColorBlock;
            }
            blackInBlock = 0;
        }
        QrCodeEncoder.detectAdjacentAndPositionPatterns(N, matrix, features);
        double scale = (double)matrix.sum() / (double)(N * N);
        scale = scale < 0.5 ? 0.5 - scale : scale - 0.5;
        return (double)(features.adjacent + 3 * features.sameColorBlock + 40 * features.position) + (double)(N * N) * scale;
    }

    static void detectAdjacentAndPositionPatterns(int N, QrCodeCodeWordLocations matrix, FoundFeatures features) {
        for (int foo = 0; foo < 2; ++foo) {
            for (int row = 0; row < N; ++row) {
                int index = row * N;
                int col = 1;
                while (col < N) {
                    if (matrix.data[index] == matrix.data[index + 1]) {
                        ++features.adjacent;
                    }
                    ++col;
                    ++index;
                }
                index = row * N;
                col = 6;
                while (col < N) {
                    if (matrix.data[index] && !matrix.data[index + 1] && matrix.data[index + 2] && matrix.data[index + 3] && matrix.data[index + 4] && !matrix.data[index + 5] && matrix.data[index + 6]) {
                        ++features.position;
                    }
                    ++col;
                    ++index;
                }
            }
            CommonOps_BDRM.transposeSquare((BMatrixRMaj)matrix);
        }
        features.adjacent -= 216 + (N - 18) * 2;
    }

    private void autoSelectVersionAndError() {
        QrCode.VersionInfo v;
        int dataBits;
        int totalBytes;
        if (this.qr.version == -1) {
            QrCode.ErrorLevel[] levelsToTry = this.autoErrorCorrection ? new QrCode.ErrorLevel[]{QrCode.ErrorLevel.M, QrCode.ErrorLevel.L} : new QrCode.ErrorLevel[]{this.qr.error};
            QrCode.ErrorLevel[] errorLevelArray = levelsToTry;
            int n = errorLevelArray.length;
            block0: for (int i = 0; i < n; ++i) {
                QrCode.ErrorLevel error;
                this.qr.error = error = errorLevelArray[i];
                for (int i2 = 1; i2 <= 40; ++i2) {
                    int dataBits2 = this.bitsAtVersion(i2);
                    int totalBytes2 = dataBits2 / 8 + dataBits2 % 8 % 8;
                    if (totalBytes2 > QrCode.VERSION_INFO[i2].totalDataBytes(this.qr.error)) continue;
                    this.qr.version = i2;
                    break block0;
                }
            }
            if (this.qr.version == -1) {
                throw new IllegalArgumentException("Packet too to be encoded in a qr code");
            }
        } else if (this.autoErrorCorrection) {
            this.qr.error = null;
            QrCode.VersionInfo v2 = QrCode.VERSION_INFO[this.qr.version];
            int dataBits3 = this.bitsAtVersion(this.qr.version);
            int totalBytes3 = dataBits3 / 8 + dataBits3 % 8 % 8;
            for (QrCode.ErrorLevel level : QrCode.ErrorLevel.values()) {
                if (totalBytes3 > v2.totalDataBytes(level)) continue;
                this.qr.error = level;
            }
            if (this.qr.error == null) {
                throw new IllegalArgumentException("You need to use a high version number to store the data. Tried all error correction levels at version " + this.qr.version + ". Total Data " + this.packed.size / 8);
            }
        }
        if ((totalBytes = (dataBits = this.bitsAtVersion(this.qr.version)) / 8 + dataBits % 8 % 8) > (v = QrCode.VERSION_INFO[this.qr.version]).totalDataBytes(this.qr.error)) {
            throw new IllegalArgumentException("Version and error level can't encode all the data");
        }
    }

    private int bitsAtVersion(int version) {
        int total = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            total += this.segments.get(i).sizeInBits(version);
        }
        return total;
    }

    protected void bitsToMessage(PackedBits8 stream) {
        stream.append(0, (8 - stream.size % 8) % 8, false);
        QrCode.VersionInfo info = QrCode.VERSION_INFO[this.qr.version];
        QrCode.BlockInfo block = info.levels.get((Object)this.qr.error);
        this.qr.rawbits = new byte[info.codewords];
        int wordsBlockAllA = block.codewords;
        int wordsBlockDataA = block.dataCodewords;
        int wordsEcc = wordsBlockAllA - wordsBlockDataA;
        int numBlocksA = block.blocks;
        int wordsBlockAllB = wordsBlockAllA + 1;
        int wordsBlockDataB = wordsBlockDataA + 1;
        int numBlocksB = (info.codewords - wordsBlockAllA * numBlocksA) / wordsBlockAllB;
        this.message.resize(wordsBlockDataA + 1);
        int startEcc = numBlocksA * wordsBlockDataA + numBlocksB * wordsBlockDataB;
        int totalBlocks = numBlocksA + numBlocksB;
        this.rscodes.generator(wordsEcc);
        this.ecc.resize(wordsEcc);
        this.encodeBlocks(stream, wordsBlockDataA, numBlocksA, 0, 0, startEcc, totalBlocks);
        this.encodeBlocks(stream, wordsBlockDataB, numBlocksB, wordsBlockDataA * numBlocksA, numBlocksA, startEcc, totalBlocks);
    }

    private void encodeBlocks(PackedBits8 stream, int bytesInDataBlock, int numberOfBlocks, int streamOffset, int blockOffset, int startEcc, int stride) {
        this.message.size = bytesInDataBlock;
        for (int idxBlock = 0; idxBlock < numberOfBlocks; ++idxBlock) {
            int length = Math.min(bytesInDataBlock, Math.max(0, stream.arrayLength() - streamOffset));
            if (length > 0) {
                System.arraycopy(stream.data, streamOffset, this.message.data, 0, length);
            }
            this.addPadding(this.message, length, 55, 136);
            QrCodeEncoder.flipBits8(this.message);
            this.rscodes.computeECC(this.message, this.ecc);
            QrCodeEncoder.flipBits8(this.message);
            QrCodeEncoder.flipBits8(this.ecc);
            this.copyIntoRawData(this.message, this.ecc, idxBlock + blockOffset, stride, startEcc, this.qr.rawbits);
            streamOffset += this.message.size;
        }
    }

    public static void flipBits8(byte[] array, int size) {
        for (int j = 0; j < size; ++j) {
            array[j] = QrCodeEncoder.flipBits8(array[j] & 0xFF);
        }
    }

    public static void flipBits8(GrowQueue_I8 array) {
        QrCodeEncoder.flipBits8(array.data, array.size);
    }

    public static byte flipBits8(int x) {
        int b = 0;
        for (int i = 0; i < 8; ++i) {
            b <<= 1;
            b |= x & 1;
            x >>= 1;
        }
        return (byte)b;
    }

    private void addPadding(GrowQueue_I8 queue, int dataBytes, int padding0, int padding1) {
        boolean a = true;
        for (int i = dataBytes; i < queue.size; ++i) {
            queue.data[i] = a ? (byte)padding0 : (byte)padding1;
            a = !a;
        }
    }

    private void print(String name, GrowQueue_I8 queue) {
        PackedBits8 bits = new PackedBits8();
        bits.size = queue.size * 8;
        bits.data = queue.data;
        System.out.print(name + "  ");
        bits.print();
    }

    private void copyIntoRawData(GrowQueue_I8 message, GrowQueue_I8 ecc, int offset, int stride, int startEcc, byte[] output) {
        int i;
        for (i = 0; i < message.size; ++i) {
            output[i * stride + offset] = message.data[i];
        }
        for (i = 0; i < ecc.size; ++i) {
            output[i * stride + offset + startEcc] = ecc.data[i];
        }
    }

    public Charset getByteCharacterSet() {
        return this.byteCharacterSet;
    }

    public void setByteCharacterSet(Charset byteCharacterSet) {
        this.byteCharacterSet = byteCharacterSet;
    }

    private static class MessageSegment {
        QrCode.Mode mode;
        String message;
        byte[] data;
        int length;
        int encodedSizeBits;

        private MessageSegment() {
        }

        public int sizeInBits(int version) {
            int lengthBits;
            switch (this.mode) {
                case NUMERIC: {
                    lengthBits = QrCodeEncoder.getLengthBitsNumeric(version);
                    break;
                }
                case ALPHANUMERIC: {
                    lengthBits = QrCodeEncoder.getLengthBitsAlphanumeric(version);
                    break;
                }
                case BYTE: {
                    lengthBits = QrCodeEncoder.getLengthBitsBytes(version);
                    break;
                }
                case KANJI: {
                    lengthBits = QrCodeEncoder.getLengthBitsKanji(version);
                    break;
                }
                default: {
                    throw new RuntimeException("Egads");
                }
            }
            return this.encodedSizeBits + lengthBits;
        }
    }

    static class FoundFeatures {
        int adjacent = 0;
        int sameColorBlock = 0;
        int position = 0;

        FoundFeatures() {
        }
    }
}

