/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.struct.distort.DoNothing2Transform2_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.List;

public class QrPose3DUtils {
    public List<PointIndex2D_F64> pixelControl = new ArrayList<PointIndex2D_F64>();
    public List<Point2D3D> point23 = new ArrayList<Point2D3D>();
    public List<Point3D_F64> point3D = new ArrayList<Point3D_F64>();
    protected Point2Transform2_F64 pixelToNorm = new DoNothing2Transform2_F64();
    protected Point2Transform2_F64 undistToDist = new DoNothing2Transform2_F64();

    public QrPose3DUtils() {
        for (int i = 0; i < 12; ++i) {
            this.pixelControl.add(new PointIndex2D_F64(0.0, 0.0, i));
            this.point23.add(new Point2D3D());
            this.point3D.add(new Point3D_F64());
        }
    }

    public List<PointIndex2D_F64> getLandmarkByIndex(QrCode qr) {
        this.pixelControl.get(0).set(qr.ppCorner.get(0));
        this.pixelControl.get(1).set(qr.ppCorner.get(1));
        this.pixelControl.get(2).set(qr.ppCorner.get(2));
        this.pixelControl.get(3).set(qr.ppCorner.get(3));
        this.pixelControl.get(4).set(qr.ppRight.get(0));
        this.pixelControl.get(5).set(qr.ppRight.get(1));
        this.pixelControl.get(6).set(qr.ppRight.get(2));
        this.pixelControl.get(7).set(qr.ppRight.get(3));
        this.pixelControl.get(8).set(qr.ppDown.get(0));
        this.pixelControl.get(9).set(qr.ppDown.get(1));
        this.pixelControl.get(10).set(qr.ppDown.get(2));
        this.pixelControl.get(11).set(qr.ppDown.get(3));
        for (int i = 0; i < this.pixelControl.size(); ++i) {
            PointIndex2D_F64 p = this.pixelControl.get(i);
            this.undistToDist.compute(p.x, p.y, (Point2D_F64)p);
        }
        return this.pixelControl;
    }

    public List<Point2D3D> getLandmark2D3D(QrCode qr) {
        int N = qr.getNumberOfModules();
        this.setPair(0, 0, 0, N, qr.ppCorner.get(0));
        this.setPair(1, 0, 7, N, qr.ppCorner.get(1));
        this.setPair(2, 7, 7, N, qr.ppCorner.get(2));
        this.setPair(3, 7, 0, N, qr.ppCorner.get(3));
        this.setPair(4, 0, N - 7, N, qr.ppRight.get(0));
        this.setPair(5, 0, N, N, qr.ppRight.get(1));
        this.setPair(6, 7, N, N, qr.ppRight.get(2));
        this.setPair(7, 7, N - 7, N, qr.ppRight.get(3));
        this.setPair(8, N - 7, 0, N, qr.ppDown.get(0));
        this.setPair(9, N - 7, 7, N, qr.ppDown.get(1));
        this.setPair(10, N, 7, N, qr.ppDown.get(2));
        this.setPair(11, N, 0, N, qr.ppDown.get(3));
        return this.point23;
    }

    public List<Point3D_F64> getLandmark3D(int version) {
        int N = QrCode.totalModules(version);
        this.set3D(0, 0, N, this.point3D.get(0));
        this.set3D(0, 7, N, this.point3D.get(1));
        this.set3D(7, 7, N, this.point3D.get(2));
        this.set3D(7, 0, N, this.point3D.get(3));
        this.set3D(0, N - 7, N, this.point3D.get(4));
        this.set3D(0, N, N, this.point3D.get(5));
        this.set3D(7, N, N, this.point3D.get(6));
        this.set3D(7, N - 7, N, this.point3D.get(7));
        this.set3D(N - 7, 0, N, this.point3D.get(8));
        this.set3D(N - 7, 7, N, this.point3D.get(9));
        this.set3D(N, 7, N, this.point3D.get(10));
        this.set3D(N, 0, N, this.point3D.get(11));
        return this.point3D;
    }

    private void setPair(int which, int row, int col, int N, Point2D_F64 pixel) {
        this.set3D(row, col, N, this.point23.get((int)which).location);
        this.pixelToNorm.compute(pixel.x, pixel.y, this.point23.get((int)which).observation);
    }

    private void set3D(int row, int col, int N, Point3D_F64 location) {
        double _N = N;
        double gridX = 2.0 * ((double)col / _N - 0.5);
        double gridY = 2.0 * (0.5 - (double)row / _N);
        location.set(gridX, gridY, 0.0);
    }

    public void setLensDistortion(Point2Transform2_F64 pixelToNorm, Point2Transform2_F64 undistToDist) {
        if (pixelToNorm == null) {
            this.pixelToNorm = new DoNothing2Transform2_F64();
            this.undistToDist = new DoNothing2Transform2_F64();
        } else {
            this.pixelToNorm = pixelToNorm;
            this.undistToDist = undistToDist;
        }
    }

    public Point2Transform2_F64 getPixelToNorm() {
        return this.pixelToNorm;
    }
}

