/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.distort.FDistort;
import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.PixelMath;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;

public class FiducialSquareGenerator {
    FiducialRenderEngine renderer;
    double whiteBorderDoc = 0.0;
    double blackBorder = 0.25;
    double markerWidth = 0.0;

    public FiducialSquareGenerator(FiducialRenderEngine renderer) {
        this.renderer = renderer;
    }

    public void generate(GrayU8 image) {
        this.renderer.init();
        int s = image.width - image.width % 8;
        if (image.width != s || image.height != s) {
            GrayU8 tmp = new GrayU8(s, s);
            new FDistort((ImageBase)image, (ImageBase)tmp).scaleExt().apply();
            image = tmp;
        }
        GrayU8 binary = ThresholdImageOps.threshold((GrayU8)image, null, (int)125, (boolean)false);
        PixelMath.multiply((GrayU8)binary, (double)255.0, (GrayU8)binary);
        double whiteBorder = this.whiteBorderDoc / this.markerWidth;
        double X0 = whiteBorder + this.blackBorder;
        double Y0 = whiteBorder + this.blackBorder;
        this.drawBorder();
        this.draw(image, X0, Y0, 1.0 - X0, 1.0 - Y0);
    }

    void drawBorder() {
        double whiteBorder = this.whiteBorderDoc / this.markerWidth;
        double X0 = whiteBorder + this.blackBorder;
        double Y0 = whiteBorder + this.blackBorder;
        this.rectangle(whiteBorder, whiteBorder, 1.0 - whiteBorder, Y0);
        this.rectangle(whiteBorder, 1.0 - Y0, 1.0 - whiteBorder, 1.0 - whiteBorder);
        this.rectangle(whiteBorder, Y0, X0, 1.0 - Y0);
        this.rectangle(1.0 - X0, Y0, 1.0 - whiteBorder, 1.0 - Y0);
    }

    public void generate(long value, int gridWidth) {
        this.renderer.init();
        this.drawBorder();
        double whiteBorder = this.whiteBorderDoc / this.markerWidth;
        double X0 = whiteBorder + this.blackBorder;
        double Y0 = whiteBorder + this.blackBorder;
        double bw = (1.0 - 2.0 * X0) / (double)gridWidth;
        this.square(X0, 1.0 - whiteBorder - this.blackBorder - bw, bw);
        int bitCount = gridWidth * gridWidth - 4;
        for (int j = 0; j < bitCount; ++j) {
            if ((value & 1L << j) == 0L) continue;
            this.box(bw, j, gridWidth);
        }
    }

    private void box(double boxWidth, int bit, int gridWidth) {
        int adjustedBit;
        double whiteBorder = this.whiteBorderDoc / this.markerWidth;
        double X0 = whiteBorder + this.blackBorder;
        double Y0 = whiteBorder + this.blackBorder;
        int transitionBit0 = gridWidth - 3;
        int transitionBit1 = transitionBit0 + gridWidth * (gridWidth - 2);
        int transitionBit2 = transitionBit1 + gridWidth - 2;
        if (bit <= transitionBit0) {
            adjustedBit = bit + 1;
        } else if (bit <= transitionBit1) {
            adjustedBit = bit + 2;
        } else if (bit <= transitionBit2) {
            adjustedBit = bit + 3;
        } else {
            throw new RuntimeException("Bit must be between 0 and " + transitionBit2);
        }
        int x = adjustedBit % gridWidth;
        int y = gridWidth - adjustedBit / gridWidth - 1;
        this.square(X0 + (double)x * boxWidth, Y0 + (double)y * boxWidth, boxWidth);
    }

    private void draw(GrayU8 image, double x0, double y0, double x1, double y1) {
        this.renderer.draw(image, this.U(x0), this.U(y0), this.U(x1), this.U(y1));
    }

    private void rectangle(double x0, double y0, double x1, double y1) {
        this.renderer.rectangle(this.U(x0), this.U(y0), this.U(x1), this.U(y1));
    }

    private void square(double x0, double y0, double width) {
        this.renderer.square(this.U(x0), this.U(y0), this.U(width));
    }

    double U(double f) {
        return f * this.markerWidth;
    }

    public double getWhiteBorderDoc() {
        return this.whiteBorderDoc;
    }

    public void setWhiteBorderDoc(double whiteBorder) {
        this.whiteBorderDoc = whiteBorder;
    }

    public double getBlackBorder() {
        return this.blackBorder;
    }

    public void setBlackBorder(double blackBorder) {
        this.blackBorder = blackBorder;
    }

    public void setMarkerWidth(double markerWidth) {
        this.markerWidth = markerWidth;
    }

    public double getMarkerWidth() {
        return this.markerWidth;
    }
}

