/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.alg.scene.FeatureToWordHistogram;
import boofcv.alg.scene.HistogramScene;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;

public class ClassifierKNearestNeighborsBow<T extends ImageBase<T>, Desc extends TupleDesc> {
    private NearestNeighbor<HistogramScene> nn;
    private DescribeImageDense<T, Desc> describe;
    private FeatureToWordHistogram<Desc> featureToHistogram;
    private FastQueue<NnData<HistogramScene>> resultsNN = new FastQueue(NnData.class, true);
    private int numNeighbors;
    private double[] scenes;
    HistogramScene temp = new HistogramScene();

    public ClassifierKNearestNeighborsBow(NearestNeighbor<HistogramScene> nn, DescribeImageDense<T, Desc> describe, FeatureToWordHistogram<Desc> featureToHistogram) {
        this.nn = nn;
        this.describe = describe;
        this.featureToHistogram = featureToHistogram;
    }

    public void setNumNeighbors(int numNeighbors) {
        this.numNeighbors = numNeighbors;
    }

    public void setClassificationData(List<HistogramScene> memory, int numScenes) {
        this.nn.setPoints(memory, false);
        this.scenes = new double[numScenes];
    }

    public int classify(T image) {
        int i;
        if (this.numNeighbors == 0) {
            throw new IllegalArgumentException("Must specify number of neighbors!");
        }
        this.describe.process(image);
        this.featureToHistogram.reset();
        List imageFeatures = this.describe.getDescriptions();
        for (i = 0; i < imageFeatures.size(); ++i) {
            TupleDesc d = (TupleDesc)imageFeatures.get(i);
            this.featureToHistogram.addFeature(d);
        }
        this.featureToHistogram.process();
        this.temp.histogram = this.featureToHistogram.getHistogram();
        this.resultsNN.reset();
        this.nn.findNearest((Object)this.temp, -1.0, this.numNeighbors, this.resultsNN);
        Arrays.fill(this.scenes, 0.0);
        for (i = 0; i < this.resultsNN.size; ++i) {
            NnData data = (NnData)this.resultsNN.get(i);
            HistogramScene n = (HistogramScene)data.point;
            int n2 = n.type;
            this.scenes[n2] = this.scenes[n2] + 1.0 / (data.distance + 0.005);
        }
        int bestIndex = 0;
        double bestCount = 0.0;
        for (int i2 = 0; i2 < this.scenes.length; ++i2) {
            if (!(this.scenes[i2] > bestCount)) continue;
            bestCount = this.scenes[i2];
            bestIndex = i2;
        }
        return bestIndex;
    }
}

