/*
 * Decompiled with CFR 0.152.
 */
package boofcv.deepboof;

import boofcv.alg.color.ColorYuv;
import boofcv.alg.filter.stat.ImageLocalNormalization;
import boofcv.deepboof.BaseImageClassifier;
import boofcv.deepboof.DataManipulationOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import deepboof.datasets.UtilCifar10;
import deepboof.io.torch7.ParseBinaryTorch7;
import deepboof.io.torch7.SequenceAndParameters;
import deepboof.misc.TensorOps;
import deepboof.models.DeepModelIO;
import deepboof.models.YuvStatistics;
import deepboof.tensors.Tensor_F32;
import java.io.File;
import java.io.IOException;

public class ImageClassifierVggCifar10
extends BaseImageClassifier {
    static final int inputSize = 32;
    Planar<GrayF32> imageYuv = new Planar(GrayF32.class, 32, 32, 3);
    ImageLocalNormalization<GrayF32> localNorm;
    YuvStatistics stats;
    Kernel1D_F32 kernel;

    public ImageClassifierVggCifar10() {
        super(32);
        this.categories.addAll(UtilCifar10.getClassNames());
    }

    @Override
    public void loadModel(File directory) throws IOException {
        this.stats = DeepModelIO.load((File)new File(directory, "YuvStatistics.txt"));
        SequenceAndParameters sequence = (SequenceAndParameters)new ParseBinaryTorch7().parseIntoBoof(new File(directory, "model.net"));
        this.network = sequence.createForward(new int[]{3, 32, 32});
        this.tensorOutput = new Tensor_F32(TensorOps.WI((int)1, (int[])this.network.getOutputShape()));
        BorderType type = BorderType.valueOf((String)this.stats.border);
        this.localNorm = new ImageLocalNormalization(GrayF32.class, type);
        this.kernel = DataManipulationOps.create1D_F32(this.stats.kernel);
    }

    @Override
    protected Planar<GrayF32> preprocess(Planar<GrayF32> image) {
        super.preprocess(image);
        ColorYuv.rgbToYuv((Planar)this.imageRgb, this.imageYuv);
        this.localNorm.zeroMeanStdOne((Kernel1D)this.kernel, (GrayF)this.imageYuv.getBand(0), 255.0, 1.0E-4, (GrayF)this.imageYuv.getBand(0));
        DataManipulationOps.normalize((GrayF32)this.imageYuv.getBand(1), (float)this.stats.meanU, (float)this.stats.stdevU);
        DataManipulationOps.normalize((GrayF32)this.imageYuv.getBand(2), (float)this.stats.meanV, (float)this.stats.stdevV);
        return this.imageYuv;
    }
}

