/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.fiducial.CalibrationFiducialDetector;
import boofcv.abst.fiducial.QrCodeDetectorPnP;
import boofcv.abst.fiducial.QrCodePreciseDetector;
import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.qrcode.QrCodePositionPatternDetector;
import boofcv.alg.fiducial.square.DetectFiducialSquareBinary;
import boofcv.alg.fiducial.square.DetectFiducialSquareImage;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.fiducial.ConfigQrCode;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.image.ImageGray;
import javax.annotation.Nullable;

public class FactoryFiducial {
    public static <T extends ImageGray<T>> SquareBinary_to_FiducialDetector<T> squareBinary(ConfigFiducialBinary configFiducial, @Nullable ConfigThreshold configThreshold, Class<T> imageType) {
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (int)21);
        }
        configFiducial.checkValidity();
        InputToBinary binary = FactoryThresholdBinary.threshold((ConfigThreshold)configThreshold, imageType);
        DetectPolygonBinaryGrayRefine squareDetector = FactoryShapeDetector.polygon((ConfigPolygonDetector)configFiducial.squareDetector, imageType);
        DetectFiducialSquareBinary<T> alg = new DetectFiducialSquareBinary<T>(configFiducial.gridWidth, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, binary, squareDetector, imageType);
        alg.setAmbiguityThreshold(configFiducial.ambiguousThreshold);
        return new SquareBinary_to_FiducialDetector<T>(alg, configFiducial.targetWidth);
    }

    public static <T extends ImageGray<T>> SquareImage_to_FiducialDetector<T> squareImage(@Nullable ConfigFiducialImage configFiducial, @Nullable ConfigThreshold configThreshold, Class<T> imageType) {
        if (configFiducial == null) {
            configFiducial = new ConfigFiducialImage();
        }
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (int)21);
        }
        configFiducial.squareDetector.detector.clockwise = false;
        InputToBinary binary = FactoryThresholdBinary.threshold((ConfigThreshold)configThreshold, imageType);
        DetectPolygonBinaryGrayRefine squareDetector = FactoryShapeDetector.polygon((ConfigPolygonDetector)configFiducial.squareDetector, imageType);
        DetectFiducialSquareImage<T> alg = new DetectFiducialSquareImage<T>(binary, squareDetector, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, configFiducial.maxErrorFraction, imageType);
        return new SquareImage_to_FiducialDetector<T>(alg);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibChessboard(ConfigChessboard config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGrid(ConfigSquareGrid config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGridBinary(ConfigSquareGridBinary config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleHexagonalGrid(ConfigCircleHexagonalGrid config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleRegularGrid(ConfigCircleRegularGrid config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> QrCodePreciseDetector<T> qrcode(ConfigQrCode config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigQrCode();
        }
        config.checkValidity();
        InputToBinary inputToBinary = FactoryThresholdBinary.threshold((ConfigThreshold)config.threshold, imageType);
        DetectPolygonBinaryGrayRefine squareDetector = FactoryShapeDetector.polygon((ConfigPolygonDetector)config.polygon, imageType);
        QrCodePositionPatternDetector detectPositionPatterns = new QrCodePositionPatternDetector(squareDetector, config.versionMaximum);
        return new QrCodePreciseDetector(inputToBinary, detectPositionPatterns, config.forceEncoding, false, imageType);
    }

    public static <T extends ImageGray<T>> QrCodeDetectorPnP<T> qrcode3D(ConfigQrCode config, Class<T> imageType) {
        return new QrCodeDetectorPnP<T>(FactoryFiducial.qrcode(config, imageType));
    }
}

