/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.ColorXyz;
import boofcv.alg.color.impl.ImplColorLab;
import boofcv.alg.color.impl.ImplColorLab_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorLab {
    public static final double epsilon = 0.008856;
    public static final double kappa = 903.3;
    public static final double Xr = 0.950456;
    public static final double Yr = 1.0;
    public static final double Zr = 1.088754;
    public static final float epsilon_f = 0.008856f;
    public static final float kappa_f = 903.3f;
    public static final float Xr_f = 0.950456f;
    public static final float Yr_f = 1.0f;
    public static final float Zr_f = 1.088754f;

    public static void srgbToLab(double r, double g, double b, double[] lab) {
        ColorXyz.srgbToXyz(r, g, b, lab);
        double X = lab[0];
        double Y = lab[1];
        double Z = lab[2];
        double xr = X / 0.950456;
        double yr = Y / 1.0;
        double zr = Z / 1.088754;
        double fx = xr > 0.008856 ? Math.pow(xr, 0.3333333333333333) : (903.3 * xr + 16.0) / 116.0;
        double fy = yr > 0.008856 ? Math.pow(yr, 0.3333333333333333) : (903.3 * yr + 16.0) / 116.0;
        double fz = zr > 0.008856 ? Math.pow(zr, 0.3333333333333333) : (903.3 * zr + 16.0) / 116.0;
        lab[0] = 116.0 * fy - 16.0;
        lab[1] = 500.0 * (fx - fy);
        lab[2] = 200.0 * (fy - fz);
    }

    public static void srgbToLab(float r, float g, float b, float[] lab) {
        ColorXyz.srgbToXyz(r, g, b, lab);
        float X = lab[0];
        float Y = lab[1];
        float Z = lab[2];
        float xr = X / 0.950456f;
        float yr = Y / 1.0f;
        float zr = Z / 1.088754f;
        float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
        float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
        float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
        lab[0] = 116.0f * fy - 16.0f;
        lab[1] = 500.0f * (fx - fy);
        lab[2] = 200.0f * (fy - fz);
    }

    public static <T extends ImageGray<T>> void rgbToLab(Planar<T> rgb, Planar<GrayF32> lab) {
        lab.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.rgbToLab_U8(rgb, lab);
            } else {
                ImplColorLab.rgbToLab_U8(rgb, lab);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorLab_MT.rgbToLab_F32(rgb, lab);
            } else {
                ImplColorLab.rgbToLab_F32(rgb, lab);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }
}

