/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.lists.RecycleStack;

public class ThresholdBlock<T extends ImageGray<T>, S extends ImageBase<S>>
implements InputToBinary<T> {
    ImageType<T> imageType;
    protected S stats;
    protected ConfigLength requestedBlockWidth;
    protected int blockWidth;
    protected int blockHeight;
    protected boolean thresholdFromLocalBlocks;
    protected BlockProcessor<T, S> original;
    protected RecycleStack<BlockProcessor<T, S>> processors;

    public ThresholdBlock(BlockProcessor<T, S> processor, ConfigLength requestedBlockWidth, boolean thresholdFromLocalBlocks, Class<T> imageClass) {
        this.requestedBlockWidth = requestedBlockWidth;
        this.imageType = ImageType.single(imageClass);
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
        this.stats = processor.createStats();
        this.original = processor;
        this.processors = new RecycleStack(() -> processor.copy());
    }

    @Override
    public void process(T input, GrayU8 output) {
        output.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        int requestedBlockWidth = this.requestedBlockWidth.computeI((double)Math.min(((ImageGray)input).width, ((ImageGray)input).height));
        if (((ImageGray)input).width < requestedBlockWidth || ((ImageGray)input).height < requestedBlockWidth) {
            throw new IllegalArgumentException("Image is smaller than block size");
        }
        this.selectBlockSize(((ImageGray)input).width, ((ImageGray)input).height, requestedBlockWidth);
        this.stats.reshape(((ImageGray)input).width / this.blockWidth, ((ImageGray)input).height / this.blockHeight);
        int innerWidth = ((ImageGray)input).width % this.blockWidth == 0 ? ((ImageGray)input).width : ((ImageGray)input).width - this.blockWidth - ((ImageGray)input).width % this.blockWidth;
        int innerHeight = ((ImageGray)input).height % this.blockHeight == 0 ? ((ImageGray)input).height : ((ImageGray)input).height - this.blockHeight - ((ImageGray)input).height % this.blockHeight;
        this.computeStatistics(input, innerWidth, innerHeight);
        this.applyThreshold(input, output);
    }

    void selectBlockSize(int width, int height, int requestedBlockWidth) {
        int rows = height / requestedBlockWidth;
        int cols = width / requestedBlockWidth;
        this.blockHeight = height / rows;
        this.blockWidth = width / cols;
    }

    protected void applyThreshold(T input, GrayU8 output) {
        for (int blockY = 0; blockY < ((ImageBase)this.stats).height; ++blockY) {
            for (int blockX = 0; blockX < ((ImageBase)this.stats).width; ++blockX) {
                this.original.thresholdBlock(blockX, blockY, input, this.stats, output);
            }
        }
    }

    protected void computeStatistics(T input, int innerWidth, int innerHeight) {
        int y;
        this.original.init(this.blockWidth, this.blockHeight, this.thresholdFromLocalBlocks);
        int statPixelStride = this.stats.getImageType().getNumBands();
        int indexStats = 0;
        for (y = 0; y < innerHeight; y += this.blockHeight) {
            int x = 0;
            while (x < innerWidth) {
                this.original.computeBlockStatistics(x, y, this.blockWidth, this.blockHeight, indexStats, input, this.stats);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth == ((ImageGray)input).width) continue;
            this.original.computeBlockStatistics(innerWidth, y, ((ImageGray)input).width - innerWidth, this.blockHeight, indexStats, input, this.stats);
            indexStats += statPixelStride;
        }
        if (innerHeight != ((ImageGray)input).height) {
            y = innerHeight;
            int blockHeight = ((ImageGray)input).height - innerHeight;
            int x = 0;
            while (x < innerWidth) {
                this.original.computeBlockStatistics(x, y, this.blockWidth, blockHeight, indexStats, input, this.stats);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth != ((ImageGray)input).width) {
                this.original.computeBlockStatistics(innerWidth, y, ((ImageGray)input).width - innerWidth, blockHeight, indexStats, input, this.stats);
            }
        }
    }

    public boolean isThresholdFromLocalBlocks() {
        return this.thresholdFromLocalBlocks;
    }

    public void setThresholdFromLocalBlocks(boolean thresholdFromLocalBlocks) {
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }

    public static interface BlockProcessor<T extends ImageGray<T>, S extends ImageBase<S>> {
        public S createStats();

        public void init(int var1, int var2, boolean var3);

        public void computeBlockStatistics(int var1, int var2, int var3, int var4, int var5, T var6, S var7);

        public void thresholdBlock(int var1, int var2, T var3, S var4, GrayU8 var5);

        public BlockProcessor<T, S> copy();
    }
}

