/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.BOverrideBlurImageOps;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner_MT;
import boofcv.alg.filter.blur.impl.ImplMedianSortEdgeNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.concurrency.WorkArrays;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import javax.annotation.Nullable;

public class BlurImageOps {
    public static GrayU8 mean(GrayU8 input, @Nullable GrayU8 output, int radius, @Nullable GrayU8 storage, @Nullable IWorkArrays workVert) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = (GrayU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius, storage = (GrayU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, (GrayI8)output, radius, workVert);
        }
        return output;
    }

    public static GrayU16 mean(GrayU16 input, @Nullable GrayU16 output, int radius, @Nullable GrayU16 storage, @Nullable IWorkArrays workVert) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = (GrayU16)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius, storage = (GrayU16)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, (GrayI16)storage, radius);
            ConvolveImageMean.vertical(storage, (GrayI16)output, radius, workVert);
        }
        return output;
    }

    public static GrayF32 mean(GrayF32 input, @Nullable GrayF32 output, int radius, @Nullable GrayF32 storage, @Nullable FWorkArrays workVert) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius, storage = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, output, radius, workVert);
        }
        return output;
    }

    public static GrayF64 mean(GrayF64 input, @Nullable GrayF64 output, int radius, @Nullable GrayF64 storage, @Nullable DWorkArrays workVert) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius, storage = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, output, radius, workVert);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> mean(Planar<T> input, @Nullable Planar<T> output, int radius, @Nullable T storage, @Nullable WorkArrays workVert) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand((Class)input.getBandType(), (int)input.width, (int)input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.mean(input.getBand(band), output.getBand(band), radius, storage, workVert);
        }
        return output;
    }

    public static GrayU8 median(GrayU8 input, @Nullable GrayU8 output, int radius, @Nullable IWorkArrays work) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output = (GrayU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius);
        if (!processed) {
            int w = radius * 2 + 1;
            int[] offset = new int[w * w];
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplMedianHistogramInner_MT.process(input, output, radius, work);
            } else {
                ImplMedianHistogramInner.process(input, output, radius, work);
            }
            ImplMedianSortEdgeNaive.process((GrayI)input, (GrayI)output, radius, offset);
        }
        return output;
    }

    public static GrayF32 median(GrayF32 input, @Nullable GrayF32 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), radius);
        if (!processed) {
            ImplMedianSortNaive.process(input, output, radius, null);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> median(Planar<T> input, @Nullable Planar<T> output, int radius, @Nullable WorkArrays work) {
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), output.getBand(band), radius, work);
        }
        return output;
    }

    public static GrayU8 gaussian(GrayU8 input, @Nullable GrayU8 output, double sigma, int radius, @Nullable GrayU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (GrayU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (GrayU8)InputSanityCheck.checkDeclare((ImageGray)input, (ImageGray)storage, GrayU8.class));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, (GrayI8)storage);
            ConvolveImageNormalized.vertical(kernel, storage, (GrayI8)output);
        }
        return output;
    }

    public static GrayU16 gaussian(GrayU16 input, @Nullable GrayU16 output, double sigma, int radius, @Nullable GrayU16 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (GrayU16)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (GrayU16)InputSanityCheck.checkDeclare((ImageGray)input, (ImageGray)storage, GrayU16.class));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, (GrayI16)storage);
            ConvolveImageNormalized.vertical(kernel, storage, (GrayI16)output);
        }
        return output;
    }

    public static InterleavedU8 gaussian(InterleavedU8 input, @Nullable InterleavedU8 output, double sigma, int radius, InterleavedU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (InterleavedU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (InterleavedU8)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, (InterleavedI8)storage);
            ConvolveImageNormalized.vertical(kernel, storage, (InterleavedI8)output);
        }
        return output;
    }

    public static InterleavedU16 gaussian(InterleavedU16 input, @Nullable InterleavedU16 output, double sigma, int radius, InterleavedU16 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (InterleavedU16)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (InterleavedU16)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, (InterleavedI16)storage);
            ConvolveImageNormalized.vertical(kernel, storage, (InterleavedI16)output);
        }
        return output;
    }

    public static GrayF32 gaussian(GrayF32 input, @Nullable GrayF32 output, double sigma, int radius, @Nullable GrayF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (GrayF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static GrayF64 gaussian(GrayF64 input, @Nullable GrayF64 output, double sigma, int radius, @Nullable GrayF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (GrayF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static InterleavedF32 gaussian(InterleavedF32 input, @Nullable InterleavedF32 output, double sigma, int radius, @Nullable InterleavedF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (InterleavedF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (InterleavedF32)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static InterleavedF64 gaussian(InterleavedF64 input, @Nullable InterleavedF64 output, double sigma, int radius, @Nullable InterleavedF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = (InterleavedF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)output), sigma, radius, storage = (InterleavedF64)InputSanityCheck.checkDeclare((ImageBase)input, (ImageBase)storage));
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> gaussian(Planar<T> input, @Nullable Planar<T> output, double sigma, int radius, @Nullable T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand((Class)input.getBandType(), (int)input.width, (int)input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), output.getBand(band), sigma, radius, storage);
        }
        return output;
    }
}

