/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.BOverrideConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean;
import boofcv.alg.filter.convolve.noborder.ImplConvolveMean_MT;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder_SB;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import javax.annotation.Nullable;

public class ConvolveImageMean {
    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
            if (kernel.width > input.width) {
                ConvolveImageNormalized.horizontal(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.horizontal(input, output, radius);
                } else {
                    ImplConvolveMean.horizontal(input, output, radius);
                }
            }
        }
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius, @Nullable FWorkArrays work) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, true);
            if (kernel.width > input.height) {
                ConvolveImageNormalized.vertical(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.vertical(input, output, radius, work);
                } else {
                    ImplConvolveMean.vertical(input, output, radius, work);
                }
            }
        }
    }

    public static void horizontal(GrayF64 input, GrayF64 output, int radius) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernel.table1D_F64(radius, true);
            if (kernel.width > input.width) {
                ConvolveImageNormalized.horizontal(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.horizontal(input, output, radius);
                } else {
                    ImplConvolveMean.horizontal(input, output, radius);
                }
            }
        }
    }

    public static void vertical(GrayF64 input, GrayF64 output, int radius, @Nullable DWorkArrays work) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernel.table1D_F64(radius, true);
            if (kernel.width > input.height) {
                ConvolveImageNormalized.vertical(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.vertical(input, output, radius, work);
                } else {
                    ImplConvolveMean.vertical(input, output, radius, work);
                }
            }
        }
    }

    public static void horizontal(GrayU8 input, GrayU8 output, int radius) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.width) {
                ConvolveImageNormalized.horizontal(kernel, input, (GrayI8)output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, (GrayI8)output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.horizontal(input, (GrayI8)output, radius);
                } else {
                    ImplConvolveMean.horizontal(input, (GrayI8)output, radius);
                }
            }
        }
    }

    public static void vertical(GrayU8 input, GrayI8 output, int radius, @Nullable IWorkArrays work) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.height) {
                ConvolveImageNormalized.vertical(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.vertical(input, output, radius, work);
                } else {
                    ImplConvolveMean.vertical(input, output, radius, work);
                }
            }
        }
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.width) {
                ConvolveImageNormalized.horizontal(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.horizontal(input, output, radius);
                } else {
                    ImplConvolveMean.horizontal(input, output, radius);
                }
            }
        }
    }

    public static void horizontal(GrayU16 input, GrayI16 output, int radius) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeHorizontal((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.width) {
                ConvolveImageNormalized.horizontal(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.horizontal(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.horizontal(input, output, radius);
                } else {
                    ImplConvolveMean.horizontal(input, output, radius);
                }
            }
        }
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius, @Nullable IWorkArrays work) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.height) {
                ConvolveImageNormalized.vertical(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.vertical(input, output, radius, work);
                } else {
                    ImplConvolveMean.vertical(input, output, radius, work);
                }
            }
        }
    }

    public static void vertical(GrayU16 input, GrayI16 output, int radius, @Nullable IWorkArrays work) {
        boolean processed = BOverrideConvolveImageMean.invokeNativeVertical((ImageBase)input, (ImageBase)output, radius);
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernel.table1D_I32(radius);
            if (kernel.width > input.height) {
                ConvolveImageNormalized.vertical(kernel, input, output);
            } else {
                InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)output);
                ConvolveNormalized_JustBorder_SB.vertical(kernel, input, output);
                if (BoofConcurrency.USE_CONCURRENT) {
                    ImplConvolveMean_MT.vertical(input, output, radius, work);
                } else {
                    ImplConvolveMean.vertical(input, output, radius, work);
                }
            }
        }
    }
}

